/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.datasource;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.enums.DataBaseType;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.SchemaService;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SchemeServiceManager {
    private final Map<DataBaseType, SchemaService> schemaServiceMap = Maps.newConcurrentMap();

    public SchemeServiceManager(List<SchemaService> schemaServices) {
        for (SchemaService schemaService : schemaServices) {
            this.schemaServiceMap.put(schemaService.getSchemaType(), schemaService);
        }
    }

    public SchemaService getSchemaService(DataBaseType dataBaseType) {
        return Optional.ofNullable(this.schemaServiceMap.get(dataBaseType)).orElseThrow(() -> new RuntimeException("Can not find any  schemaService !"));
    }
}

