/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.datasource.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.DataSourceConfig;
import com.xforceplus.ultraman.bocp.metadata.enums.DataBaseType;
import com.xforceplus.ultraman.bocp.metadata.enums.DataValueType;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.impl.AbstractSchemaService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SchemaServiceMysqlImpl
extends AbstractSchemaService {
    @Override
    public DataBaseType getSchemaType() {
        return DataBaseType.MySql;
    }

    @Override
    protected Map<String, DataValueType> getValueMapping() {
        return new HashMap<String, DataValueType>(){
            {
                this.put("varchar", DataValueType.STRING);
                this.put("bigint", DataValueType.LONG);
                this.put("longtext", DataValueType.STRING);
                this.put("int", DataValueType.LONG);
                this.put("tinyint", DataValueType.LONG);
                this.put("decimal", DataValueType.BIG_DECIMAL);
                this.put("double", DataValueType.BIG_DECIMAL);
                this.put("char", DataValueType.STRING);
                this.put("date", DataValueType.STRING);
                this.put("text", DataValueType.STRING);
                this.put("mediumtext", DataValueType.STRING);
                this.put("longblob", DataValueType.STRING);
                this.put("smallint", DataValueType.LONG);
                this.put("blob", DataValueType.STRING);
                this.put("float", DataValueType.BIG_DECIMAL);
                this.put("time", DataValueType.STRING);
                this.put("year", DataValueType.LONG);
                this.put("datetime", DataValueType.STRING);
                this.put("timestamp", DataValueType.LOCAL_DATE_TIME);
                this.put("tinyblob", DataValueType.STRING);
                this.put("tinytext", DataValueType.STRING);
            }
        };
    }

    @Override
    protected String getQueryColumnSql() {
        return "select table_name as tableName,column_name as columnName,data_type as columnType,column_comment as columnComment from information_schema.COLUMNS where table_schema = ? and table_name = ?";
    }

    @Override
    protected String getQueryTableSql() {
        return "SELECT TABLE_NAME as tableName,TABLE_COMMENT as tableComment,TABLE_SCHEMA as databaseName FROM information_schema.tables WHERE table_schema = ?";
    }

    @Override
    protected String getJdbcUrl(DataSourceConfig config) {
        String url = "jdbc:mysql://" + config.getHost() + ":" + config.getPort();
        if (config.getSchema() != null && !config.getSchema().isEmpty()) {
            url = url + "/" + config.getSchema();
        }
        return url;
    }
}

