/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.datasource.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.DataSourceConfig;
import com.xforceplus.ultraman.bocp.metadata.enums.DataBaseType;
import com.xforceplus.ultraman.bocp.metadata.enums.DataValueType;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.impl.AbstractSchemaService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SchemaServiceOracleImpl
extends AbstractSchemaService {
    @Override
    public DataBaseType getSchemaType() {
        return DataBaseType.Oracle;
    }

    @Override
    protected Map<String, DataValueType> getValueMapping() {
        return new HashMap<String, DataValueType>(){
            {
                this.put("char", DataValueType.STRING);
                this.put("nchar", DataValueType.STRING);
                this.put("varchar2", DataValueType.STRING);
                this.put("nvarchar2", DataValueType.STRING);
                this.put("clob", DataValueType.STRING);
                this.put("nclob", DataValueType.STRING);
                this.put("number", DataValueType.BIG_DECIMAL);
                this.put("binary_float", DataValueType.BIG_DECIMAL);
                this.put("binary_double", DataValueType.BIG_DECIMAL);
                this.put("date", DataValueType.STRING);
                this.put("timestamp", DataValueType.LOCAL_DATE_TIME);
                this.put("timestamp with time zone", DataValueType.LOCAL_DATE_TIME);
                this.put("timestamp with local time zone", DataValueType.LOCAL_DATE_TIME);
                this.put("interval year to month", DataValueType.LONG);
                this.put("interval day to second", DataValueType.LONG);
                this.put("blob", DataValueType.STRING);
                this.put("raw", DataValueType.STRING);
                this.put("long raw", DataValueType.STRING);
                this.put("long", DataValueType.STRING);
                this.put("rowid", DataValueType.STRING);
                this.put("urowid", DataValueType.STRING);
                this.put("bfile", DataValueType.STRING);
                this.put("float", DataValueType.BIG_DECIMAL);
                this.put("integer", DataValueType.LONG);
                this.put("smallint", DataValueType.LONG);
                this.put("real", DataValueType.BIG_DECIMAL);
            }
        };
    }

    @Override
    protected String getQueryColumnSql() {
        return "SELECT cols.table_name AS tableName, cols.column_name AS columnName, cols.data_type AS columnType, cols.data_default AS columnDefault, cols.nullable AS nullable, com.comments AS columnComment FROM all_tab_columns cols LEFT JOIN all_col_comments com ON cols.table_name = com.table_name AND cols.column_name = com.column_name WHERE cols.owner = ? AND cols.table_name = ?";
    }

    @Override
    protected String getQueryTableSql() {
        return "SELECT tabs.table_name AS tableName, tabs.tablespace_name AS databaseName, com.comments AS tableComment FROM all_tables tabs LEFT JOIN all_tab_comments com ON tabs.table_name = com.table_name WHERE tabs.owner = ?";
    }

    @Override
    protected String getJdbcUrl(DataSourceConfig config) {
        String url = "jdbc:oracle:thin:@" + config.getUrl() + ":" + config.getPort();
        if (config.getSchema() != null && !config.getSchema().isEmpty()) {
            url = url + ":" + config.getSchema();
        }
        return url;
    }
}

