/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.datasource.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.DataSourceConfig;
import com.xforceplus.ultraman.bocp.metadata.enums.DataBaseType;
import com.xforceplus.ultraman.bocp.metadata.enums.DataValueType;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.impl.AbstractSchemaService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SchemaServicePostgresqlImpl
extends AbstractSchemaService {
    @Override
    public DataBaseType getSchemaType() {
        return DataBaseType.PostgreSQL;
    }

    @Override
    protected Map<String, DataValueType> getValueMapping() {
        return new HashMap<String, DataValueType>(){
            {
                this.put("char", DataValueType.STRING);
                this.put("character", DataValueType.STRING);
                this.put("varchar", DataValueType.STRING);
                this.put("character varying", DataValueType.STRING);
                this.put("text", DataValueType.STRING);
                this.put("bigint", DataValueType.LONG);
                this.put("longtext", DataValueType.STRING);
                this.put("integer", DataValueType.LONG);
                this.put("tinyint", DataValueType.LONG);
                this.put("decimal", DataValueType.BIG_DECIMAL);
                this.put("double", DataValueType.BIG_DECIMAL);
                this.put("numeric", DataValueType.BIG_DECIMAL);
                this.put("real", DataValueType.BIG_DECIMAL);
                this.put("double precision", DataValueType.BIG_DECIMAL);
                this.put("smallint", DataValueType.LONG);
                this.put("smallserial", DataValueType.LONG);
                this.put("serial", DataValueType.LONG);
                this.put("bigserial", DataValueType.LONG);
                this.put("money", DataValueType.BIG_DECIMAL);
                this.put("date", DataValueType.STRING);
                this.put("time", DataValueType.STRING);
                this.put("year", DataValueType.LONG);
                this.put("datetime", DataValueType.STRING);
                this.put("timestamp", DataValueType.LOCAL_DATE_TIME);
                this.put("interval", DataValueType.STRING);
                this.put("cidr", DataValueType.STRING);
                this.put("inet", DataValueType.STRING);
                this.put("macaddr", DataValueType.STRING);
                this.put("uuid", DataValueType.STRING);
                this.put("json", DataValueType.STRING);
                this.put("bytea", DataValueType.STRING);
                this.put("tinytext", DataValueType.STRING);
            }
        };
    }

    @Override
    protected String getQueryColumnSql() {
        return "SELECT cols.table_name as tableName, cols.column_name as columnName, cols.data_type as columnType, ( SELECT pg_catalog.col_description ( C.oid, cols.ordinal_position :: INT ) FROM pg_catalog.pg_class C WHERE C.oid = ( SELECT cols.TABLE_NAME :: regclass :: oid ) AND C.relname = cols.TABLE_NAME ) AS columnComment FROM information_schema.COLUMNS cols WHERE cols.table_catalog = ? AND cols.table_schema = ? AND cols.TABLE_NAME = ?";
    }

    @Override
    protected String getQueryTableSql() {
        return "SELECT tb.TABLE_NAME AS tableName, obj_description ( pg.oid ) AS tableComment, tb.table_schema AS databaseName FROM information_schema.tables tb INNER JOIN pg_class pg ON pg.relname = tb.TABLE_NAME where tb.table_schema = ?";
    }

    @Override
    protected String getJdbcUrl(DataSourceConfig config) {
        String url = "jdbc:postgresql://" + config.getUrl() + ":" + config.getPort();
        if (config.getSchema() != null && !config.getSchema().isEmpty()) {
            url = url + "/" + config.getSchema();
        }
        return url;
    }
}

