/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.datasource.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.DataSourceConfig;
import com.xforceplus.ultraman.bocp.metadata.enums.DataBaseType;
import com.xforceplus.ultraman.bocp.metadata.enums.DataValueType;
import com.xforceplus.ultraman.bocp.metadata.web.datasource.impl.AbstractSchemaService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SchemaServiceSqlServerImpl
extends AbstractSchemaService {
    @Override
    public DataBaseType getSchemaType() {
        return DataBaseType.SQLServer;
    }

    @Override
    protected Map<String, DataValueType> getValueMapping() {
        return new HashMap<String, DataValueType>(){
            {
                this.put("varchar", DataValueType.STRING);
                this.put("bigint", DataValueType.LONG);
                this.put("int", DataValueType.LONG);
                this.put("tinyint", DataValueType.LONG);
                this.put("decimal", DataValueType.BIG_DECIMAL);
                this.put("double", DataValueType.BIG_DECIMAL);
                this.put("char", DataValueType.STRING);
                this.put("date", DataValueType.STRING);
                this.put("text", DataValueType.STRING);
                this.put("smallint", DataValueType.LONG);
                this.put("float", DataValueType.BIG_DECIMAL);
                this.put("datetime", DataValueType.STRING);
                this.put("timestamp", DataValueType.LOCAL_DATE_TIME);
            }
        };
    }

    @Override
    protected String getQueryColumnSql() {
        return "SELECT TABLE_NAME AS tableName, COLUMN_NAME AS columnName, DATA_TYPE AS columnType, (SELECT value FROM fn_listextendedproperty('MS_Description', 'schema', 'dbo', 'table', TABLE_NAME, 'column', COLUMN_NAME)) AS columnComment FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ?";
    }

    @Override
    protected String getQueryTableSql() {
        return "SELECT TABLE_NAME AS tableName, (SELECT value FROM fn_listextendedproperty('MS_Description', 'schema', 'dbo', 'table', TABLE_NAME, null, null)) AS tableComment, TABLE_CATALOG AS databaseName FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'BASE TABLE'";
    }

    @Override
    protected String getJdbcUrl(DataSourceConfig config) {
        String url = "jdbc:sqlserver://" + config.getUrl() + ":" + config.getPort();
        if (config.getSchema() != null && !config.getSchema().isEmpty()) {
            url = url + ";DatabaseName=" + config.getSchema();
        }
        return url;
    }
}

