/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.command.handler;

import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.service.IDictExService;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.StandardAppMetadataValidator;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.command.RemoveDictCommand;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.CommandHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class RemoveDictCommandHandler
implements CommandHandler<RemoveDictCommand, ServiceResponse> {
    @Autowired
    private IDictExService dictExService;
    @Autowired
    private StandardAppMetadataValidator standardAppMetadataValidator;

    @Override
    public ServiceResponse handleStandard(RemoveDictCommand command) {
        this.standardAppMetadataValidator.validateWhenStdDictRemove(command.getDictId());
        return this.dictExService.logicRemoveById(command.getDictId());
    }

    @Override
    public ServiceResponse handleTenant(RemoveDictCommand command) {
        return this.dictExService.logicRemoveById(command.getDictId());
    }

    @Override
    public ServiceResponse handleCustom(RemoveDictCommand command) {
        return null;
    }
}

