/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.command.handler;

import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.service.IAppModuleExService;
import com.xforceplus.ultraman.bocp.metadata.system.SystemSettingsHolder;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.command.SaveBoCommand;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.CommandHandler;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantBoExService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class SaveBoCommandHandler
implements CommandHandler<SaveBoCommand, ServiceResponse> {
    @Autowired
    private SystemSettingsHolder systemSettingsHolder;
    @Autowired
    private IAppModuleExService appModuleExService;
    @Autowired
    private ITenantBoExService tenantBoExService;

    @Override
    public ServiceResponse handleStandard(SaveBoCommand command) {
        BoInfoVo boInfoVo = command.getBoInfoVo();
        if (this.systemSettingsHolder.getSystemBoCodes().contains(boInfoVo.getCode())) {
            return ServiceResponse.fail((String)String.format("\u5bf9\u8c61\u4ee3\u7801 %s \u5c5e\u4e8e\u7cfb\u7edf\u4fdd\u7559\u5b57\u4e0d\u5141\u8bb8\u4f7f\u7528", boInfoVo.getCode()));
        }
        return this.appModuleExService.saveBo(command.getAppId(), boInfoVo);
    }

    @Override
    public ServiceResponse handleTenant(SaveBoCommand command) {
        BoInfoVo boInfoVo = command.getBoInfoVo();
        return this.tenantBoExService.saveBo(command.getAppId(), boInfoVo);
    }

    @Override
    public ServiceResponse handleCustom(SaveBoCommand command) {
        return null;
    }
}

