/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.service.IAppModuleExService;
import com.xforceplus.ultraman.bocp.metadata.vo.BoEx;
import com.xforceplus.ultraman.bocp.metadata.vo.QueryBoVo;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.BoPageQuery;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantBoExService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BoPageQueryHandler
implements QueryHandler<BoPageQuery, IPage<BoEx>> {
    @Autowired
    private IAppModuleExService appModuleExService;
    @Autowired
    private ITenantBoExService tenantBoExService;

    @Override
    public IPage<BoEx> handleStandard(BoPageQuery query) {
        return this.appModuleExService.queryBos(query.getPage(), query.getQueryBoVo()).convert(o -> o.setAppCustomType(AppCustomType.STANDARD.code()));
    }

    @Override
    public IPage<BoEx> handleTenant(BoPageQuery query) {
        QueryBoVo queryBoVo = query.getQueryBoVo();
        List data = this.tenantBoExService.getBos(queryBoVo.getAppId());
        if (null != queryBoVo.getId()) {
            data = data.stream().filter(r -> queryBoVo.getId().equals(r.getId())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryBoVo.getNameOrCode())) {
            data = data.stream().filter(r -> r.getName().contains(queryBoVo.getNameOrCode()) || r.getCode().contains(queryBoVo.getNameOrCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryBoVo.getBoCode())) {
            data = data.stream().filter(r -> queryBoVo.getBoCode().equals(r.getCode())).collect(Collectors.toList());
        }
        data = StringUtils.isNotBlank((CharSequence)queryBoVo.getBoType()) ? data.stream().filter(r -> queryBoVo.getBoType().equals(r.getBoType())).collect(Collectors.toList()) : data.stream().filter(r -> BoType.ENTITY.code().equals(r.getBoType()) || BoType.EXTERNAL.code().equals(r.getBoType())).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)queryBoVo.getAppCustomType())) {
            data = data.stream().filter(r -> queryBoVo.getAppCustomType().equals(r.getAppCustomType())).collect(Collectors.toList());
        }
        return this.pageResult((int)query.getPage().getCurrent(), (int)query.getPage().getSize(), data);
    }

    @Override
    public IPage<BoEx> handleCustom(BoPageQuery query) {
        return null;
    }
}

