/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.xforceplus.ultraman.bocp.metadata.flow.mapstruct.FlowSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.flow.vo.FlowSettingVo;
import com.xforceplus.ultraman.bocp.metadata.service.IFlowSettingExService;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.FlowPageQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantFlowSettingExService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowPageQueryHandler
implements QueryHandler<FlowPageQuery, IPage<FlowSettingVo>> {
    @Autowired
    private IFlowSettingExService flowSettingExService;
    @Autowired
    private ITenantFlowSettingExService tenantFlowSettingExService;

    @Override
    public IPage<FlowSettingVo> handleStandard(FlowPageQuery query) {
        return this.flowSettingExService.queryFlows(query.getPage(), (FlowSetting)query.getFlowSettingVo()).convert(o -> {
            FlowSettingVo vo = FlowSettingStructMapper.MAPPER.toVo(o);
            vo.setAppCustomType(AppCustomType.STANDARD.code());
            return vo;
        });
    }

    @Override
    public IPage<FlowSettingVo> handleTenant(FlowPageQuery query) {
        FlowSettingVo flowSettingVo = query.getFlowSettingVo();
        List data = this.tenantFlowSettingExService.getFlowVos((FlowSetting)flowSettingVo);
        if (StringUtils.isNotBlank((CharSequence)flowSettingVo.getFlowType())) {
            data = data.stream().filter(r -> flowSettingVo.getFlowType().equals(r.getFlowType())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)flowSettingVo.getCode())) {
            data = data.stream().filter(r -> r.getCode().contains(flowSettingVo.getCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)flowSettingVo.getName())) {
            data = data.stream().filter(r -> r.getName().contains(flowSettingVo.getName())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)flowSettingVo.getAppCustomType())) {
            data = data.stream().filter(r -> flowSettingVo.getAppCustomType().equals(r.getAppCustomType())).collect(Collectors.toList());
        }
        return this.pageResult((int)query.getPage().getCurrent(), (int)query.getPage().getSize(), data);
    }

    @Override
    public IPage<FlowSettingVo> handleCustom(FlowPageQuery query) {
        return null;
    }
}

