/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageSettingStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.service.IUltPageSettingExService;
import com.xforceplus.ultraman.bocp.metadata.view.vo.UltPageSettingExVo;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.GetPageSettingsQuery;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantUltPageSettingExService;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetPageSettingsQueryHandler
implements QueryHandler<GetPageSettingsQuery, List<UltPageSettingExVo>> {
    @Autowired
    private IUltPageSettingExService ultPageExService;
    @Autowired
    private ITenantUltPageSettingExService tenantUltPageSettingExService;

    @Override
    public List<UltPageSettingExVo> handleStandard(GetPageSettingsQuery query) {
        return this.ultPageExService.getPages(query.getUltPageSetting()).stream().map(o -> {
            UltPageSettingExVo ultPageExVo = UltPageSettingStructMapper.MAPPER.toUltPageSettingExVo(o);
            ultPageExVo.setAppCustomType(AppCustomType.STANDARD.code());
            return ultPageExVo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<UltPageSettingExVo> handleTenant(GetPageSettingsQuery query) {
        UltPageSetting ultPage = query.getUltPageSetting();
        List result = this.tenantUltPageSettingExService.getPages(ultPage);
        if (StringUtils.isNotBlank((CharSequence)ultPage.getCode())) {
            result = result.stream().filter(r -> r.getName().contains(ultPage.getCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)ultPage.getName())) {
            result = result.stream().filter(r -> r.getName().contains(ultPage.getName())).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<UltPageSettingExVo> handleCustom(GetPageSettingsQuery query) {
        return null;
    }
}

