/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.handler;

import com.xforceplus.ultraman.bocp.metadata.view.mapstruct.UltPageStructMapper;
import com.xforceplus.ultraman.bocp.metadata.view.service.IUltPageExService;
import com.xforceplus.ultraman.bocp.metadata.view.vo.UltPageExVo;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.core.QueryHandler;
import com.xforceplus.ultraman.bocp.metadata.web.dispatch.query.GetPagesQuery;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantUltPageExService;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetPagesQueryHandler
implements QueryHandler<GetPagesQuery, List<UltPageExVo>> {
    @Autowired
    private IUltPageExService ultPageExService;
    @Autowired
    private ITenantUltPageExService tenantUltPageExService;

    @Override
    public List<UltPageExVo> handleStandard(GetPagesQuery query) {
        return this.ultPageExService.getPages(query.getUltPage()).stream().map(o -> {
            UltPageExVo ultPageExVo = UltPageStructMapper.MAPPER.toUltPageExVo(o);
            ultPageExVo.setAppCustomType(AppCustomType.STANDARD.code());
            return ultPageExVo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<UltPageExVo> handleTenant(GetPagesQuery query) {
        UltPage ultPage = query.getUltPage();
        List result = this.tenantUltPageExService.getPages(ultPage);
        if (StringUtils.isNotBlank((CharSequence)ultPage.getCode())) {
            result = result.stream().filter(r -> r.getName().contains(ultPage.getCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)ultPage.getName())) {
            result = result.stream().filter(r -> r.getName().contains(ultPage.getName())).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<UltPageExVo> handleCustom(GetPagesQuery query) {
        return null;
    }
}

