/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.common.CommonBusiness;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.entity.BodyDetail;
import com.xforceplus.ultraman.bocp.metadata.enums.AppVersionType;
import com.xforceplus.ultraman.bocp.metadata.enums.ArrayType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.exception.ServiceException;
import com.xforceplus.ultraman.bocp.metadata.util.FormatUtil;
import com.xforceplus.ultraman.bocp.metadata.validator.CommonValidator;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionPublishService;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.metadata.vo.AppPackageVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.web.service.IOuterServicesService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldValidate;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.ModuleBo;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.AppMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoFieldAttributeMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoFieldMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoFieldValidateMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoRelationshipMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.DictDetailMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.ModuleBoMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.ModuleMapper;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.bocp.mapper.OuterServicesApiMapper;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import com.xplat.ultraman.api.management.commons.dto.Attribute;
import com.xplat.ultraman.api.management.commons.dto.FullyObject;
import com.xplat.ultraman.api.management.commons.dto.MetaRelationInfo;
import com.xplat.ultraman.api.management.commons.dto.ObjectOutLine;
import com.xplat.ultraman.api.management.commons.enums.ValueType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

@Service
public class OuterServicesServiceImpl
implements IOuterServicesService {
    @Autowired
    private ModuleMapper moduleMapper;
    @Autowired
    private BoMapper boMapper;
    @Autowired
    private ModuleBoMapper moduleBoMapper;
    @Autowired
    private BoRelationshipMapper boRelationshipMapper;
    @Autowired
    private DictDetailMapper dictDetailMapper;
    @Autowired
    private OuterServicesApiMapper outerServicesApiMapper;
    @Autowired
    private AppMapper appMapper;
    @Autowired
    private BoFieldMapper boFieldMapper;
    @Autowired
    private BoFieldAttributeMapper boFieldAttributeMapper;
    @Autowired
    private BoFieldValidateMapper boFieldValidateMapper;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TransactionDefinition transactionDefinition;
    @Autowired
    private CommonValidator commonValidator;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private IAppVersionPublishService appVersionPublishService;

    @Override
    @SkipDataAuth
    public ServiceResponse getApiBody(Long boId, String version) {
        Wrapper boWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"publish_flag", (Object)PublishFlag.PUBLISHED.code())).eq((Object)"publish_bo_id", (Object)boId)).eq((Object)"bo_type", (Object)BoType.DTO.code())).eq((Object)"version", (Object)version)).eq((Object)"delete_flag", (Object)"1");
        List rootBos = this.boMapper.selectList(boWrapper);
        if (rootBos.size() == 0) {
            return ServiceResponse.success((String)"\u83b7\u53d6\u6210\u529f", (Object)Lists.newArrayList());
        }
        if (rootBos.size() != 1) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u591a\u4e2a\u6839\u5bf9\u8c61\uff0c\u6570\u636e\u6709\u95ee\u9898");
        }
        Bo rootBo = (Bo)rootBos.get(0);
        List<FullyObject> result = this.recursiveGetBo(rootBo.getId());
        FullyObject rootFullyObject = new FullyObject();
        rootFullyObject.setRequired(Boolean.valueOf(true));
        rootFullyObject.setType(ValueType.OBJECT);
        rootFullyObject.setCode(rootBo.getCode());
        rootFullyObject.setDesc(rootBo.getName());
        rootFullyObject.setChildren(result);
        return ServiceResponse.success((String)"\u83b7\u53d6\u6210\u529f", (Object)Lists.newArrayList((Object[])new FullyObject[]{rootFullyObject}));
    }

    @Override
    @SkipDataAuth
    public List<ObjectOutLine> queryApiRootBodys(Long appId, String metaName) {
        return this.outerServicesApiMapper.queryRootBodys(appId, metaName);
    }

    @Override
    @SkipDataAuth
    public Map<String, List<ObjectOutLine>> queryPublishedBoInfos(Long appId, String metaName) {
        HashMap data = Maps.newHashMap();
        data.put("dto", this.outerServicesApiMapper.queryVersionedBosInfo(appId, metaName, "dto"));
        data.put("entity", this.outerServicesApiMapper.queryVersionedBosInfo(appId, metaName, "entity"));
        return data;
    }

    @Override
    @SkipDataAuth
    public ServiceResponse getPublishedBoDetail(Long boId, String version) {
        Wrapper boWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"publish_flag", (Object)PublishFlag.PUBLISHED.code())).eq((Object)"publish_bo_id", (Object)boId)).eq((Object)"version", (Object)version)).eq((Object)"delete_flag", (Object)"1");
        List rootBos = this.boMapper.selectList(boWrapper);
        if (rootBos.size() == 0) {
            return ServiceResponse.success((String)"\u83b7\u53d6\u6210\u529f", (Object)Maps.newHashMap());
        }
        if (rootBos.size() != 1) {
            return ServiceResponse.fail((String)"\u67e5\u8be2\u5230\u591a\u4e2a\u6839\u5bf9\u8c61\uff0c\u6570\u636e\u6709\u95ee\u9898");
        }
        Bo rootBo = (Bo)rootBos.get(0);
        List<Object> data = Lists.newArrayList();
        if (BoType.DTO.code().equals(rootBo.getBoType())) {
            data = this.recursiveGetBo(rootBo.getId());
        } else if (BoType.ENTITY.code().equals(rootBo.getBoType()) || BoType.EXTERNAL.code().equals(rootBo.getBoType())) {
            List boFields = this.outerServicesApiMapper.getBodyDetails(boId);
            for (BodyDetail boField : boFields) {
                data.add(this.newFullyObject(boField));
            }
        }
        FullyObject rootObject = new FullyObject();
        rootObject.setRequired(Boolean.valueOf(false));
        rootObject.setType(ValueType.OBJECT);
        rootObject.setCode(rootBo.getCode());
        rootObject.setDesc(rootBo.getName());
        rootObject.setChildren(data);
        return ServiceResponse.success((String)"\u83b7\u53d6\u6210\u529f", (Object)Lists.newArrayList((Object[])new FullyObject[]{rootObject}));
    }

    @Override
    @SkipDataAuth
    public List<ObjectOutLine> createBos(Long appId, List<MetaRelationInfo> metaRelationInfos) {
        List moduleIds = this.defaultModuleService.getModuleIds(appId.longValue());
        if (moduleIds == null || moduleIds.isEmpty()) {
            return Lists.newArrayList();
        }
        Long moduleId = (Long)moduleIds.get(0);
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.transactionManager.getTransaction(this.transactionDefinition);
            ArrayList boList = Lists.newArrayList();
            HashMap toOneMap = Maps.newHashMap();
            HashMap toManyMap = Maps.newHashMap();
            HashMap boCodeIdMap = Maps.newHashMap();
            metaRelationInfos.forEach(metaInfo -> {
                BoInfoVo boInfoVo = new BoInfoVo();
                boInfoVo.setName(metaInfo.getMetaObjectName());
                boInfoVo.setCode(metaInfo.getMetaObjectCode());
                boInfoVo.setBoType(BoType.DTO.code());
                boInfoVo.setAppId(appId);
                ArrayList boFieldVos = Lists.newArrayList();
                metaInfo.getElements().forEach(element -> {
                    BoFieldVo boFieldVo = new BoFieldVo();
                    boFieldVo.setName(element.getDesc());
                    boFieldVo.setCode(element.getCode());
                    boFieldVo.setRequired(element.getRequired());
                    boFieldVo.setDefaultValue(element.getDefaultValue() == null ? null : (String)element.getDefaultValue());
                    if (ValueType.ARRAY == element.getType()) {
                        boFieldVo.setIsArray(Boolean.valueOf(true));
                        boFieldVo.setType(this.convertType(element.getSubType()));
                    } else {
                        boFieldVo.setIsArray(Boolean.valueOf(false));
                        boFieldVo.setType(this.convertType(element.getType()));
                    }
                    boFieldVos.add(boFieldVo);
                });
                boInfoVo.setFields((List)boFieldVos);
                Bo bo = this.saveBo(moduleId, boInfoVo);
                boList.add(bo);
                toOneMap.put(bo.getId(), metaInfo.getToOneRel());
                toManyMap.put(bo.getId(), metaInfo.getToManyRel());
                boCodeIdMap.put(bo.getCode(), bo);
            });
            boList.forEach(bo -> {
                List toManyRels;
                List toOneRels = (List)toOneMap.get(bo.getId());
                if (toOneRels != null && !toOneRels.isEmpty()) {
                    toOneRels.forEach(toOneRel -> {
                        Bo joinBo = boCodeIdMap.containsKey(toOneRel) ? (Bo)boCodeIdMap.get(toOneRel) : new Bo();
                        BoRelationship boRelationship = this.createBoRelationship((Bo)bo, joinBo, "OneToOne");
                        this.boRelationshipMapper.insert((Object)boRelationship);
                    });
                }
                if ((toManyRels = (List)toManyMap.get(bo.getId())) != null && !toManyRels.isEmpty()) {
                    toManyRels.forEach(toManyRel -> {
                        Bo joinBo = boCodeIdMap.containsKey(toManyRel) ? (Bo)boCodeIdMap.get(toManyRel) : new Bo();
                        BoRelationship boRelationship = this.createBoRelationship((Bo)bo, joinBo, "OneToMany");
                        this.boRelationshipMapper.insert((Object)boRelationship);
                    });
                }
            });
            this.transactionManager.commit(transactionStatus);
        }
        catch (ServiceException se) {
            this.transactionManager.rollback(transactionStatus);
        }
        catch (Exception e) {
            this.transactionManager.rollback(transactionStatus);
        }
        PublishContent publishContent = new PublishContent();
        publishContent.setAppId(appId);
        publishContent.setVersionType(AppVersionType.SMALL.code());
        this.appVersionPublishService.publishAppVersion(publishContent);
        return this.outerServicesApiMapper.queryVersionedBosInfo(appId, null, "dto");
    }

    @Override
    @SkipDataAuth
    public ServiceResponse getAppPackageInfo(Long appId) {
        App app = (App)this.appMapper.selectById((Serializable)appId);
        if (app == null) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u5e94\u7528");
        }
        List moduleIds = this.defaultModuleService.getModuleIds(appId.longValue());
        if (moduleIds == null || moduleIds.isEmpty()) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u6a21\u5757");
        }
        Module module = (Module)this.moduleMapper.selectById((Serializable)moduleIds.get(0));
        if (module == null) {
            return ServiceResponse.fail((String)"\u627e\u4e0d\u5230\u5e94\u7528\u76f8\u5173\u4fe1\u606f");
        }
        AppPackageVo appPackageVo = new AppPackageVo();
        appPackageVo.setAppCode(app.getCode());
        appPackageVo.setVersion(module.getVersion());
        appPackageVo.setGroupId("com.xforceplus");
        appPackageVo.setArtifactId(FormatUtil.lowerUnderscoreToLowerCamel((String)app.getCode()).toLowerCase());
        appPackageVo.setPackagePath(String.format("%s.%s.dto", appPackageVo.getGroupId(), appPackageVo.getArtifactId()));
        return ServiceResponse.success((String)"", (Object)appPackageVo);
    }

    private List<FullyObject> recursiveGetBo(Long boId) {
        ArrayList data = Lists.newArrayList();
        this.outerServicesApiMapper.getBodyDetails(boId).stream().forEach(bodyDetail -> data.add(this.newFullyObject((BodyDetail)bodyDetail)));
        Wrapper brWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bo_id", (Object)boId)).eq((Object)"delete_flag", (Object)"1")).in((Object)"relation_type", new Object[]{"OneToOne", "OneToMany", "ManyToOne"});
        List boRelationships = this.boRelationshipMapper.selectList(brWrapper);
        for (BoRelationship boRelationship : boRelationships) {
            List<FullyObject> children = this.recursiveGetBo(boRelationship.getJoinBoId());
            FullyObject fullyObject = new FullyObject();
            fullyObject.setRequired(Boolean.valueOf(true));
            fullyObject.setCode(boRelationship.getRelationCode());
            fullyObject.setDesc(boRelationship.getRelationName());
            fullyObject.setChildren(children);
            if ("OneToOne".equals(boRelationship.getRelationType()) || "ManyToOne".equals(boRelationship.getRelationType())) {
                fullyObject.setType(ValueType.OBJECT);
                fullyObject.setRequired(Boolean.valueOf(false));
            } else if ("OneToMany".equals(boRelationship.getRelationType())) {
                fullyObject.setType(ValueType.ARRAY);
                fullyObject.setRequired(Boolean.valueOf(false));
            }
            data.add(fullyObject);
        }
        return data;
    }

    private FullyObject newFullyObject(BodyDetail bodyDetail) {
        FullyObject fullyObject = new FullyObject();
        fullyObject.setCode(bodyDetail.getCode());
        fullyObject.setDesc(bodyDetail.getDesc());
        fullyObject.setDefaultValue(bodyDetail.getDefaultValue());
        fullyObject.setRequired(Boolean.valueOf("0".equals(bodyDetail.getRequired())));
        if (ArrayType.ARRAY.code().equals(bodyDetail.getArrayType())) {
            fullyObject.setType(ValueType.ARRAY);
            fullyObject.setSubType(this.convertType(bodyDetail.getType()));
        } else {
            fullyObject.setType(this.convertType(bodyDetail.getType()));
        }
        if (fullyObject.getType() != null && fullyObject.getType().equals((Object)ValueType.ENUM)) {
            Wrapper ddWrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dict_id", (Object)bodyDetail.getDictId())).eq((Object)"delete_flag", (Object)"1");
            List ranges = this.dictDetailMapper.selectList(ddWrapper).stream().map(dictDetail -> {
                Attribute.Range range = new Attribute.Range();
                range.setValue((Object)dictDetail.getCode());
                range.setText(dictDetail.getName());
                return range;
            }).collect(Collectors.toList());
            fullyObject.setRanges(ranges);
        }
        return fullyObject;
    }

    private ValueType convertType(String type) {
        ValueType valueType = null;
        switch (type) {
            case "long": {
                valueType = ValueType.LONG;
                break;
            }
            case "string": {
                valueType = ValueType.STRING;
                break;
            }
            case "strings": {
                valueType = ValueType.STRING;
                break;
            }
            case "serialNo": {
                valueType = ValueType.LONG;
                break;
            }
            case "double": {
                valueType = ValueType.BIG_DECIMAL;
                break;
            }
            case "decimal": {
                valueType = ValueType.BIG_DECIMAL;
                break;
            }
            case "timestamp": {
                valueType = ValueType.LOCAL_DATE_TIME;
                break;
            }
            case "enum": {
                valueType = ValueType.ENUM;
                break;
            }
            case "boolean": {
                valueType = ValueType.BOOLEAN;
                break;
            }
        }
        return valueType;
    }

    private String convertType(ValueType valueType) {
        String type = null;
        switch (valueType) {
            case ARRAY: {
                type = "";
                break;
            }
            case OBJECT: {
                type = "";
                break;
            }
            case ENUM: {
                type = "enum";
                break;
            }
            case LONG: {
                type = "long";
                break;
            }
            case STRING: {
                type = "string";
                break;
            }
            case BIG_DECIMAL: {
                type = "double";
                break;
            }
            case BOOLEAN: {
                type = "boolean";
                break;
            }
            case LOCAL_DATE_TIME: {
                type = "timestamp";
                break;
            }
        }
        return type;
    }

    private Bo saveBo(Long moduleId, BoInfoVo boInfo) {
        Wrapper boWrapper;
        List bos;
        List<Long> boIds = this.getBoIds(moduleId);
        if (!boIds.isEmpty() && !(bos = this.boMapper.selectList(boWrapper = (Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", boIds)).eq((Object)"publish_flag", (Object)PublishFlag.UNPUBLISHED.code())).eq((Object)"code", (Object)boInfo.getCode())).eq((Object)"delete_flag", (Object)"1")).eq((Object)"bo_type", (Object)BoType.DTO.code()))).isEmpty()) {
            return (Bo)bos.get(0);
        }
        Bo bo = BoStructMapper.MAPPER.toEntity(boInfo);
        bo.setBoType(BoType.DTO.code());
        bo.setSysType(StringUtils.isEmpty((CharSequence)boInfo.getSysType()) ? "user" : boInfo.getSysType());
        bo.setVersion("0.0.0");
        bo.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        bo.setStatus("1");
        bo.setLevel(Integer.valueOf(0));
        bo.setDeleteFlag("1");
        bo.setAppId(boInfo.getAppId());
        this.boMapper.insert((Object)bo);
        ModuleBo moduleBo = new ModuleBo();
        moduleBo.setModuleId(moduleId);
        moduleBo.setBoId(bo.getId());
        moduleBo.setDeleteFlag("1");
        this.moduleBoMapper.insert((Object)moduleBo);
        ServiceResponse serviceResponse = this.saveFields(bo, boInfo.getFields());
        if (!serviceResponse.isSuccess()) {
            throw new ServiceException(serviceResponse.getCode(), serviceResponse.getMessage());
        }
        return bo;
    }

    private ServiceResponse saveFields(Bo bo, List<BoFieldVo> boFieldVos) {
        ServiceResponse serviceResponse = this.commonValidator.checkFields(boFieldVos, bo);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        boFieldVos.stream().forEach(fieldVo -> {
            BoField boField = BoFieldStructMapper.MAPPER.toEntity(fieldVo);
            boField.setArrayType(CommonBusiness.boolStr((Boolean)fieldVo.getIsArray()));
            if (FieldType.ENUM.code().equals(fieldVo.getType()) || FieldType.ENUMS.code().equals(fieldVo.getType())) {
                boField.setDictId(StringUtils.isNumeric((CharSequence)fieldVo.getEnumCode()) ? Long.valueOf(Long.parseLong(fieldVo.getEnumCode())) : null);
            }
            boField.setPublishFlag(PublishFlag.UNPUBLISHED.code());
            boField.setPublishFieldId(null);
            boField.setDefaultValue(fieldVo.getDefaultValue());
            boField.setBoId(bo.getId());
            boField.setTenantId(bo.getTenantId());
            boField.setTenantCode(bo.getTenantCode());
            this.boFieldMapper.insert((Object)boField);
            BoFieldAttribute attribute = CommonBusiness.createFieldAttribute((BoFieldVo)fieldVo);
            attribute.setFieldId(boField.getId());
            this.boFieldAttributeMapper.insert((Object)attribute);
            BoFieldValidate boFieldValidate = new BoFieldValidate();
            boFieldValidate.setFieldId(boField.getId());
            boFieldValidate.setValidateRule(fieldVo.getValidateRule());
            this.boFieldValidateMapper.insert((Object)boFieldValidate);
        });
        return ServiceResponse.success((String)"");
    }

    private BoRelationship createBoRelationship(Bo bo, Bo joinBo, String relationType) {
        BoRelationship boRelationship = new BoRelationship();
        boRelationship.setBoId(bo.getId());
        boRelationship.setJoinBoId(joinBo.getId());
        boRelationship.setRelationType(relationType);
        boRelationship.setRelationCode(bo.getCode() + relationType + joinBo.getCode());
        boRelationship.setRelationName(bo.getName() + relationType + joinBo.getName());
        boRelationship.setDeleteFlag("1");
        return boRelationship;
    }

    List<Long> getBoIds(Long moduleId) {
        QueryWrapper moduleBoWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"module_id", (Object)moduleId)).eq((Object)"delete_flag", (Object)"1");
        return this.moduleBoMapper.selectList((Wrapper)moduleBoWrapper).stream().map(ModuleBo::getBoId).collect(Collectors.toList());
    }
}

