/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.metadata.web.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.listener.ReadListener;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.entity.JsonSchema;
import com.xforceplus.ultraman.bocp.metadata.enums.DataValueType;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    public static JsonSchema getJsonSchema(InputStream stream) {
        final HashMap headNameMap = Maps.newHashMap();
        final HashMap headIndexMap = Maps.newHashMap();
        final HashMap rowIndexMap = Maps.newHashMap();
        EasyExcel.read((InputStream)stream, (ReadListener)new ReadListener(){

            public void invokeHead(Map headMap, AnalysisContext analysisContext) {
                if (analysisContext.readSheetHolder().getSheetNo() > 0) {
                    return;
                }
                headMap.entrySet().forEach(item -> headNameMap.put((Integer)((Map.Entry)item).getKey(), ((ReadCellData)((Map.Entry)item).getValue()).getStringValue()));
                headIndexMap.putAll(headMap);
            }

            public void invoke(Object o, AnalysisContext analysisContext) {
                if (rowIndexMap.isEmpty()) {
                    if (analysisContext.readSheetHolder().getSheetNo() > 0) {
                        return;
                    }
                    rowIndexMap.putAll(analysisContext.readRowHolder().getCellMap());
                }
            }

            public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                logger.info(String.format("\u5bfc\u5165\u89e3\u6790\u5b8c\u6210,sheet: %s", analysisContext.readSheetHolder().getSheetName()));
            }
        }).doReadAllSync();
        JsonSchema jsonSchema = new JsonSchema();
        jsonSchema.setArray(Boolean.valueOf(false));
        jsonSchema.setType(DataValueType.OBJECT);
        jsonSchema.setMap(Boolean.valueOf(false));
        HashMap properties = Maps.newHashMap();
        jsonSchema.setProperties((Map)properties);
        headIndexMap.entrySet().stream().forEachOrdered(entry -> {
            Cell cell = (Cell)rowIndexMap.get(entry.getKey());
            String fieldName = (String)headNameMap.get(entry.getKey());
            if (fieldName == null) {
                return;
            }
            if (fieldName.indexOf(".") != -1) {
                fieldName = fieldName.replace(".", "_");
            }
            JsonSchema fieldSchema = new JsonSchema();
            properties.put(fieldName, fieldSchema);
            fieldSchema.setHeadIndex((Integer)entry.getKey());
            if (Optional.ofNullable(cell).isPresent()) {
                fieldSchema.setType(ExcelUtil.convertType(((ReadCellData)cell).getType()));
            } else {
                fieldSchema.setType(ExcelUtil.convertType(null));
            }
        });
        return jsonSchema;
    }

    public static Collection<JsonSchema> getJsonSchemaMulti(InputStream stream) {
        final HashMap<Integer, JsonSchema> jsonSchemaMap = new HashMap<Integer, JsonSchema>();
        final HashMap sheetRowIndexMap = Maps.newHashMap();
        final HashMap sheetHeadIndexMap = Maps.newHashMap();
        EasyExcel.read((InputStream)stream, (ReadListener)new ReadListener(){

            public void invokeHead(Map headMap, AnalysisContext analysisContext) {
                Integer sheetNo = analysisContext.readSheetHolder().getSheetNo();
                JsonSchema jsonSchema = new JsonSchema();
                jsonSchema.setArray(Boolean.valueOf(false));
                jsonSchema.setType(DataValueType.OBJECT);
                jsonSchema.setMap(Boolean.valueOf(false));
                jsonSchema.setSheetIndex(sheetNo);
                jsonSchema.setSheetName(analysisContext.readSheetHolder().getSheetName());
                sheetHeadIndexMap.put(sheetNo, new HashMap());
                headMap.entrySet().forEach(item -> ((Map)sheetHeadIndexMap.get(sheetNo)).put((Integer)((Map.Entry)item).getKey(), ((ReadCellData)((Map.Entry)item).getValue()).getStringValue()));
                jsonSchemaMap.put(analysisContext.readSheetHolder().getSheetNo(), jsonSchema);
            }

            public void invoke(Object o, AnalysisContext analysisContext) {
                Integer sheetNo = analysisContext.readSheetHolder().getSheetNo();
                JsonSchema jsonSchema = (JsonSchema)jsonSchemaMap.get(sheetNo);
                if (jsonSchema == null) {
                    return;
                }
                if (sheetRowIndexMap.get(sheetNo) == null) {
                    sheetRowIndexMap.put(sheetNo, new HashMap());
                    analysisContext.readRowHolder().getCellMap().forEach((integer, cell) -> ((Map)sheetRowIndexMap.get(sheetNo)).put(integer, ((ReadCellData)cell).getType()));
                }
            }

            public void doAfterAllAnalysed(AnalysisContext analysisContext) {
                logger.info(String.format("\u5bfc\u5165\u89e3\u6790\u5b8c\u6210,sheet: %s", analysisContext.readSheetHolder().getSheetName()));
            }
        }).doReadAllSync();
        jsonSchemaMap.forEach((integer, jsonSchema) -> {
            HashMap properties = Maps.newHashMap();
            jsonSchema.setProperties((Map)properties);
            ((Map)sheetHeadIndexMap.get(integer)).entrySet().stream().forEachOrdered(entry -> {
                String fieldName = (String)entry.getValue();
                if (fieldName == null) {
                    return;
                }
                if (fieldName.indexOf(".") != -1) {
                    fieldName = fieldName.replace(".", "_");
                }
                JsonSchema fieldSchema = new JsonSchema();
                properties.put(fieldName, fieldSchema);
                fieldSchema.setProperties(null);
                fieldSchema.setType(ExcelUtil.convertType(null));
                fieldSchema.setHeadIndex((Integer)entry.getKey());
                Map integerCellDataTypeEnumMap = (Map)sheetRowIndexMap.get(integer);
                if (Optional.ofNullable(integerCellDataTypeEnumMap).isPresent()) {
                    CellDataTypeEnum cellDataTypeEnum = (CellDataTypeEnum)integerCellDataTypeEnumMap.get(entry.getKey());
                    fieldSchema.setType(ExcelUtil.convertType(cellDataTypeEnum));
                }
            });
        });
        return jsonSchemaMap.values();
    }

    private static DataValueType convertType(CellDataTypeEnum cellDataTypeEnum) {
        if (cellDataTypeEnum == null) {
            return DataValueType.STRING;
        }
        switch (cellDataTypeEnum) {
            case DATE: {
                return DataValueType.DATE_TIME;
            }
            case NUMBER: {
                return DataValueType.BIG_DECIMAL;
            }
            case BOOLEAN: {
                return DataValueType.BOOLEAN;
            }
        }
        return DataValueType.STRING;
    }
}

