/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.action.executor;

import com.alibaba.fastjson.JSON;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.google.common.base.Preconditions;
import com.xforceplus.ultraman.action.constant.ActionType;
import com.xforceplus.ultraman.action.entity.ActionDefinition;
import com.xforceplus.ultraman.datarule.action.DataRuleActionConstant;
import com.xforceplus.ultraman.datarule.action.DataRuleActionScanManager;
import com.xforceplus.ultraman.datarule.action.exception.DataRuleActionException;
import com.xforceplus.ultraman.datarule.domain.dto.DataRuleActionDTO;
import com.xforceplus.ultraman.datarule.domain.dto.DataRuleActionParamDTO;
import com.xforceplus.ultraman.datarule.util.ReflectUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;

public class DataRuleActionExecutor {
    private ApplicationContext applicationContext;

    public DataRuleActionExecutor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object execute(DataRuleActionDTO action) {
        this.checkConfiguration(action);
        List<DataRuleActionParamDTO> params = action.getParams().stream().sorted(Comparator.comparingInt(DataRuleActionParamDTO::getParamIndex)).collect(Collectors.toList());
        Object result = this.innerExecute(action, params);
        return result;
    }

    private boolean checkConfiguration(DataRuleActionDTO action) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)action.getActionCode()) ? 1 : 0) != 0, (Object)"action\u7684actionCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Preconditions.checkArgument((boolean)Optional.ofNullable(action.getParams()).isPresent(), (Object)"\u53c2\u6570\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Preconditions.checkArgument((!Optional.ofNullable(action.getParams()).get().isEmpty() ? 1 : 0) != 0, (Object)"action\u53c2\u6570\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        return true;
    }

    private Object innerExecute(DataRuleActionDTO action, List<DataRuleActionParamDTO> actionParams) {
        ActionType actionType = Optional.ofNullable(action.getActionType()).isPresent() ? ActionType.fromValue((Integer)action.getActionType()) : ActionType.BEANMETHOD;
        Object ret = null;
        if (actionType.equals((Object)ActionType.BEANMETHOD)) {
            Optional<ActionDefinition> actionDefinition = DataRuleActionScanManager.getAction(action.getActionCode());
            if (!actionDefinition.isPresent()) {
                throw new DataRuleActionException(String.format("action setting not found!", action.getActionCode()));
            }
            String beanName = actionDefinition.get().getActionContent().split("\\.")[0];
            String methodName = actionDefinition.get().getActionContent().split("\\.")[1];
            Object bean = this.applicationContext.getBean(beanName);
            if (AopUtils.isCglibProxy((Object)bean)) {
                try {
                    bean = ((Advised)bean).getTargetSource().getTarget();
                }
                catch (Exception e) {
                    throw new DataRuleActionException("action bean not found!", e);
                }
            }
            MethodAccess toMethodAccess = ReflectUtil.getMethodAccess(bean.getClass());
            Method method = ReflectUtil.getMethod(bean.getClass(), methodName);
            if (method == null) {
                throw new DataRuleActionException(String.format(" method %s in %s not found", methodName, bean.getClass().getName()));
            }
            List<DataRuleActionParamDTO> input = this.getInputParams(actionParams);
            if (null != input && !input.isEmpty()) {
                throw new DataRuleActionException("action requires zero input params");
            }
            ret = toMethodAccess.invoke(bean, methodName, new Object[0]);
        }
        if (!Optional.ofNullable(ret).isPresent()) {
            throw new DataRuleActionException("action return null value!");
        }
        return this.getReturn(actionParams, ret);
    }

    private List<DataRuleActionParamDTO> getInputParams(List<DataRuleActionParamDTO> actionParams) {
        List<DataRuleActionParamDTO> input = actionParams.stream().filter(param -> param.getParamType() == 1).collect(Collectors.toList());
        return input;
    }

    private Object getReturn(List<DataRuleActionParamDTO> actionParams, Object ret) {
        Optional<DataRuleActionParamDTO> outputOptl = actionParams.stream().filter(param -> param.getParamType() == 2).findAny();
        if (!outputOptl.isPresent()) {
            throw new DataRuleActionException("action output params setting not found");
        }
        Map outputParam = (Map)JSON.parseObject((String)outputOptl.get().getParamSchema(), Map.class);
        Boolean isArray = (Boolean)outputParam.get("array");
        if (ReflectUtil.isArrayType(ret.getClass()) && !isArray.booleanValue()) {
            throw new DataRuleActionException("action \u5b9e\u9645\u8fd4\u56de\u503c\u662f\u6570\u7ec4\u7c7b\u578b\uff0c\u800c\u914d\u7f6e\u8981\u6c42\u8fd4\u56de\u503c\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b");
        }
        if (!ReflectUtil.isArrayType(ret.getClass()) && isArray.booleanValue()) {
            throw new DataRuleActionException("action \u5b9e\u9645\u8fd4\u56de\u503c\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b\uff0c\u800c\u914d\u7f6e\u8981\u6c42\u8fd4\u56de\u503c\u662f\u6570\u7ec4\u7c7b\u578b");
        }
        String type = String.valueOf(outputParam.get("type"));
        String actualType = null;
        if (isArray.booleanValue()) {
            if (((List)ret).size() > 0) {
                actualType = ((List)ret).get(0).getClass().getSimpleName().toUpperCase();
            }
        } else {
            actualType = ret.getClass().getSimpleName().toUpperCase();
        }
        if (!DataRuleActionConstant.RETURN_BASIC_TYPES.contains(actualType) && type.equals(actualType)) {
            throw new DataRuleActionException(String.format("action\u8981\u6c42\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u4e3a%s\u6216\u8005\u6570\u7ec4 ", DataRuleActionConstant.RETURN_BASIC_TYPES_STR));
        }
        return this.parseReturn(isArray, ret);
    }

    private Object parseReturn(Boolean isArray, Object ret) {
        if (isArray.booleanValue()) {
            return ((List)ret).stream().map(v -> this.convertValueToString(v)).collect(Collectors.toList());
        }
        return this.convertValueToString(ret);
    }

    private String convertValueToString(Object v) {
        if (null == v) {
            return "";
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).toString();
        }
        if (v instanceof Boolean) {
            return ((Boolean)v).toString();
        }
        if (v instanceof Long) {
            return ((Long)v).toString();
        }
        if (v instanceof String) {
            return (String)v;
        }
        throw new DataRuleActionException(String.format("action\u8fd4\u56de\u7c7b\u578b\u4e0d\u5c5e\u4e8e%s", DataRuleActionConstant.RETURN_BASIC_TYPES_STR));
    }
}

