package com.xforceplus.ultraman.datarule.action.annotation;

import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

/**
 * Action
 * @author liwei
 */
@Target({ElementType.METHOD,ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface DataRuleAction {
    /**
     *  unique ID of action within the same appId
     * @return
     */
    @AliasFor("value")
    String code() default "";

    /**
     * alias for code
     * @return
     */
    @AliasFor("code")
    String value() default "";

    /**
     * action display name
     * @return
     */
    String name() default "";
}
