/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.action.constant.ActionBusinessType;
import com.xforceplus.ultraman.action.constant.ActionType;
import com.xforceplus.ultraman.action.constant.DataValueType;
import com.xforceplus.ultraman.action.constant.ParamType;
import com.xforceplus.ultraman.action.entity.ActionDefinition;
import com.xforceplus.ultraman.action.entity.ActionParam;
import com.xforceplus.ultraman.action.entity.JsonSchema;
import com.xforceplus.ultraman.datarule.action.DataRuleActionScanManager;
import com.xforceplus.ultraman.datarule.action.annotation.DataRuleAction;
import com.xforceplus.ultraman.datarule.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.PriorityOrdered;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class DataRuleActionRegisterPostProcesser
implements PriorityOrdered,
BeanDefinitionRegistryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DataRuleActionRegisterPostProcesser.class);
    private static final String ACTION_CONTENT_TEMP = "%s.%s";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        if (log.isDebugEnabled()) {
            log.debug("start postProcessBeanDefinitionRegistry");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String[] definitionNames;
        for (String definition : definitionNames = configurableListableBeanFactory.getBeanDefinitionNames()) {
            Method[] methods;
            block9: {
                String beanClassName = configurableListableBeanFactory.getBeanDefinition(definition).getBeanClassName();
                if (beanClassName == null) continue;
                try {
                    Class<?> beanClass = Class.forName(beanClassName);
                    methods = beanClass.getDeclaredMethods();
                    if (methods == null) {
                    }
                    break block9;
                }
                catch (Throwable e) {
                    log.error("", e);
                }
                break;
            }
            block5: for (Method method : methods) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                    if (!this.isAction(annotation)) continue;
                    String content = String.format(ACTION_CONTENT_TEMP, definition, method.getName());
                    ActionDefinition actionDefinition = ActionDefinition.builder().actionCode(this.getActionCode(annotation)).actionContent(content).actionName(this.getActionName(annotation)).actionBusinessType(this.getActionBusinessType(annotation.annotationType())).actionType(ActionType.BEANMETHOD.value().toString()).build();
                    ArrayList paramList = Lists.newArrayList();
                    int i = 0;
                    for (Parameter parameter : method.getParameters()) {
                        JsonSchema schema = !TypeUtils.isArrayType(parameter.getType()) ? this.toJsonSchema(parameter.getType()) : this.toJsonSchema(parameter.getParameterizedType());
                        ActionParam param = ActionParam.builder().paramIndex(i).paramSchema(schema).paramType(ParamType.INPUT).name(parameter.getName()).build();
                        paramList.add(param);
                        ++i;
                    }
                    JsonSchema returnSchema = !TypeUtils.isArrayType(method.getReturnType()) ? this.toJsonSchema(method.getReturnType()) : this.toJsonSchema(method.getGenericReturnType());
                    ActionParam returnParam = ActionParam.builder().paramIndex(i).paramSchema(returnSchema).paramType(ParamType.RETURN).build();
                    paramList.add(returnParam);
                    actionDefinition.setParams((List)paramList);
                    DataRuleActionScanManager.add(actionDefinition);
                    continue block5;
                }
            }
        }
        log.info(DataRuleActionScanManager.toJson());
    }

    private String getActionName(Annotation annotation) {
        if (annotation.annotationType().equals(DataRuleAction.class)) {
            return ((DataRuleAction)annotation).name();
        }
        return "";
    }

    private String getActionCode(Annotation annotation) {
        if (annotation.annotationType().equals(DataRuleAction.class)) {
            return ((DataRuleAction)annotation).code();
        }
        return "";
    }

    public JsonSchema toJsonSchema(Type type) {
        JsonSchema schema = new JsonSchema();
        if (ReflectUtil.isBasicType(type) || DataRuleActionRegisterPostProcesser.isMap(type)) {
            schema.setType(this.toDataValueType(type));
            schema.setArray(false);
        } else {
            schema.setType(DataValueType.OBJECT);
            HashMap props = Maps.newHashMap();
            if (TypeUtils.isArrayType((Type)type)) {
                schema.setArray(true);
                DataValueType dataValueType = this.toDataValueType(((ParameterizedTypeImpl)type).getActualTypeArguments()[0]);
                if (!dataValueType.equals((Object)DataValueType.OBJECT)) {
                    schema.setType(dataValueType);
                    return schema;
                }
                type = ((ParameterizedTypeImpl)type).getActualTypeArguments()[0];
            }
            if (DataRuleActionRegisterPostProcesser.isMap(type)) {
                schema.setMap(true);
                return schema;
            }
            if (((Class)type).isEnum()) {
                schema.setType(DataValueType.ENUM);
                return schema;
            }
            for (Field field : ((Class)type).getDeclaredFields()) {
                if (field.getName().contains("this$")) continue;
                if (ReflectUtil.isBasicType(field.getType())) {
                    JsonSchema prop = new JsonSchema();
                    prop.setType(this.toDataValueType(field.getType()));
                    prop.setArray(false);
                    props.put(field.getName(), prop);
                    continue;
                }
                if (field.getType().isAssignableFrom(List.class) || field.getType().isAssignableFrom(Collection.class)) {
                    props.put(field.getName(), this.toJsonSchema(field.getGenericType()));
                    continue;
                }
                props.put(field.getName(), this.toJsonSchema(field.getType()));
            }
            schema.setProperties((Map)props);
        }
        return schema;
    }

    private DataValueType toDataValueType(Type type) {
        if (DataRuleActionRegisterPostProcesser.isMap(type)) {
            return DataValueType.MAP;
        }
        if (ReflectUtil.isBasicType(type)) {
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return DataValueType.LONG;
            }
            if (type.equals(String.class)) {
                return DataValueType.STRING;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return DataValueType.LONG;
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return DataValueType.BIG_DECIMAL;
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return DataValueType.BIG_DECIMAL;
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return DataValueType.LONG;
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return DataValueType.BOOLEAN;
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return DataValueType.STRING;
            }
            if (type.equals(String.class)) {
                return DataValueType.STRING;
            }
            if (type.equals(Character.TYPE)) {
                return DataValueType.STRING;
            }
            if (type.equals(LocalDateTime.class) || type.equals(LocalDate.class)) {
                return DataValueType.LOCAL_DATE_TIME;
            }
            if (type.equals(Void.TYPE)) {
                return DataValueType.VOID;
            }
            if (type.equals(BigDecimal.class)) {
                return DataValueType.BIG_DECIMAL;
            }
        } else {
            return DataValueType.OBJECT;
        }
        throw new IllegalArgumentException(String.format("\u672a\u80fd\u652f\u6301\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b %s", type.getTypeName()));
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return DataRuleActionRegisterPostProcesser.isMap(((ParameterizedType)type).getRawType());
        }
        if (!(type instanceof WildcardType)) {
            return false;
        }
        Type[] upperBounds = ((WildcardType)type).getUpperBounds();
        return upperBounds.length != 0 && DataRuleActionRegisterPostProcesser.isMap(upperBounds[0]);
    }

    private boolean isAction(Annotation annotation) {
        return annotation.annotationType().equals(DataRuleAction.class);
    }

    private String getActionBusinessType(Class annotationClass) {
        return ActionBusinessType.ACTION.toString();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

