/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.util;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ReflectUtil {
    private static final ConcurrentMap<Class, MethodAccess> METHOD_ACCESS_CACHE = Maps.newConcurrentMap();
    private static final ConcurrentMap<Class, List<Method>> METHOD_CACHE = Maps.newConcurrentMap();
    private static final Set<Class<?>> BASE_TYPE_SET = Sets.newHashSet();

    public static boolean isBasicType(Type type) {
        return BASE_TYPE_SET.contains(type);
    }

    public static MethodAccess getMethodAccess(Class clazz) {
        if (METHOD_ACCESS_CACHE.containsKey(clazz)) {
            return (MethodAccess)METHOD_ACCESS_CACHE.get(clazz);
        }
        MethodAccess methodAccess = MethodAccess.get((Class)clazz);
        METHOD_ACCESS_CACHE.putIfAbsent(clazz, methodAccess);
        return methodAccess;
    }

    public static List<Method> getMethods(Class clazz) {
        if (METHOD_CACHE.containsKey(clazz)) {
            return (List)METHOD_CACHE.get(clazz);
        }
        ArrayList methods = Lists.newArrayList((Object[])clazz.getMethods());
        METHOD_CACHE.putIfAbsent(clazz, methods);
        return methods;
    }

    public static Method getMethod(Class clazz, String methodName) {
        List<Method> methods = ReflectUtil.getMethods(clazz);
        return methods.stream().filter(item -> item.getName().equals(methodName)).findAny().orElse(null);
    }

    public static boolean isArrayType(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedTypeImpl)type).getRawType();
            return ReflectUtil.isClassArrayType((Class)rawType);
        }
        return ReflectUtil.isClassArrayType((Class)type);
    }

    private static boolean isClassArrayType(Class cls) {
        return List.class.isAssignableFrom(cls) || Collection.class.isAssignableFrom(cls) || cls.isArray();
    }

    static {
        BASE_TYPE_SET.add(Long.class);
        BASE_TYPE_SET.add(Long.TYPE);
        BASE_TYPE_SET.add(String.class);
        BASE_TYPE_SET.add(Double.class);
        BASE_TYPE_SET.add(Double.TYPE);
        BASE_TYPE_SET.add(Boolean.TYPE);
        BASE_TYPE_SET.add(Boolean.class);
        BASE_TYPE_SET.add(Byte.TYPE);
        BASE_TYPE_SET.add(Byte.class);
        BASE_TYPE_SET.add(Character.TYPE);
        BASE_TYPE_SET.add(String.class);
        BASE_TYPE_SET.add(Short.TYPE);
        BASE_TYPE_SET.add(Short.class);
        BASE_TYPE_SET.add(Integer.TYPE);
        BASE_TYPE_SET.add(Integer.class);
        BASE_TYPE_SET.add(Long.TYPE);
        BASE_TYPE_SET.add(Long.class);
        BASE_TYPE_SET.add(Float.TYPE);
        BASE_TYPE_SET.add(Float.class);
        BASE_TYPE_SET.add(Double.TYPE);
        BASE_TYPE_SET.add(Double.class);
        BASE_TYPE_SET.add(LocalDateTime.class);
        BASE_TYPE_SET.add(LocalTime.class);
        BASE_TYPE_SET.add(LocalDate.class);
        BASE_TYPE_SET.add(Void.TYPE);
        BASE_TYPE_SET.add(BigDecimal.class);
    }
}

