package com.xforceplus.ultraman.datarule.action;


import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.action.annotation.Action;
import com.xforceplus.ultraman.action.constant.ActionBusinessType;
import com.xforceplus.ultraman.action.constant.ActionType;
import com.xforceplus.ultraman.action.constant.DataValueType;
import com.xforceplus.ultraman.action.constant.ParamType;
import com.xforceplus.ultraman.action.entity.ActionDefinition;
import com.xforceplus.ultraman.action.entity.ActionParam;
import com.xforceplus.ultraman.action.entity.JsonSchema;
import com.xforceplus.ultraman.datarule.util.ReflectUtil;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

import java.lang.annotation.Annotation;
import java.lang.reflect.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import static org.apache.commons.lang3.reflect.TypeUtils.isArrayType;


/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2021/1/21 6:49 PM
 */
@Slf4j
public class DataRuleActionRegisterPostProcessor implements PriorityOrdered, BeanDefinitionRegistryPostProcessor {

    private static final String ACTION_CONTENT_TEMP = "%s.%s";

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        if (log.isDebugEnabled()) {
            log.debug("start postProcessBeanDefinitionRegistry");
        }
    }

    @SneakyThrows
    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String[] definitionNames = configurableListableBeanFactory.getBeanDefinitionNames();
        for (String definition : definitionNames) {
            String beanClassName = configurableListableBeanFactory.getBeanDefinition(definition).getBeanClassName();
            if (beanClassName == null) {
                continue;
            }
            Method[] methods;
            try {
                Class beanClass = Class.forName(beanClassName);
                methods = beanClass.getDeclaredMethods();
            } catch (Throwable e) {
                log.error("", e);
                break;
            }
            for (Method method : methods) {
                Annotation[] annotations = method.getDeclaredAnnotations();
                ActionDefinition actionDefinition;
                for (Annotation annotation : annotations) {
                    Triple<Boolean, String, String> annotationTriple = parseAnnotation(annotation);
                    if (annotationTriple.getLeft()) {
                        String content = String.format(ACTION_CONTENT_TEMP, definition, method.getName());
                        actionDefinition =
                            ActionDefinition.builder()
                                    .actionName(annotationTriple.getMiddle())
                                    .actionCode(annotationTriple.getRight())
                                    .actionContent(content)
                                    .actionBusinessType(ActionBusinessType.ACTION.toString())
                                    .actionType(ActionType.BEANMETHOD.value().toString())
                                    .build();
                        List<ActionParam> paramList = Lists.newArrayList();
                        int i = 0;
                        //入参校验
                        if (method.getParameters().length > 0) {
                            continue;
                        }
//                        JsonSchema schema;
//                        for (Parameter parameter : method.getParameters()) {
//                            if (!isArrayType(parameter.getType())) {
//                                schema = toJsonSchema(parameter.getType());
//                            } else {
//                                schema = toJsonSchema(parameter.getParameterizedType());
//                            }
//                            ActionParam param = ActionParam.builder().paramIndex(i).paramSchema(schema).paramType(
//                                ParamType.INPUT).name(parameter.getName()).build();
//                            paramList.add(param);
//                            i++;
//                        }
                        //出参校验
                        if (!isReturnTypeAllowed(method)) {
                            continue;
                        }
                        JsonSchema returnSchema;
                        if (TypeUtils.equals(List.class, method.getReturnType()) || TypeUtils.equals(Collection.class, method.getReturnType())) {
                            returnSchema = toJsonSchema(method.getGenericReturnType());
                        } else {
                            returnSchema = toJsonSchema(method.getReturnType());
                        }
                        ActionParam returnParam =
                            ActionParam.builder().paramIndex(i).paramSchema(returnSchema).paramType(
                                ParamType.RETURN).build();
                        paramList.add(returnParam);
                        actionDefinition.setParams(paramList);
                        DataRuleActionScanManager.add(actionDefinition);
                        break;
                    }
                }
            }
        }
        log.info(DataRuleActionScanManager.toJson());
    }
    
    public JsonSchema toJsonSchema(Type type) {
        JsonSchema schema = new JsonSchema();
        if (ReflectUtil.isBasicType(type) || isMap(type)) {
            schema.setType(toDataValueType(type));
            schema.setArray(false);
        } else {
            schema.setType(DataValueType.OBJECT);
            Map<String, JsonSchema> props = Maps.newHashMap();
            DataValueType dataValueType;
            if (isArrayType(type)) {
                dataValueType = toDataValueType(TypeUtils.getArrayComponentType(type));
            } else {
                dataValueType = toDataValueType(((ParameterizedTypeImpl) type).getActualTypeArguments()[0]);
            }
            if (!dataValueType.equals(DataValueType.OBJECT)) {
                schema.setType(dataValueType);
                return schema;
            }
//            if (dataValueType.equals(DataValueType.MAP)) {
//                schema.setMap(true);
//                return schema;
//            }
//            if (((Class) type).isEnum()) {
//                schema.setType(DataValueType.ENUM);
//                return schema;
//            }
//            for (Field field : ((Class) type).getDeclaredFields()) {
//                //如果定义了非静态的内部类，会有一个属性指向自己，所以要忽略掉这个内部属性
//                if(field.getName().contains("this$")) {
//                    continue;
//                }
//                if (ReflectUtil.isBasicType(field.getType())) {
//                    JsonSchema prop = new JsonSchema();
//                    prop.setType(toDataValueType(field.getType()));
//                    prop.setArray(false);
//                    props.put(field.getName(), prop);
//                } else {
//                    if ((field.getType()).isAssignableFrom(List.class)
//                        || (field.getType()).isAssignableFrom(Collection.class)) {
//                        props.put(field.getName(), toJsonSchema(field.getGenericType()));
//                    } else {
//                        props.put(field.getName(), toJsonSchema(field.getType()));
//                    }
//                }
//            }
//            schema.setProperties(props);
        }
        return schema;
    }

    private DataValueType toDataValueType(Type type) {
        if (isMap(type)) {
            return DataValueType.MAP;
        } else if (ReflectUtil.isBasicType(type)) {
            if (type.equals(Long.class) || type.equals(long.class)) {
                return DataValueType.LONG;
            } else if (type.equals(String.class)) {
                return DataValueType.STRING;
            } else if (type.equals(Integer.class) || type.equals(int.class)) {
                return DataValueType.LONG;
            } else if (type.equals(Double.class) || type.equals(double.class)) {
                return DataValueType.BIG_DECIMAL;
            } else if (type.equals(Float.class) || type.equals(float.class)) {
                return DataValueType.BIG_DECIMAL;
            } else if (type.equals(Short.class) || type.equals(short.class)) {
                return DataValueType.LONG;
            } else if (type.equals(Boolean.class) || type.equals(boolean.class)) {
                return DataValueType.BOOLEAN;
            } else if (type.equals(Byte.class) || type.equals(byte.class)) {
                return DataValueType.STRING;
            } else if (type.equals(String.class)) {
                return DataValueType.STRING;
            } else if (type.equals(char.class)) {
                return DataValueType.STRING;
            } else if (type.equals(LocalDateTime.class) || type.equals(LocalDate.class)) {
                return DataValueType.LOCAL_DATE_TIME;
            } else if (type.equals(void.class)) {
                return DataValueType.VOID;
            } else if (type.equals(BigDecimal.class)) {
                return DataValueType.BIG_DECIMAL;
            }
        } else {
            return DataValueType.OBJECT;
        }
        throw new IllegalArgumentException(String.format("未能支持的参数数据类型 %s", type.getTypeName()));
    }
    
    public static boolean isMap(Type type) {
        if (type instanceof Class && Map.class.isAssignableFrom((Class) type)) {
            return true;
        } else if (type instanceof ParameterizedType) {
            return isMap(((ParameterizedType) type).getRawType());
        } else if (!(type instanceof WildcardType)) {
            return false;
        } else {
            Type[] upperBounds = ((WildcardType) type).getUpperBounds();
            return upperBounds.length != 0 && isMap(upperBounds[0]);
        }
    }

    public static boolean isReturnTypeAllowed(Method method) {
        Type type = method.getReturnType();
        if (isArrayType(type)) {
            return isBasicTypeAllowed(TypeUtils.getArrayComponentType(type));
        } else if (TypeUtils.equals(List.class, type) || TypeUtils.equals(Collection.class, type)) {
            Type listItemType = ((ParameterizedTypeImpl) method.getGenericReturnType()).getActualTypeArguments()[0];
            return isBasicTypeAllowed(listItemType);
        }
        if (isMap(type)) {
            return false;
        }
        return isBasicTypeAllowed(type);
    }
    
    private boolean isAction(Annotation annotation) {
        return annotation.annotationType().equals(Action.class);
    }

    private static boolean isBasicTypeAllowed(Type type) {
        if (ReflectUtil.isBasicType(type)) {
            if (type.equals(Long.class) || type.equals(long.class)) {
                return true;
            } else if (type.equals(String.class)) {
                return true;
            } else if (type.equals(Integer.class) || type.equals(int.class)) {
                return true;
            } else if (type.equals(Double.class) || type.equals(double.class)) {
                return true;
            } else if (type.equals(Float.class) || type.equals(float.class)) {
                return true;
            } else if (type.equals(Short.class) || type.equals(short.class)) {
                return true;
            } else if (type.equals(Boolean.class) || type.equals(boolean.class)) {
                return true;
            } else if (type.equals(Byte.class) || type.equals(byte.class)) {
                return true;
            } else if (type.equals(String.class)) {
                return true;
            } else if (type.equals(char.class)) {
                return true;
            } else if (type.equals(LocalDateTime.class) || type.equals(LocalDate.class)) {
                return true;
            } else if (type.equals(void.class)) {
                return true;
            } else if (type.equals(BigDecimal.class)) {
                return true;
            }
        }
        return false;
    }

    private Triple<Boolean, String, String> parseAnnotation(Annotation annotation) {
        return isAction(annotation)
                ? Triple.of(true, ((Action) annotation).name(), ((Action) annotation).code()) : Triple.of(false, null, null);
    }
    
    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
