package com.xforceplus.ultraman.datarule.action;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.action.entity.ActionDefinition;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2021/1/21 8:21 PM
 */
public class DataRuleActionScanManager {

    private static Map<String, ActionDefinition> actionMap = Maps.newConcurrentMap();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Optional<ActionDefinition> getAction(String actionCode) {
        return Optional.ofNullable(actionMap.get(actionCode));
    }

//    public static List<ActionDefinition> getActions() {
//        return Lists.newArrayList(actionMap.values());
//    }

    public static void add(ActionDefinition actionDefinition) {
        actionMap.put(actionDefinition.getActionCode(), actionDefinition);
    }
    public static String toJson() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(actionMap);
    }

//    public static Map fromJson(String json) throws JsonProcessingException {
//        actionMap = OBJECT_MAPPER.readValue(json, new TypeReference<Map<String,ActionDefinition>>() {});
//        return actionMap;
//    }

}
