package com.xforceplus.ultraman.datarule.util;

import com.esotericsoftware.reflectasm.FieldAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

import java.lang.annotation.Annotation;
import java.lang.reflect.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.*;
import java.util.concurrent.ConcurrentMap;


/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2020/6/30 4:21 PM
 */
public class ReflectUtil {
//    private static final String PAYLOAD_ID = "id";
    private static final ConcurrentMap<Class, MethodAccess> METHOD_ACCESS_CACHE = Maps.newConcurrentMap();
    private static final ConcurrentMap<Class, List<Method>> METHOD_CACHE = Maps.newConcurrentMap();
//    private static final ConcurrentMap<Class,FieldAccess> FIELD_ACCESS_CACHE = Maps.newConcurrentMap();
    private static final Set<Class<?>> BASE_TYPE_SET = Sets.newHashSet();

    static {
        BASE_TYPE_SET.add(Long.class);
        BASE_TYPE_SET.add(long.class);
        BASE_TYPE_SET.add(String.class);
        BASE_TYPE_SET.add(Double.class);
        BASE_TYPE_SET.add(double.class);
        BASE_TYPE_SET.add(boolean.class);
        BASE_TYPE_SET.add(Boolean.class);
        BASE_TYPE_SET.add(byte.class);
        BASE_TYPE_SET.add(Byte.class);
        BASE_TYPE_SET.add(char.class);
        BASE_TYPE_SET.add(String.class);
        BASE_TYPE_SET.add(short.class);
        BASE_TYPE_SET.add(Short.class);
        BASE_TYPE_SET.add(int.class);
        BASE_TYPE_SET.add(Integer.class);
        BASE_TYPE_SET.add(long.class);
        BASE_TYPE_SET.add(Long.class);
        BASE_TYPE_SET.add(float.class);
        BASE_TYPE_SET.add(Float.class);
        BASE_TYPE_SET.add(double.class);
        BASE_TYPE_SET.add(Double.class);
        BASE_TYPE_SET.add(LocalDateTime.class);
        BASE_TYPE_SET.add(LocalTime.class);
        BASE_TYPE_SET.add(LocalDate.class);
        BASE_TYPE_SET.add(void.class);
        BASE_TYPE_SET.add(BigDecimal.class);
    }

    public static boolean isBasicType(Type type) {
        return BASE_TYPE_SET.contains(type);
    }

//    public static FieldAccess getFieldAccess(Class clazz) {
//        Arrays.stream(clazz.getDeclaredFields()).forEach(item->item.setAccessible(true));
//        if(FIELD_ACCESS_CACHE.containsKey(clazz)) {
//            return FIELD_ACCESS_CACHE.get(clazz);
//        }
//
//        FieldAccess fieldAccess = FieldAccess.get(clazz);
//        FIELD_ACCESS_CACHE.putIfAbsent(clazz, fieldAccess);
//        return fieldAccess;
//    }


    public static MethodAccess getMethodAccess(Class clazz) {
        if(METHOD_ACCESS_CACHE.containsKey(clazz)) {
            return METHOD_ACCESS_CACHE.get(clazz);
        }

        MethodAccess methodAccess = MethodAccess.get(clazz);
        METHOD_ACCESS_CACHE.putIfAbsent(clazz, methodAccess);
        return methodAccess;
    }

    public static List<Method> getMethods(Class clazz) {
        if(METHOD_CACHE.containsKey(clazz)) {
            return METHOD_CACHE.get(clazz);
        }
        List<Method> methods = Lists.newArrayList(clazz.getMethods());
        METHOD_CACHE.putIfAbsent(clazz,methods);
        return methods;
    }

    public static Method getMethod(Class clazz,String methodName) {
        List<Method> methods = getMethods(clazz);
        return methods.stream().filter(item ->item.getName().equals(methodName)).findAny().orElse(null);
    }

//    public static String acquireGetMethod(String fieldName) {
//        if (StringUtils.isBlank(fieldName)) {
//            return "";
//        }
//        return String.format("get%s",fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1)) ;
//    }
//
//    public static String acquireSetMethod(String fieldName) {
//        if (StringUtils.isBlank(fieldName)) {
//            return "";
//        }
//        return String.format("set%s",fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1)) ;
//    }
//
//    public static Object getFieldValue(Object object, String propertyName) {
//        if (isMap(object.getClass())) {
//            return ((Map) object).get(propertyName);
//        }
//        String getMethodName = acquireGetMethod(propertyName);
//        MethodAccess methodAccess = ReflectUtil.getMethodAccess(object.getClass());
//        return methodAccess.invoke(object,getMethodName);
//    }

//    public static boolean isMap(Type type) {
//        if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
//            return true;
//        } else if (type instanceof ParameterizedType) {
//            return isMap(((ParameterizedType)type).getRawType());
//        } else if (!(type instanceof WildcardType)) {
//            return false;
//        } else {
//            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
//            return upperBounds.length != 0 && isMap(upperBounds[0]);
//        }
//    }

//    public static String acquireBusinessFieldName(Object object) {
//        String fieldName = "";
//        if(Map.class.isAssignableFrom(object.getClass())) {
//            if(((Map)object).keySet().contains(PAYLOAD_ID)) {
//                fieldName = PAYLOAD_ID;
//            }
//        }
//        FieldAccess fieldAccess =  ReflectUtil.getFieldAccess(object.getClass());
//        Optional<Field> field =   Arrays.stream(fieldAccess.getFields()).filter(item -> {
//            for (Annotation annotation : item.getAnnotations()) {
//                if (annotation.annotationType().equals(BusinessId.class)) {
//                    return true;
//                }
//            }
//            return false;
//        }).findAny();
//        if(field.isPresent()) {
//            fieldName = field.get().getName();
//        }
//        return fieldName;
//
//    }
//
//    public static Optional<Field> acquireBusinessField(Object data) {
//        FieldAccess fieldAccess =  ReflectUtil.getFieldAccess(data.getClass());
//        Optional<Field> field =  Arrays.stream(fieldAccess.getFields()).filter(item->item.getName().equals(PAYLOAD_ID)).findAny();
//        if(!field.isPresent()) {
//            field =   Arrays.stream(fieldAccess.getFields()).filter(item -> {
//                for (Annotation annotation : item.getAnnotations()) {
//                    if (annotation.annotationType().equals(BusinessId.class)) {
//                        return true;
//                    }
//                }
//                return false;
//            }).findAny();
//        }
//        return field;
//    }

    public static boolean isArrayType(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedTypeImpl) type).getRawType();
            return isClassArrayType((Class) rawType);
        } else {
            return isClassArrayType((Class) type);
        }
    }

    private static boolean isClassArrayType(Class cls) {
        return (List.class.isAssignableFrom(cls)
            || Collection.class.isAssignableFrom(cls) || cls.isArray());
    }



}
