/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.action;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.action.annotation.Action;
import com.xforceplus.ultraman.action.constant.ActionBusinessType;
import com.xforceplus.ultraman.action.constant.ActionType;
import com.xforceplus.ultraman.action.constant.DataValueType;
import com.xforceplus.ultraman.action.constant.ParamType;
import com.xforceplus.ultraman.action.entity.ActionDefinition;
import com.xforceplus.ultraman.action.entity.ActionParam;
import com.xforceplus.ultraman.action.entity.JsonSchema;
import com.xforceplus.ultraman.datarule.action.DataRuleActionScanManager;
import com.xforceplus.ultraman.datarule.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.PriorityOrdered;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class DataRuleActionRegisterPostProcessor
implements PriorityOrdered,
BeanDefinitionRegistryPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(DataRuleActionRegisterPostProcessor.class);
    private static final String ACTION_CONTENT_TEMP = "%s.%s";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        if (log.isDebugEnabled()) {
            log.debug("start postProcessBeanDefinitionRegistry");
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        String[] definitionNames;
        for (String definition : definitionNames = configurableListableBeanFactory.getBeanDefinitionNames()) {
            Method[] methods;
            String beanClassName = configurableListableBeanFactory.getBeanDefinition(definition).getBeanClassName();
            if (beanClassName == null) continue;
            try {
                Class<?> beanClass = Class.forName(beanClassName);
                methods = beanClass.getDeclaredMethods();
            }
            catch (Throwable e) {
                log.error("", e);
                break;
            }
            block5: for (Method method : methods) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                    Triple<Boolean, String, String> annotationTriple = this.parseAnnotation(annotation);
                    if (!((Boolean)annotationTriple.getLeft()).booleanValue()) continue;
                    String content = String.format(ACTION_CONTENT_TEMP, definition, method.getName());
                    ActionDefinition actionDefinition = ActionDefinition.builder().actionName((String)annotationTriple.getMiddle()).actionCode((String)annotationTriple.getRight()).actionContent(content).actionBusinessType(ActionBusinessType.ACTION.toString()).actionType(ActionType.BEANMETHOD.value().toString()).build();
                    ArrayList paramList = Lists.newArrayList();
                    int i = 0;
                    if (method.getParameters().length > 0 || !DataRuleActionRegisterPostProcessor.isReturnTypeAllowed(method)) continue;
                    JsonSchema returnSchema = TypeUtils.equals(List.class, method.getReturnType()) || TypeUtils.equals(Collection.class, method.getReturnType()) ? this.toJsonSchema(method.getGenericReturnType()) : this.toJsonSchema(method.getReturnType());
                    ActionParam returnParam = ActionParam.builder().paramIndex(i).paramSchema(returnSchema).paramType(ParamType.RETURN).build();
                    paramList.add(returnParam);
                    actionDefinition.setParams((List)paramList);
                    DataRuleActionScanManager.add(actionDefinition);
                    continue block5;
                }
            }
        }
        log.info(DataRuleActionScanManager.toJson());
    }

    public JsonSchema toJsonSchema(Type type) {
        JsonSchema schema = new JsonSchema();
        if (ReflectUtil.isBasicType(type) || DataRuleActionRegisterPostProcessor.isMap(type)) {
            schema.setType(this.toDataValueType(type));
            schema.setArray(false);
        } else {
            schema.setType(DataValueType.OBJECT);
            HashMap props = Maps.newHashMap();
            DataValueType dataValueType = TypeUtils.isArrayType((Type)type) ? this.toDataValueType(TypeUtils.getArrayComponentType((Type)type)) : this.toDataValueType(((ParameterizedTypeImpl)type).getActualTypeArguments()[0]);
            if (!dataValueType.equals((Object)DataValueType.OBJECT)) {
                schema.setType(dataValueType);
                return schema;
            }
        }
        return schema;
    }

    private DataValueType toDataValueType(Type type) {
        if (DataRuleActionRegisterPostProcessor.isMap(type)) {
            return DataValueType.MAP;
        }
        if (ReflectUtil.isBasicType(type)) {
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return DataValueType.LONG;
            }
            if (type.equals(String.class)) {
                return DataValueType.STRING;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return DataValueType.LONG;
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return DataValueType.BIG_DECIMAL;
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return DataValueType.BIG_DECIMAL;
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return DataValueType.LONG;
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return DataValueType.BOOLEAN;
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return DataValueType.STRING;
            }
            if (type.equals(String.class)) {
                return DataValueType.STRING;
            }
            if (type.equals(Character.TYPE)) {
                return DataValueType.STRING;
            }
            if (type.equals(LocalDateTime.class) || type.equals(LocalDate.class)) {
                return DataValueType.LOCAL_DATE_TIME;
            }
            if (type.equals(Void.TYPE)) {
                return DataValueType.VOID;
            }
            if (type.equals(BigDecimal.class)) {
                return DataValueType.BIG_DECIMAL;
            }
        } else {
            return DataValueType.OBJECT;
        }
        throw new IllegalArgumentException(String.format("\u672a\u80fd\u652f\u6301\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b %s", type.getTypeName()));
    }

    public static boolean isMap(Type type) {
        if (type instanceof Class && Map.class.isAssignableFrom((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return DataRuleActionRegisterPostProcessor.isMap(((ParameterizedType)type).getRawType());
        }
        if (!(type instanceof WildcardType)) {
            return false;
        }
        Type[] upperBounds = ((WildcardType)type).getUpperBounds();
        return upperBounds.length != 0 && DataRuleActionRegisterPostProcessor.isMap(upperBounds[0]);
    }

    public static boolean isReturnTypeAllowed(Method method) {
        Class<?> type = method.getReturnType();
        if (TypeUtils.isArrayType(type)) {
            return DataRuleActionRegisterPostProcessor.isBasicTypeAllowed(TypeUtils.getArrayComponentType(type));
        }
        if (TypeUtils.equals(List.class, type) || TypeUtils.equals(Collection.class, type)) {
            Type listItemType = ((ParameterizedTypeImpl)method.getGenericReturnType()).getActualTypeArguments()[0];
            return DataRuleActionRegisterPostProcessor.isBasicTypeAllowed(listItemType);
        }
        if (DataRuleActionRegisterPostProcessor.isMap(type)) {
            return false;
        }
        return DataRuleActionRegisterPostProcessor.isBasicTypeAllowed(type);
    }

    private boolean isAction(Annotation annotation) {
        return annotation.annotationType().equals(Action.class);
    }

    private static boolean isBasicTypeAllowed(Type type) {
        if (ReflectUtil.isBasicType(type)) {
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return true;
            }
            if (type.equals(String.class)) {
                return true;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return true;
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return true;
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return true;
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return true;
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return true;
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return true;
            }
            if (type.equals(String.class)) {
                return true;
            }
            if (type.equals(Character.TYPE)) {
                return true;
            }
            if (type.equals(LocalDateTime.class) || type.equals(LocalDate.class)) {
                return true;
            }
            if (type.equals(Void.TYPE)) {
                return true;
            }
            if (type.equals(BigDecimal.class)) {
                return true;
            }
        }
        return false;
    }

    private Triple<Boolean, String, String> parseAnnotation(Annotation annotation) {
        return this.isAction(annotation) ? Triple.of((Object)true, (Object)((Action)annotation).name(), (Object)((Action)annotation).code()) : Triple.of((Object)false, null, null);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

