package com.xforceplus.ultraman.datarule.api.template;

import com.xforceplus.ultraman.datarule.api.util.DataRuleApiAuthTemplateUtil;
import com.xforceplus.ultraman.datarule.domain.dto.DataRuleApiAuthTemplateDTO;
import com.xforceplus.ultraman.datarule.domain.dto.DataRuleApiAuthTemplateEnvDTO;
import com.xforceplus.ultraman.datarule.sync.store.DataRuleStore;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateVo;
import com.xplat.ultraman.api.management.restclient.adapt.template.provider.IAgentTemplateProvider;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;

import java.util.Optional;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/2/23 00:59
 * Description:
 * History:
 */
public class CustomAgentTemplateProvider implements IAgentTemplateProvider {

    private DataRuleStore dataRuleStore;

    public CustomAgentTemplateProvider(DataRuleStore dataRuleStore) {
        this.dataRuleStore = dataRuleStore;
    }

    @Override
    public Optional<AuthTemplateVo> getAgentTemplate(AuthTemplate template) {
        Optional<DataRuleApiAuthTemplateDTO> authTemplateOptl = dataRuleStore.getApisAuthTemplates()
                .stream().filter(tpl -> tpl.getAuthTemplateCode().equals(template.getCode())).findFirst();
        if(!authTemplateOptl.isPresent()) {
            throw new RuntimeException(String.format("auth template not found: templateCode-%s", template.getCode()));
        }
        Optional<DataRuleApiAuthTemplateEnvDTO> apisAuthTemplateEnvOptl = authTemplateOptl.get().getEnvs()
                .stream().filter(tpl -> tpl.getEnvCode().equals(template.getEnv())).findFirst();
        if(!apisAuthTemplateEnvOptl.isPresent()) {
            throw new RuntimeException(String.format("auth template env not found: templateCode-%s, envCode-%s", template.getCode(), template.getEnv()));
        }
        return Optional.ofNullable(DataRuleApiAuthTemplateUtil.getAuthTemplateVo(authTemplateOptl.get(), apisAuthTemplateEnvOptl.get()));
    }
}
