/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.api.executor;

import com.google.common.collect.Lists;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.token.domain.UserType;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import com.xforceplus.ultraman.datarule.api.convertor.DataRuleApiConvertor;
import com.xforceplus.ultraman.datarule.domain.dto.DataRuleApiAuthTemplateDTO;
import com.xforceplus.ultraman.datarule.domain.dto.DataRuleApiDTO;
import com.xplat.ultraman.api.management.pojo.auth.AuthContentPlaceType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import io.geewit.web.utils.JsonUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataRuleApiExecutor {
    private static final Logger log = LoggerFactory.getLogger(DataRuleApiExecutor.class);
    private AgentExecutor restAgentExecutor;
    private DataRuleApiConvertor dataRuleApiConvertor;
    private Map<String, String> authTplMap;

    public DataRuleApiExecutor(AgentExecutor restAgentExecutor, List<String> authTpls) {
        this.restAgentExecutor = restAgentExecutor;
        this.dataRuleApiConvertor = new DataRuleApiConvertor();
        this.authTplMap = authTpls.stream().filter(s -> s.contains(":")).collect(Collectors.toMap(s -> s.split(":")[0], s -> s.split(":")[1]));
    }

    public List<String> execute(DataRuleApiDTO api, DataRuleApiAuthTemplateDTO authTpl) {
        AuthTemplate authTemplate = this.getAuthTemplate(authTpl);
        if (api.getResponse().getBody().isArray()) {
            return this.doExecuteWithReturnList(api, authTemplate);
        }
        return this.doExecuteWithReturnBasicType(api, authTemplate);
    }

    private List<String> doExecuteWithReturnList(DataRuleApiDTO api, AuthTemplate authTemplate) {
        AgentClient.AgentClientBuilder agentClientBuilder = new AgentClient.AgentClientBuilder(authTemplate, api.getUrl()).method(api.getMethod()).headers(this.getUserHeaders()).parameterTypeReference((ParameterTypeReference)new ParameterTypeReference<List>(){});
        List resp = (List)this.restAgentExecutor.execute(agentClientBuilder.builder());
        return null == resp ? Lists.newArrayList() : resp.stream().map(i -> this.dataRuleApiConvertor.convertObjToString(i)).collect(Collectors.toList());
    }

    private List<String> doExecuteWithReturnBasicType(DataRuleApiDTO api, AuthTemplate authTemplate) {
        AgentClient.AgentClientBuilder agentClientBuilder = new AgentClient.AgentClientBuilder(authTemplate, api.getUrl()).method(api.getMethod()).headers(this.getUserHeaders()).parameterTypeReference((ParameterTypeReference)new ParameterTypeReference<Object>(){});
        Object resp = this.restAgentExecutor.execute(agentClientBuilder.builder());
        return null == resp ? Lists.newArrayList() : Arrays.asList(this.dataRuleApiConvertor.convertObjToString(resp));
    }

    private AuthTemplate getAuthTemplate(DataRuleApiAuthTemplateDTO authTpl) {
        if (!this.authTplMap.containsKey(authTpl.getAuthTemplateCode())) {
            throw new RuntimeException(String.format("env code not found in ultraman.datarule.api.authTpls: %s", authTpl.getAuthTemplateCode()));
        }
        String envCode = this.authTplMap.get(authTpl.getAuthTemplateCode());
        return new AuthTemplate(envCode, authTpl.getAuthTemplateCode(), AuthTemplateType.JWT_AUTH, AuthContentPlaceType.CUSTOM);
    }

    private Map<String, Object> getUserHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        IAuthorizedUser user = UserInfoHolder.get();
        if (null != user) {
            try {
                String value = CompressionUtils.encode((String)JsonUtils.toJson((Object)user, TokenView.class));
                headers.put(UserType.USER.userinfoKey(), value);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return headers;
    }
}

