/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.api.usercenter.api.impl;

import com.google.common.collect.Lists;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.token.domain.UserType;
import com.xforceplus.tenant.security.token.domain.view.TokenView;
import com.xforceplus.ultraman.datarule.api.usercenter.api.IUserCenterEnvApi;
import com.xforceplus.ultraman.datarule.api.usercenter.api.constant.UserCenterConstant;
import com.xforceplus.ultraman.datarule.api.usercenter.api.convertor.UserCenterConvertor;
import com.xforceplus.ultraman.datarule.api.usercenter.dto.AuthTplDTO;
import com.xforceplus.ultraman.datarule.api.usercenter.dto.ResponseEntity;
import com.xplat.ultraman.api.management.convertor.executor.ConvertWrapper;
import com.xplat.ultraman.api.management.pojo.auth.AuthContentPlaceType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import io.geewit.web.utils.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCenterEnvApiImpl
implements IUserCenterEnvApi {
    private static final Logger log = LoggerFactory.getLogger(UserCenterEnvApiImpl.class);
    private AgentExecutor restAgentExecutor;
    private UserCenterConvertor userCenterConverter;

    public UserCenterEnvApiImpl(AgentExecutor restAgentExecutor, ConvertWrapper convertWrapper) {
        this.restAgentExecutor = restAgentExecutor;
        this.userCenterConverter = new UserCenterConvertor(convertWrapper);
    }

    @Override
    public List<Map> getTenants(AuthTplDTO authTpl, String searchKey) {
        String url = StringUtils.isEmpty((CharSequence)searchKey) ? UserCenterConstant.TENANT_API : String.format(UserCenterConstant.TENANT_SEARCH_API, searchKey);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertTenantMap);
    }

    @Override
    public List<Map> getTenantRoles(AuthTplDTO authTpl, Long tenantId, String searchKey) {
        String url = StringUtils.isEmpty((CharSequence)searchKey) ? String.format(UserCenterConstant.ROLE_API, tenantId) : String.format(UserCenterConstant.ROLE_SEARCH_API, tenantId, searchKey);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertRoleMap);
    }

    @Override
    public Integer getTenantOrgTotalCount(AuthTplDTO authTpl, Long tenantId) {
        String url = String.format(UserCenterConstant.TENANT_ORG_COUNT_API, tenantId);
        return this.doRequestCount(authTpl, url, this.userCenterConverter::getTotalElementCount);
    }

    @Override
    public Integer getTenantCpyTotalCount(AuthTplDTO authTpl, Long tenantId) {
        String url = String.format(UserCenterConstant.TENANT_CPY_COUNT_API, tenantId);
        return this.doRequestCount(authTpl, url, this.userCenterConverter::getTotalElementCount);
    }

    @Override
    public List<Map> getTenantOrgs(AuthTplDTO authTpl, Long tenantId, String searchKey) {
        String url = StringUtils.isEmpty((CharSequence)searchKey) ? String.format(UserCenterConstant.TENANT_ORG_API, tenantId) : String.format(UserCenterConstant.TENANT_ORG_SEARCH_API, tenantId, searchKey);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertOrgMap);
    }

    @Override
    public List<Map> getTenantCpys(AuthTplDTO authTpl, Long tenantId, String searchKey) {
        String url = StringUtils.isEmpty((CharSequence)searchKey) ? String.format(UserCenterConstant.TENANT_CPY_API, tenantId) : String.format(UserCenterConstant.TENANT_CPY_SEARCH_API, tenantId, searchKey);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertCpyMap);
    }

    @Override
    public Map getUserInfo(AuthTplDTO authTpl, Long tenantId, Long userId) {
        String url = String.format(UserCenterConstant.USER_INFO_API, tenantId, userId);
        ResponseEntity response = this.invokeRestAgentExecutor(authTpl, url);
        return "1".equals(response.getCode()) ? this.userCenterConverter.convertUser((Map)response.getResult()) : new HashMap();
    }

    @Override
    public List<Map> getUserList(AuthTplDTO authTpl, Long tenantId, Map<String, Object> params) {
        String url = String.format(UserCenterConstant.USER_LIST_API, tenantId);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertUsers);
    }

    @Override
    public List<Map> getUserTenantOrgs(AuthTplDTO authTpl, Long tenantId, Long userId) {
        String url = String.format(UserCenterConstant.USER_TENANT_ORG_API, tenantId, userId);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertUserToOrgMap);
    }

    @Override
    public List<Map> getUserTenantOrgsWithFullFlag(AuthTplDTO authTpl, Long tenantId, Long userId) {
        String url = String.format(UserCenterConstant.USER_TENANT_ORG_WITH_FULL_FLAG_API, tenantId, userId);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertUserToOrgMapWithFullFlag);
    }

    @Override
    public List<Map> getUserTenantCpys(AuthTplDTO authTpl, Long tenantId, Long userId) {
        String url = String.format(UserCenterConstant.USER_TENANT_CPY_API, tenantId, userId);
        return this.doRequest(authTpl, url, this.userCenterConverter::convertUserToCpyMap);
    }

    private List<Map> doRequest(AuthTplDTO authTpl, String url, Function<Map, List<Map>> converter) {
        ResponseEntity response = this.invokeRestAgentExecutor(authTpl, url);
        return "1".equals(response.getCode()) ? converter.apply((Map)response.getResult()) : Lists.newArrayList();
    }

    private Integer doRequestCount(AuthTplDTO authTpl, String url, Function<Map, Integer> converter) {
        ResponseEntity response = this.invokeRestAgentExecutor(authTpl, url);
        return "1".equals(response.getCode()) ? converter.apply((Map)response.getResult()) : Integer.valueOf(0);
    }

    private ResponseEntity invokeRestAgentExecutor(AuthTplDTO authTpl, String url) {
        return this.invokeRestAgentExecutor(authTpl, url, null);
    }

    private ResponseEntity invokeRestAgentExecutor(AuthTplDTO authTpl, String url, Map<String, Object> params) {
        AgentClient.AgentClientBuilder agentClientBuilder = new AgentClient.AgentClientBuilder(this.getAuthTemplate(authTpl), url).method(Method.GET).headers(this.getUserHeaders()).parameterTypeReference((ParameterTypeReference)new ParameterTypeReference<ResponseEntity>(){});
        if (null != params) {
            agentClientBuilder.parameters(params);
        }
        return (ResponseEntity)this.restAgentExecutor.execute(agentClientBuilder.builder());
    }

    private Map<String, Object> getUserHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        IAuthorizedUser user = UserInfoHolder.get();
        if (null != user) {
            try {
                String value = CompressionUtils.encode((String)JsonUtils.toJson((Object)user, TokenView.class));
                headers.put(UserType.USER.userinfoKey(), value);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return headers;
    }

    private AuthTemplate getAuthTemplate(AuthTplDTO authTpl) {
        return new AuthTemplate(authTpl.getEnv(), authTpl.getTemplateCode(), AuthTemplateType.JWT_AUTH, AuthContentPlaceType.LOCAl);
    }
}

