/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.api.usercenter.uc;

import com.google.common.collect.Maps;
import com.xforceplus.ultraman.datarule.api.usercenter.api.IUserCenterEnvApi;
import com.xforceplus.ultraman.datarule.api.usercenter.dto.ApiSmartResult;
import com.xforceplus.ultraman.datarule.api.usercenter.dto.AuthTplDTO;
import com.xforceplus.ultraman.datarule.api.usercenter.enums.UserInfoType;
import com.xforceplus.ultraman.datarule.api.usercenter.uc.IUserInfoApi;
import com.xforceplus.ultraman.datarule.domain.enums.AppEnvType;
import com.xplat.ultraman.api.management.restclient.exception.RestCallException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserInfoApiImpl
implements IUserInfoApi {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserInfoApiImpl.class);
    public static final String TEMPLATE_CODE = "usercenter";
    private final int PAGE_NO = 0;
    private final int PAGE_ROW_NUM = 1;
    private int inListComputeLimit = 100;
    private int notInListComputeLimit = 10;
    private IUserCenterEnvApi userCenterEnvApi;
    private AuthTplDTO authTplDTO;

    public DefaultUserInfoApiImpl(IUserCenterEnvApi userCenterEnvApi, String env, Integer inListComputeLimit, Integer notInListComputeLimit) {
        this.userCenterEnvApi = userCenterEnvApi;
        this.inListComputeLimit = null == inListComputeLimit ? this.inListComputeLimit : inListComputeLimit;
        this.notInListComputeLimit = null == notInListComputeLimit ? this.notInListComputeLimit : notInListComputeLimit;
        this.authTplDTO = AuthTplDTO.builder().templateCode(TEMPLATE_CODE).env(AppEnvType.fromCode((String)env).desc()).build();
    }

    @Override
    public Map<String, Object> getUserInfo(Long tenantId, Long userId) {
        return this.userCenterEnvApi.getUserInfo(this.authTplDTO, tenantId, userId);
    }

    @Override
    public Map<String, Object> getUserInfoByUserCode(Long tenantId, String userCode) {
        HashMap params = Maps.newHashMap();
        params.put("userCode", userCode);
        params.put("page", 0);
        params.put("row", 1);
        List<Map> users = this.userCenterEnvApi.getUserList(this.authTplDTO, tenantId, params);
        if (users.isEmpty()) {
            return null;
        }
        return this.getUserInfo(tenantId, Long.valueOf((String)users.get(0).get("id")));
    }

    @Override
    public List<Long> getUserOrgIdsWithFullFlag(Long tenantId, Long userId) {
        List<String> orgIdStrs = this.getUserData(tenantId, userId, "orgId", this::getUserOrgsWithFullFlag);
        return null == orgIdStrs ? null : orgIdStrs.stream().map(Long::valueOf).collect(Collectors.toList());
    }

    @Override
    public List<String> getUserOrgCodesWithFullFlag(Long tenantId, Long userId) {
        return this.getUserData(tenantId, userId, "orgCode", this::getUserOrgsWithFullFlag);
    }

    @Override
    public List<Long> getUserOrgIds(Long tenantId, Long userId) {
        return this.getUserData(tenantId, userId, "orgId", this::getUserOrgs).stream().map(Long::valueOf).collect(Collectors.toList());
    }

    @Override
    public List<String> getUserOrgCodes(Long tenantId, Long userId) {
        return this.getUserData(tenantId, userId, "orgCode", this::getUserOrgs);
    }

    @Override
    public List<String> getUserCpyCodes(Long tenantId, Long userId) {
        return this.getUserData(tenantId, userId, "companyCode", this::getUserCpys);
    }

    @Override
    public List<String> getUserCpyTaxNums(Long tenantId, Long userId) {
        return this.getUserData(tenantId, userId, "taxNum", this::getUserCpys);
    }

    @Override
    public ApiSmartResult<Long> getUserOrgIdsUsingResult(Long tenantId, Long userId) {
        return this.getSmartResult(tenantId, userId, this::getUserOrgIdsWithFullFlag, this::getTenantOrgIds, this::getTenantOrgTotalCount);
    }

    @Override
    public ApiSmartResult<String> getUserOrgCodesUsingResult(Long tenantId, Long userId) {
        return this.getSmartResult(tenantId, userId, this::getUserOrgCodesWithFullFlag, this::getTenantOrgCodes, this::getTenantOrgTotalCount);
    }

    @Override
    public ApiSmartResult<String> getUserCpyCodesUsingResult(Long tenantId, Long userId) {
        return this.getSmartResult(tenantId, userId, this::getUserCpyCodes, this::getTenantCpyCodes, this::getTenantCpyTotalCount);
    }

    @Override
    public ApiSmartResult<String> getUserCpyTaxNumsUsingResult(Long tenantId, Long userId) {
        return this.getSmartResult(tenantId, userId, this::getUserCpyTaxNums, this::getTenantCpyTaxNums, this::getTenantCpyTotalCount);
    }

    @Override
    public List getUserData(Long tenantId, Long userId, UserInfoType userInfoType) {
        if (null == userInfoType) {
            return new ArrayList();
        }
        switch (userInfoType) {
            case USER_ORG_ID: {
                return this.getUserOrgIds(tenantId, userId);
            }
            case USER_ORG_CODE: {
                return this.getUserOrgCodes(tenantId, userId);
            }
            case USER_CPY_CODE: {
                return this.getUserCpyCodes(tenantId, userId);
            }
            case USER_CPY_TAX_NUM: {
                return this.getUserCpyTaxNums(tenantId, userId);
            }
        }
        return new ArrayList();
    }

    @Override
    public ApiSmartResult getUserDataUsingResult(Long tenantId, Long userId, UserInfoType userInfoType) {
        if (null == userInfoType) {
            return new ApiSmartResult();
        }
        switch (userInfoType) {
            case USER_ORG_ID: {
                ApiSmartResult<Long> apiSmartResult = this.getUserOrgIdsUsingResult(tenantId, userId);
                apiSmartResult.setNumeric(true);
                return apiSmartResult;
            }
            case USER_ORG_CODE: {
                return this.getUserOrgCodesUsingResult(tenantId, userId);
            }
            case USER_CPY_CODE: {
                return this.getUserCpyCodesUsingResult(tenantId, userId);
            }
            case USER_CPY_TAX_NUM: {
                return this.getUserCpyTaxNumsUsingResult(tenantId, userId);
            }
        }
        return new ApiSmartResult();
    }

    @Override
    public List<Map> getTenantCpys(Long tenantId) {
        try {
            return this.userCenterEnvApi.getTenantCpys(this.authTplDTO, tenantId, null);
        }
        catch (RestCallException e) {
            log.error("failed to request user center api, {}", (Throwable)e);
            return new ArrayList<Map>();
        }
    }

    private List<String> getTenantData(Long tenantId, String key, Function<Long, List<Map>> getTenantData) {
        return getTenantData.apply(tenantId).stream().map(m -> (String)m.get(key)).filter(v -> null != v).collect(Collectors.toList());
    }

    private List<String> getUserData(Long tenantId, Long userId, String key, BiFunction<Long, Long, List<Map>> getUserData) {
        List<Map> userData = getUserData.apply(tenantId, userId);
        return null == userData ? null : userData.stream().map(m -> (String)m.get(key)).filter(v -> null != v).collect(Collectors.toList());
    }

    private int getTenantOrgTotalCount(Long tenantId) {
        Integer total = this.userCenterEnvApi.getTenantOrgTotalCount(this.authTplDTO, tenantId);
        return null != total ? total : 0;
    }

    private int getTenantCpyTotalCount(Long tenantId) {
        Integer total = this.userCenterEnvApi.getTenantCpyTotalCount(this.authTplDTO, tenantId);
        return null != total ? total : 0;
    }

    private List<Long> getTenantOrgIds(Long tenantId) {
        return this.getTenantData(tenantId, "orgId", this::getTenantOrgs).stream().map(m -> Long.valueOf(m)).collect(Collectors.toList());
    }

    private List<String> getTenantOrgCodes(Long tenantId) {
        return this.getTenantData(tenantId, "orgCode", this::getTenantOrgs);
    }

    private List<String> getTenantCpyCodes(Long tenantId) {
        return this.getTenantData(tenantId, "companyCode", this::getTenantCpys);
    }

    private List<String> getTenantCpyTaxNums(Long tenantId) {
        return this.getTenantData(tenantId, "taxNum", this::getTenantCpys);
    }

    private List<Map> getTenantOrgs(Long tenantId) {
        try {
            return this.userCenterEnvApi.getTenantOrgs(this.authTplDTO, tenantId, null);
        }
        catch (RestCallException e) {
            log.error("failed to request user center api, {}", (Throwable)e);
            return new ArrayList<Map>();
        }
    }

    private List<Map> getUserOrgsWithFullFlag(Long tenantId, Long userId) {
        try {
            return this.userCenterEnvApi.getUserTenantOrgsWithFullFlag(this.authTplDTO, tenantId, userId);
        }
        catch (RestCallException e) {
            log.error("failed to request user center api, {}", (Throwable)e);
            return new ArrayList<Map>();
        }
    }

    private List<Map> getUserOrgs(Long tenantId, Long userId) {
        try {
            return this.userCenterEnvApi.getUserTenantOrgs(this.authTplDTO, tenantId, userId);
        }
        catch (RestCallException e) {
            log.error("failed to request user center api, {}", (Throwable)e);
            return new ArrayList<Map>();
        }
    }

    private List<Map> getUserCpys(Long tenantId, Long userId) {
        try {
            return this.userCenterEnvApi.getUserTenantCpys(this.authTplDTO, tenantId, userId);
        }
        catch (RestCallException e) {
            log.error("failed to request user center api, {}", (Throwable)e);
            return new ArrayList<Map>();
        }
    }

    private <T> ApiSmartResult<T> getSmartResult(Long tenantId, Long userId, BiFunction<Long, Long, List<T>> getUserData, Function<Long, List<T>> getTenantData, Function<Long, Integer> getTenantDataTotalCount) {
        ApiSmartResult<T> smartResult = new ApiSmartResult<T>();
        List<T> userData = getUserData.apply(tenantId, userId);
        if (null == userData) {
            smartResult.setAll(true);
            return smartResult;
        }
        smartResult.setData(userData);
        if (userData.size() >= this.inListComputeLimit) {
            int tenantDataTotalCount = getTenantDataTotalCount.apply(tenantId);
            if (tenantDataTotalCount == userData.size()) {
                smartResult.setAll(true);
                return smartResult;
            }
            int notInListSize = tenantDataTotalCount - userData.size();
            if (notInListSize > 0 && notInListSize <= this.notInListComputeLimit && notInListSize < userData.size()) {
                List<T> tenantData = getTenantData.apply(tenantId);
                tenantData.removeAll(userData);
                smartResult.setUseNotIn(true);
                smartResult.setData(tenantData);
                return smartResult;
            }
        }
        return smartResult;
    }
}

