package com.xforceplus.ultraman.datarule.exception;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/10/6 13:49
 * Description: 数据权限核心错误代码
 * History:
 */
public enum DataCoreErrorCode implements ErrorCode {
    /**
     * SQL解析错误
     */
    SQL_PARSER("0002", "SQL,${sql}SQL解析错误 ${name}");
    /**
     * ￥
     * 异常代码
     */
    private String code;
    /**
     * 异常信息
     */
    private String message;

    /**
     * @param code
     * @param message
     */
    DataCoreErrorCode(String code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * 异常代码，
     *
     * @return String 异常代码
     */
    @Override
    public String code() {
        return this.code;
    }

    /**
     * 异常消息模板
     *
     * @return String 异常消息
     */
    @Override
    public String message() {
        return this.message;
    }
}
