package com.xforceplus.ultraman.datarule.exception;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

import java.util.StringJoiner;

import static com.xforceplus.ultraman.datarule.common.Separator.COLON;
import static com.xforceplus.ultraman.datarule.common.Separator.SPACE;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/10/6 13:49
 * Description: 数据权限核心异常信息
 * History:
 */
public class DataCoreException extends RuntimeException {
    /**
     * 序列化
     */
    private static final long serialVersionUID = -5701283223424569580L;
    /**
     * 消息内容
     */
    protected String code;

    /**
     * 参数名
     */
    protected Params params;

    /**
     * Constructs a new runtime exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     */
    public DataCoreException(String code) {
        this.code = code;
    }

    /**
     * Constructs a new runtime exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public DataCoreException(String code, String message) {
        super(message);
        this.code = code;
    }

    /**
     * 定义异常代码
     * @param errorCode ErrorCode
     */
    public DataCoreException(ErrorCode errorCode) {
        this(errorCode.code(),errorCode.message());
    }

    /**
     * 定义异常类,可以定义参数
     *
     * @param code    代码
     * @param message 消息
     */
    public DataCoreException(String code, String message, Params params) {
        super(message);
        this.code = code;
        this.params = params;
    }

    /**
     * 定义异常类,可以定义参数
     *
     * @param errorCode 异常错误代码
     * @param params    参数
     */
    public DataCoreException(ErrorCode errorCode,Params params) {
        this(errorCode.code(), errorCode.message(),params);
    }

    /**
     * Constructs a new runtime exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public DataCoreException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    /**
     * 定义错误代码
     * @param errorCode 代码
     * @param cause  Throwable
     */
    public DataCoreException(ErrorCode errorCode,Throwable cause) {
        this(errorCode.code(),errorCode.message(),cause);
    }

    /**
     * Constructs a new runtime exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime exception's detail message.
     *
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public DataCoreException(String code, String message, Throwable cause, Params params) {
        super(message, cause);
        this.code = code;
        this.params = params;
    }

    /**
     * 使用异常代码定义
     * @param errorCode 异常代码
     * @param cause 异常
     * @param params 参数
     */
    public DataCoreException(ErrorCode errorCode,Throwable cause, Params params) {
        this(errorCode.code(),errorCode.message(),cause,params);
    }

    /**
     * 重新写异常消息
     *
     * @return String 异常消息
     */
    @Override
    public String getMessage() {
        StringJoiner joiner = new StringJoiner(COLON+ SPACE);
        //判断Code是否为空
        if (StringUtils.isNotEmpty(this.code)) {
            joiner.add(this.code);
        }
        //判断Message 消息是否为空
        String message = super.getMessage();
        if (StringUtils.isNotEmpty(message)) {
            joiner.add(message);
        }
        //将Message 和Message 参数构建为String类型的Message
        if (message != null && this.params != null && this.params.isNotEmpty()) {
            StringSubstitutor stringSubstitutor = new StringSubstitutor(this.params.map());
            message = stringSubstitutor.replace(joiner.toString());
        }
        return message;
    }

    /**
     * 获取错误代码
     *
     * @return String 错误代码
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 获取异常消息的参数
     *
     * @return Params 异常消息的参数
     */
    public Params getParams() {
        return this.params;
    }

    /**
     * 重新构建写消息
     * @return String
     */
    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    /**
     * 重新写toString方法
     *
     * @return String
     */
    @Override
    public String toString() {
        String s = getClass().getName();
        String message = this.getLocalizedMessage();
        return (message != null) ? (s + ": " + message) : s;
    }


    /**
     * Constructs a new runtime exception with the specified cause and a
     * detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of
     * <tt>cause</tt>).  This constructor is useful for runtime exceptions
     * that are little more than wrappers for other throwables.
     *
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public DataCoreException(String code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    /**
     * Constructs a new runtime exception with the specified detail
     * message, cause, suppression enabled or disabled, and writable
     * stack trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @since 1.7
     */
    public DataCoreException(String code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.code = code;
    }


    /**
     * Constructs a new runtime exception with the specified detail
     * message, cause, suppression enabled or disabled, and writable
     * stack trace enabled or disabled.
     *
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @since 1.7
     */
    public DataCoreException(String code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Params params) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.code = code;
        this.params = params;
    }

    /**
     * 构建异常类
     * @param errorCode 消息代码
     * @param cause   the cause.
     * @param enableSuppression whether or not suppression is enabled
     * @param writableStackTrace whether or not the stack trace should
     * @param params 消息参数
     */
    public DataCoreException(ErrorCode errorCode, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Params params) {
        this(errorCode.code(),errorCode.message(), cause, enableSuppression, writableStackTrace,params);
    }
}
