package com.xforceplus.ultraman.datarule.exception;

import com.xforceplus.ultraman.datarule.exception.ErrorCode;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/9/12 00:38
 * Description:
 * History:
 */
public enum DataRuleErrorCode implements ErrorCode {

    /**
     * 无授权模版
     */
    NO_AUTH_TPL("DR001", "server auth tpl required"),

    /**
     * 错误的授权模版代码
     */
    AUTH_TPL_ERROR("DR002", "server auth tpl is wrong"),

    /**
     * 请求应用数据权限失败
     */
    REQUEST_RULE_API_FAILED("DR003", "fetch remote datarule failed"),

    /**
     * 未登录错误代码
     */
    NO_LOGIN("DR004", "login required!"),
    /**
     * 无角色授权信息
     */
    ROLE_IS_EMPTY("DR005", "The username:${username},id:${id} user has no role configured!"),
    /**
     * 结果解析出错
     */
    RULE_ERROR("DR006","rules error"),
    /**
     * 无用户上下文
     */
    NO_USER_CONTEXT("DR007", "no user context!"),
    /**
     * 获取用户信息失败
     */
    USER_INFO_REQUEST_FAIL("DR008", "failed to request user info"),

    CACHE_SETTING_ERROR("DR009", "cache setting error");
    /**
     * 异常代码
     */
    private String code;
    /**
     * 异常消息
     */
    private String message;

    /**
     * 默认构建函数
     *
     * @param code    异常代码
     * @param message 异常消息
     */
    DataRuleErrorCode(String code, String message) {
        this.code = code;
        this.message = message;
    }

    /**
     * 异常代码，
     *
     * @return String 异常代码
     */
    @Override
    public String code() {
        return this.code;
    }

    /**
     * 异常消息模板
     *
     * @return String 异常消息
     */
    @Override
    public String message() {
        return this.message;
    }

}
