package com.xforceplus.ultraman.datarule.exception;

import com.xforceplus.ultraman.datarule.exception.ErrorCode;
import com.xforceplus.ultraman.datarule.exception.DataCoreException;
import com.xforceplus.ultraman.datarule.exception.Params;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/9/12 00:38
 * Description:
 * History:
 */
public class DataRuleException extends DataCoreException {

    /**
     * Constructs a new runtime exception with {@code null} as its
     * detail message.  The cause is not initialized, and may subsequently be
     * initialized by a call to {@link #initCause}.
     *
     * @param code
     */
    public DataRuleException(String code) {
        super(code);
    }

    /**
     * Constructs a new runtime exception with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a
     * call to {@link #initCause}.
     *
     * @param code
     * @param message the detail message. The detail message is saved for
     *                later retrieval by the {@link #getMessage()} method.
     */
    public DataRuleException(String code, String message) {
        super(code, message);
    }

    /**
     * 定义异常代码
     *
     * @param errorCode ErrorCode
     */
    public DataRuleException(ErrorCode errorCode) {
        super(errorCode);
    }

    /**
     * 定义异常类,可以定义参数
     *
     * @param code    代码
     * @param message 消息
     * @param params
     */
    public DataRuleException(String code, String message, Params params) {
        super(code, message, params);
    }

    /**
     * 定义异常类,可以定义参数
     *
     * @param errorCode 异常错误代码
     * @param params    参数
     */
    public DataRuleException(ErrorCode errorCode, Params params) {
        super(errorCode, params);
    }

    /**
     * Constructs a new runtime exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime exception's detail message.
     *
     * @param code
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @since 1.4
     */
    public DataRuleException(String code, String message, Throwable cause) {
        super(code, message, cause);
    }

    /**
     * 定义错误代码
     *
     * @param errorCode 代码
     * @param cause     Throwable
     */
    public DataRuleException(ErrorCode errorCode, Throwable cause) {
        super(errorCode, cause);
    }

    /**
     * Constructs a new runtime exception with the specified detail message and
     * cause.  <p>Note that the detail message associated with
     * {@code cause} is <i>not</i> automatically incorporated in
     * this runtime exception's detail message.
     *
     * @param code
     * @param message the detail message (which is saved for later retrieval
     *                by the {@link #getMessage()} method).
     * @param cause   the cause (which is saved for later retrieval by the
     *                {@link #getCause()} method).  (A <tt>null</tt> value is
     *                permitted, and indicates that the cause is nonexistent or
     *                unknown.)
     * @param params
     * @since 1.4
     */
    public DataRuleException(String code, String message, Throwable cause, Params params) {
        super(code, message, cause, params);
    }

    /**
     * 使用异常代码定义
     *
     * @param errorCode 异常代码
     * @param cause     异常
     * @param params    参数
     */
    public DataRuleException(ErrorCode errorCode, Throwable cause, Params params) {
        super(errorCode, cause, params);
    }

    /**
     * Constructs a new runtime exception with the specified cause and a
     * detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of
     * <tt>cause</tt>).  This constructor is useful for runtime exceptions
     * that are little more than wrappers for other throwables.
     *
     * @param code
     * @param cause the cause (which is saved for later retrieval by the
     *              {@link #getCause()} method).  (A <tt>null</tt> value is
     *              permitted, and indicates that the cause is nonexistent or
     *              unknown.)
     * @since 1.4
     */
    public DataRuleException(String code, Throwable cause) {
        super(code, cause);
    }

    /**
     * Constructs a new runtime exception with the specified detail
     * message, cause, suppression enabled or disabled, and writable
     * stack trace enabled or disabled.
     *
     * @param code
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @since 1.7
     */
    public DataRuleException(String code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(code, message, cause, enableSuppression, writableStackTrace);
    }

    /**
     * Constructs a new runtime exception with the specified detail
     * message, cause, suppression enabled or disabled, and writable
     * stack trace enabled or disabled.
     *
     * @param code
     * @param message            the detail message.
     * @param cause              the cause.  (A {@code null} value is permitted,
     *                           and indicates that the cause is nonexistent or unknown.)
     * @param enableSuppression  whether or not suppression is enabled
     *                           or disabled
     * @param writableStackTrace whether or not the stack trace should
     *                           be writable
     * @param params
     * @since 1.7
     */
    public DataRuleException(String code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Params params) {
        super(code, message, cause, enableSuppression, writableStackTrace, params);
    }

    /**
     * 构建异常类
     *
     * @param errorCode          消息代码
     * @param cause              the cause.
     * @param enableSuppression  whether or not suppression is enabled
     * @param writableStackTrace whether or not the stack trace should
     * @param params             消息参数
     */
    public DataRuleException(ErrorCode errorCode, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Params params) {
        super(errorCode, cause, enableSuppression, writableStackTrace, params);
    }
}
