package com.xforceplus.ultraman.datarule.exception;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.Validate;

import java.util.HashMap;
import java.util.Map;

import static java.util.Collections.emptyMap;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/10/6 13:49
 * Description: 参数设置
 * History:
 */
public class Params {

    /** * 参数NAME不能为空:{@value}*/
    private static final String PARAM_NAME_NULL_ERROR =  "Parameter Name must not be null!";
    /**
     * 参数值不能为空消息
     */
    private static final String PARAM_VALUE_NULL_ERROR = "Parameter Value must not be null!";
    /**
     * 参数容器
     */
    private final Map<String,Object> params;

    /**
     * 默认构建函数
     */
    private Params(Map<String,Object> params) {
        this.params=params;
    }



    /**
     *  判断集合是否为空
     * @return true 表示空，false 表示
     */
    public boolean isEmpty(){
        return MapUtils.isEmpty(this.params);
    }


    /**
     *  判断集合不为空
     * @return true 表示空，false 表示
     */
    public boolean isNotEmpty(){
        return !this.isEmpty();
    }

    /**
     *  获取参数
     * @return Map<String,Object>
     */
    public Map<String,Object> map(){
        return  this.params;
    }

    public static Builder builder(){
        return new Builder();
    }

    /**
     * Builder
     */
    public static class Builder{
        /**
         * 设置参数
         */
        private final Map<String,Object> params;

        private Builder() {
             params=new HashMap<>(4);
        }
        /**
         * 设置参数
         *
         * @param name  参数名
         * @param value 参数值
         * @return NamedParams
         */
        public Builder param(String name, Object value) {
            Validate.notNull(name, PARAM_NAME_NULL_ERROR);
            Validate.notNull(value, PARAM_VALUE_NULL_ERROR);
            params.put(name, value);
            return this;
        }

        /**
         * 构建NamedParms
         * @return NamedParams
         */
        public Params build(){
            //判断如为空，则创建空Map对象，如不为空，则按目前对象创建
           return MapUtils.isEmpty(this.params) ? new Params(emptyMap()):new Params(this.params);
        }
    }
}
