/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.exception;

import com.xforceplus.ultraman.datarule.exception.ErrorCode;
import com.xforceplus.ultraman.datarule.exception.Params;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

public class DataCoreException
extends RuntimeException {
    private static final long serialVersionUID = -5701283223424569580L;
    protected String code;
    protected Params params;

    public DataCoreException(String code) {
        this.code = code;
    }

    public DataCoreException(String code, String message) {
        super(message);
        this.code = code;
    }

    public DataCoreException(ErrorCode errorCode) {
        this(errorCode.code(), errorCode.message());
    }

    public DataCoreException(String code, String message, Params params) {
        super(message);
        this.code = code;
        this.params = params;
    }

    public DataCoreException(ErrorCode errorCode, Params params) {
        this(errorCode.code(), errorCode.message(), params);
    }

    public DataCoreException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public DataCoreException(ErrorCode errorCode, Throwable cause) {
        this(errorCode.code(), errorCode.message(), cause);
    }

    public DataCoreException(String code, String message, Throwable cause, Params params) {
        super(message, cause);
        this.code = code;
        this.params = params;
    }

    public DataCoreException(ErrorCode errorCode, Throwable cause, Params params) {
        this(errorCode.code(), errorCode.message(), cause, params);
    }

    @Override
    public String getMessage() {
        String message;
        StringJoiner joiner = new StringJoiner(": ");
        if (StringUtils.isNotEmpty((CharSequence)this.code)) {
            joiner.add(this.code);
        }
        if (StringUtils.isNotEmpty((CharSequence)(message = super.getMessage()))) {
            joiner.add(message);
        }
        if (message != null && this.params != null && this.params.isNotEmpty()) {
            StringSubstitutor stringSubstitutor = new StringSubstitutor(this.params.map());
            message = stringSubstitutor.replace(joiner.toString());
        }
        return message;
    }

    public String getCode() {
        return this.code;
    }

    public Params getParams() {
        return this.params;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }

    public DataCoreException(String code, Throwable cause) {
        super(cause);
        this.code = code;
    }

    public DataCoreException(String code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.code = code;
    }

    public DataCoreException(String code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Params params) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.code = code;
        this.params = params;
    }

    public DataCoreException(ErrorCode errorCode, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Params params) {
        this(errorCode.code(), errorCode.message(), cause, enableSuppression, writableStackTrace, params);
    }
}

