/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.exception;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.Validate;

public class Params {
    private static final String PARAM_NAME_NULL_ERROR = "Parameter Name must not be null!";
    private static final String PARAM_VALUE_NULL_ERROR = "Parameter Value must not be null!";
    private final Map<String, Object> params;

    private Params(Map<String, Object> params) {
        this.params = params;
    }

    public boolean isEmpty() {
        return MapUtils.isEmpty(this.params);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public Map<String, Object> map() {
        return this.params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> params = new HashMap<String, Object>(4);

        private Builder() {
        }

        public Builder param(String name, Object value) {
            Validate.notNull((Object)name, (String)Params.PARAM_NAME_NULL_ERROR, (Object[])new Object[0]);
            Validate.notNull((Object)value, (String)Params.PARAM_VALUE_NULL_ERROR, (Object[])new Object[0]);
            this.params.put(name, value);
            return this;
        }

        public Params build() {
            return MapUtils.isEmpty(this.params) ? new Params(Collections.emptyMap()) : new Params(this.params);
        }
    }
}

