/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.domain.enums;

import org.apache.commons.lang3.StringUtils;

public enum OperatorType {
    UNKNOWN(""),
    LIKE("like"),
    EQUALS("eq"),
    NOT_EQUALS("ne"),
    GREATER_THAN("gt"),
    GREATER_THAN_EQUALS("ge"),
    LESS_THAN("lt"),
    LESS_THAN_EQUALS("le"),
    MULTIPLE_EQUALS("in"),
    NOT_IN("ni"),
    EXISTS("exists");

    private String code;

    private OperatorType(String code) {
        this.code = code;
    }

    public String code() {
        return this.code;
    }

    public static OperatorType fromCode(String t) {
        if (StringUtils.isEmpty((CharSequence)t)) {
            return UNKNOWN;
        }
        switch (t) {
            case "like": {
                return LIKE;
            }
            case "eq": {
                return EQUALS;
            }
            case "ne": {
                return NOT_EQUALS;
            }
            case "gt": {
                return GREATER_THAN;
            }
            case "ge": {
                return GREATER_THAN_EQUALS;
            }
            case "lt": {
                return LESS_THAN;
            }
            case "le": {
                return LESS_THAN_EQUALS;
            }
            case "in": {
                return MULTIPLE_EQUALS;
            }
            case "ni": {
                return NOT_IN;
            }
            case "exists": {
                return EXISTS;
            }
        }
        return UNKNOWN;
    }
}

