/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.oqssdk.config;

import com.xforceplus.ultraman.datarule.api.executor.DataRuleApiExecutor;
import com.xforceplus.ultraman.datarule.api.template.BocpAuthTemplate;
import com.xforceplus.ultraman.datarule.api.template.CustomAgentTemplateProvider;
import com.xforceplus.ultraman.datarule.api.usercenter.api.IUserCenterEnvApi;
import com.xforceplus.ultraman.datarule.api.usercenter.api.impl.UserCenterEnvApiImpl;
import com.xforceplus.ultraman.datarule.core.property.DataRuleProperties;
import com.xforceplus.ultraman.datarule.sync.store.DataRuleStore;
import com.xplat.ultraman.api.management.convertor.executor.ConvertWrapper;
import com.xplat.ultraman.api.management.convertor.executor.DefaultConvertWrapper;
import com.xplat.ultraman.api.management.restclient.adapt.template.ValueRenderManager;
import com.xplat.ultraman.api.management.restclient.adapt.template.provider.AgentTemplateManager;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.agent.executor.RestAgentExecutor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ultraman.datarule", name={"enabled"}, matchIfMissing=true)
public class DataRuleApiAutoConfiguration {
    @Bean
    public CustomAgentTemplateProvider customAgentTemplateProvider(DataRuleStore dataRuleStore) {
        return new CustomAgentTemplateProvider(dataRuleStore);
    }

    @Bean
    public BocpAuthTemplate bocpAuthTemplate(ValueRenderManager valueRenderManager, AgentTemplateManager agentTemplateManager) {
        return new BocpAuthTemplate(valueRenderManager, agentTemplateManager);
    }

    @Bean(value={"restAgentExecutor"})
    public AgentExecutor agentExecutor() {
        return new RestAgentExecutor();
    }

    @Bean
    @ConditionalOnBean(value={AgentExecutor.class})
    public IUserCenterEnvApi userCenterEnvApi(AgentExecutor restAgentExecutor, ConvertWrapper convertWrapper) {
        return new UserCenterEnvApiImpl(restAgentExecutor, convertWrapper);
    }

    @Bean(value={"convertWrapper"})
    public DefaultConvertWrapper convertWrapper() {
        return new DefaultConvertWrapper();
    }

    @Bean
    public DataRuleApiExecutor dataRuleApiExecutor(AgentExecutor restAgentExecutor, DataRuleProperties dataRuleProperties) {
        return new DataRuleApiExecutor(restAgentExecutor, dataRuleProperties.getApiAuthTpls());
    }
}

