/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.oqssdk.config;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.config.EnableMethodCache;
import com.xforceplus.ultraman.datarule.action.executor.DataRuleActionExecutor;
import com.xforceplus.ultraman.datarule.api.executor.DataRuleApiExecutor;
import com.xforceplus.ultraman.datarule.api.usercenter.api.IUserCenterEnvApi;
import com.xforceplus.ultraman.datarule.api.usercenter.uc.DefaultUserInfoApiImpl;
import com.xforceplus.ultraman.datarule.api.usercenter.uc.IUserInfoApi;
import com.xforceplus.ultraman.datarule.core.aop.SkipDataRuleAspect;
import com.xforceplus.ultraman.datarule.core.controller.DataRuleController;
import com.xforceplus.ultraman.datarule.core.property.DataRuleProperties;
import com.xforceplus.ultraman.datarule.core.provider.EntityDataRuleProviderImpl;
import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.datarule.sync.provider.AppDataRuleProvider;
import com.xforceplus.ultraman.datarule.sync.store.DataRuleStore;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="ultraman.datarule", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={DataRuleProperties.class})
@EnableMethodCache(basePackages={"com.xforceplus.ultraman.datarule.core"})
public class DataRuleCoreAutoConfiguration {
    @Value(value="${xplat.oqsengine.sdk.auth.app-id}")
    private String appId;
    @Value(value="${xplat.oqsengine.sdk.auth.env}")
    private String env;

    @Bean
    public AppDataRuleProvider appDataRuleProvider(DataRuleProperties dataRuleProperties, AgentExecutor restAgentExecutor) {
        return new AppDataRuleProvider(dataRuleProperties, restAgentExecutor);
    }

    @Bean
    public DataRuleStore dataRuleStore(DataRuleProperties dataRuleProperties, AppDataRuleProvider appDataRuleProvider, CacheManager cacheManager) {
        return new DataRuleStore(this.appId, this.env, dataRuleProperties, cacheManager, appDataRuleProvider);
    }

    @Bean
    @ConditionalOnBean(value={IUserCenterEnvApi.class})
    public IUserInfoApi defaultUcApi(DataRuleProperties dataRuleProperties, IUserCenterEnvApi userCenterEnvApi) {
        return new DefaultUserInfoApiImpl(userCenterEnvApi, this.env, dataRuleProperties.getInListComputeLimit(), dataRuleProperties.getNotInListComputeLimit());
    }

    @Bean
    @ConditionalOnBean(value={DataRuleActionExecutor.class, DataRuleApiExecutor.class})
    public IDataRuleProvider dataRuleProvider(DataRuleProperties dataRuleProperties, DataRuleStore appDataRuleStore, IUserInfoApi defaultUcApi, DataRuleActionExecutor dataRuleActionExecutor, DataRuleApiExecutor dataRuleApiExecutor) {
        return new EntityDataRuleProviderImpl(dataRuleProperties, appDataRuleStore, defaultUcApi, dataRuleActionExecutor, dataRuleApiExecutor);
    }

    @Bean
    public SkipDataRuleAspect skipDataRuleAspect() {
        return new SkipDataRuleAspect();
    }

    @Bean
    public DataRuleController dataRuleController(DataRuleStore appDataRuleStore, DataRuleProperties dataRuleProperties) {
        return new DataRuleController(appDataRuleStore, dataRuleProperties);
    }
}

