package com.xforceplus.ultraman.datarule.oqssdk.config;

import com.xforceplus.ultraman.datarule.action.executor.DataRuleActionExecutor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.xforceplus.ultraman.datarule.action.DataRuleActionRegisterPostProcesser;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/10/1 17:41
 * Description:
 * History:
 */
@Configuration
@ConditionalOnProperty(prefix = "ultraman.datarule", name = "enabled", matchIfMissing = true)
public class DataRuleActionAutoConfiguration {

    @Bean
    public DataRuleActionRegisterPostProcesser dataRuleActionRegisterPostProcesser() {
        return new DataRuleActionRegisterPostProcesser();
    }

    @Bean
    public DataRuleActionExecutor dataRuleActionExecutor(ApplicationContext applicationContext) {
        return new DataRuleActionExecutor(applicationContext);
    }

}
