package com.xforceplus.ultraman.datarule.oqssdk.config;

import com.xforceplus.ultraman.datarule.api.executor.DataRuleApiExecutor;
import com.xforceplus.ultraman.datarule.api.template.BocpAuthTemplate;
import com.xforceplus.ultraman.datarule.api.template.CustomAgentTemplateProvider;
import com.xforceplus.ultraman.datarule.api.usercenter.api.IUserCenterEnvApi;
import com.xforceplus.ultraman.datarule.api.usercenter.api.impl.UserCenterEnvApiImpl;
import com.xforceplus.ultraman.datarule.core.property.DataRuleProperties;
import com.xforceplus.ultraman.datarule.sync.store.DataRuleStore;
import com.xplat.ultraman.api.management.convertor.executor.ConvertWrapper;
import com.xplat.ultraman.api.management.convertor.executor.DefaultConvertWrapper;
import com.xplat.ultraman.api.management.restclient.adapt.template.ValueRenderManager;
import com.xplat.ultraman.api.management.restclient.adapt.template.provider.AgentTemplateManager;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.config.RestClientConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/9/13 23:27
 * Description:
 * History:
 */
@Configuration
@ConditionalOnProperty(prefix = "ultraman.datarule", name = "enabled", matchIfMissing = true)
@Import(RestClientConfiguration.class)
public class DataRuleApiAutoConfiguration {

    @Bean
    public CustomAgentTemplateProvider customAgentTemplateProvider(DataRuleStore dataRuleStore) {
        return new CustomAgentTemplateProvider(dataRuleStore);
    }

//    @Bean
////    @ConditionalOnBean(DataRuleStore.class)
//    public DataRuleAuthTemplate dataRuleAuthTemplate(DataRuleStore dataRuleStore) {
//        return new DataRuleAuthTemplate(dataRuleStore);
//    }

    @Bean
    public BocpAuthTemplate bocpAuthTemplate(ValueRenderManager valueRenderManager, AgentTemplateManager agentTemplateManager) {
        return new BocpAuthTemplate(valueRenderManager, agentTemplateManager);
    }

//    @Bean("restAuthTemplateProvider")
//    public AuthTemplateProvider authTemplateProvider() {
//        return new RestAuthTemplateProvider();
//    }

//    @Bean("restAgentExecutor")
//    @ConditionalOnMissingBean(RestAgentExecutor.class)
//    public AgentExecutor dataRuleRestAgentExecutor() {
//        return new RestAgentExecutor();
//    }
//
//    @Bean
//    public ApiKeyAuthTemplate apiKeyAuthTemplate() {
//        ApiKeyAuthTemplate template = new ApiKeyAuthTemplate();
//        return template;
//    }
//
//    @Bean
//    public UserCenterAuthTemplate userCenterAuthTemplate() {
//        UserCenterAuthTemplate template = new UserCenterAuthTemplate();
//        return template;
//    }
//
//    @Bean
//    public OpenApiAuthTemplate openApiAuthTemplate() {
//        OpenApiAuthTemplate template = new OpenApiAuthTemplate();
//        return template;
//    }
//
//    @Bean
//    public ValueRenderManager valueRenderManager() {
//        ValueRenderManager manager = new ValueRenderManager();
//        return manager;
//    }
//
//    @Bean("envValueRender")
//    public ValueRenderEnvImpl valueRenderEnv() {
//        ValueRenderEnvImpl valueRenderEnv = new ValueRenderEnvImpl();
//        return valueRenderEnv;
//    }

    @Bean
    @ConditionalOnBean(AgentExecutor.class)
    public IUserCenterEnvApi userCenterEnvApi(AgentExecutor dataRuleRestAgentExecutor, ConvertWrapper convertWrapper){
        return new UserCenterEnvApiImpl(dataRuleRestAgentExecutor, convertWrapper);
    }

    @Bean("convertWrapper")
    public DefaultConvertWrapper convertWrapper() {
        return new DefaultConvertWrapper();
    }

    @Bean
    public DataRuleApiExecutor dataRuleApiExecutor(AgentExecutor dataRuleRestAgentExecutor, DataRuleProperties dataRuleProperties) {
        return new DataRuleApiExecutor(dataRuleRestAgentExecutor, dataRuleProperties.getApiAuthTpls());
    }

}
