package com.xforceplus.ultraman.datarule.oqssdk.config;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.anno.config.EnableMethodCache;
import com.xforceplus.ultraman.datarule.action.executor.DataRuleActionExecutor;
import com.xforceplus.ultraman.datarule.api.executor.DataRuleApiExecutor;
import com.xforceplus.ultraman.datarule.api.usercenter.api.IUserCenterEnvApi;
import com.xforceplus.ultraman.datarule.core.aop.SkipDataRuleAspect;
import com.xforceplus.ultraman.datarule.core.controller.DataRuleHelperController;
import com.xforceplus.ultraman.datarule.core.controller.DataRuleViewController;
import com.xforceplus.ultraman.datarule.core.executor.EntityRowRuleParseExecutor;
import com.xforceplus.ultraman.datarule.core.property.DataRuleProperties;
import com.xforceplus.ultraman.datarule.sync.provider.AppDataRuleProvider;
import com.xforceplus.ultraman.datarule.core.provider.IDataRuleProvider;
import com.xforceplus.ultraman.datarule.core.provider.EntityDataRuleProviderImpl;
import com.xforceplus.ultraman.datarule.api.usercenter.uc.DefaultUserInfoApiImpl;
import com.xforceplus.ultraman.datarule.api.usercenter.uc.IUserInfoApi;
import com.xforceplus.ultraman.datarule.sync.store.DataRuleStore;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/9/13 23:27
 * Description:
 * History:
 */
@Configuration
@ConditionalOnProperty(prefix = "ultraman.datarule", name = "enabled", matchIfMissing = true)
@EnableConfigurationProperties(value = DataRuleProperties.class)
@EnableMethodCache(basePackages = "com.xforceplus.ultraman.datarule.core")
public class DataRuleCoreAutoConfiguration {

    @Value("${xplat.oqsengine.sdk.auth.app-id}")
    private String appId;
    @Value("${xplat.oqsengine.sdk.auth.env}")
    private String env;

    @Bean
    public AppDataRuleProvider appDataRuleProvider(
            DataRuleProperties dataRuleProperties,
            AgentExecutor dataRuleRestAgentExecutor) {
        return new AppDataRuleProvider(dataRuleProperties, dataRuleRestAgentExecutor);
    }

    @Bean
    public DataRuleStore dataRuleStore(
            DataRuleProperties dataRuleProperties,
            AppDataRuleProvider appDataRuleProvider,
            CacheManager cacheManager) {
        return new DataRuleStore(appId, env, dataRuleProperties, cacheManager, appDataRuleProvider);
    }

    @Bean
    @ConditionalOnBean(IUserCenterEnvApi.class)
    public IUserInfoApi defaultUcApi(DataRuleProperties dataRuleProperties, IUserCenterEnvApi userCenterEnvApi) {
        return new DefaultUserInfoApiImpl(userCenterEnvApi, env, dataRuleProperties.getInListComputeLimit(), dataRuleProperties.getNotInListComputeLimit());
    }

    @Bean
    @ConditionalOnBean(value = {DataRuleActionExecutor.class, DataRuleApiExecutor.class})
    public EntityRowRuleParseExecutor entityRowRuleParseExecutor(
            DataRuleProperties dataRuleProperties,
            IUserInfoApi defaultUcApi,
            DataRuleActionExecutor dataRuleActionExecutor,
            DataRuleApiExecutor dataRuleApiExecutor) {
        return new EntityRowRuleParseExecutor(dataRuleProperties, defaultUcApi, dataRuleActionExecutor, dataRuleApiExecutor);
    }

    @Bean
    @ConditionalOnBean(value = {EntityRowRuleParseExecutor.class})
    public IDataRuleProvider dataRuleProvider(
            DataRuleProperties dataRuleProperties,
            EntityRowRuleParseExecutor entityRowRuleParseExecutor,
            DataRuleStore appDataRuleStore,
            IUserInfoApi defaultUcApi) {
        return new EntityDataRuleProviderImpl(dataRuleProperties, entityRowRuleParseExecutor, appDataRuleStore, defaultUcApi);
    }

    @Bean
    public SkipDataRuleAspect skipDataRuleAspect() {
        return new SkipDataRuleAspect();
    }

    @Bean
    public DataRuleHelperController dataRuleHelperController(DataRuleStore appDataRuleStore, IDataRuleProvider dataRuleProvider, DataRuleProperties dataRuleProperties){
        return new DataRuleHelperController(appDataRuleStore, dataRuleProvider, dataRuleProperties);
    }

    @Bean
    public DataRuleViewController dataRuleViewController(IDataRuleProvider dataRuleProvider){
        return new DataRuleViewController(dataRuleProvider);
    }
}
