package com.xforceplus.ultraman.datarule.sync.provider;

import com.alibaba.fastjson2.JSON;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.ultraman.datarule.domain.dto.v2.AppDataRuleV2DTO;
import com.xforceplus.ultraman.datarule.exception.DataRuleErrorCode;
import com.xforceplus.ultraman.datarule.exception.DataRuleException;
import com.xforceplus.ultraman.datarule.core.property.DataRuleProperties;
import com.xplat.ultraman.api.management.pojo.auth.AuthContentPlaceType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/9/12 00:38
 * Description:
 * History:
 */
@Slf4j
public class AppDataRuleProvider {

    private static final String RESPONSE_SUCCESS_CODE = "0";

    private AgentExecutor restAgentExecutor;
    private DataRuleProperties dataRuleProperties;

    public AppDataRuleProvider(DataRuleProperties dataRuleProperties, AgentExecutor restAgentExecutor) {
        this.dataRuleProperties = dataRuleProperties;
        this.restAgentExecutor = restAgentExecutor;
    }

    public AppDataRuleV2DTO getAppDataRule(Long appId, Long envId) {
        AppDataRuleV2DTO appDataRuleDTO = null;
        try {
            AgentClient agentClient = new AgentClient
                    .AgentClientBuilder<ResponseEntity>(getAuthTemplate(), dataRuleProperties.getServerUrl())
                    .method(Method.GET)
                    .pathVariables("appId", String.valueOf(appId))
                    .parameters("envId", String.valueOf(envId))
                    .parameterTypeReference(new ParameterTypeReference<ResponseEntity>() {})
                    .builder();
            ResponseEntity resp = (ResponseEntity) restAgentExecutor.execute(agentClient);

            if(RESPONSE_SUCCESS_CODE.equals(resp.getCode())) {
                if (null != resp.getResult()) {
                    appDataRuleDTO = JSON.parseObject((String)resp.getResult(), AppDataRuleV2DTO.class);
                    if(MapUtils.isNotEmpty(appDataRuleDTO.getEntityRules())) {
                        log.debug("get app datarule successfully: {}", resp.getMessage());
                        return appDataRuleDTO;
                    }
                }
            } else {
                log.warn("failed to get app datarule: {}", resp.getMessage());
            }
        } catch (Exception e) {
            throw new DataRuleException(DataRuleErrorCode.REQUEST_RULE_API_FAILED, e);
        }

        return appDataRuleDTO;
    }

    /**
     * 获取应用配置的服务地址获取授权模版
     * @return
     */
    private AuthTemplate getAuthTemplate() {
        String authTpl = dataRuleProperties.getServerAuthTpl();

        if(StringUtils.isEmpty(authTpl)) {
            throw new DataRuleException(DataRuleErrorCode.NO_AUTH_TPL);
        }

        String[] tplParams = authTpl.split(":");
        if(tplParams.length != 2) {
            throw new DataRuleException(DataRuleErrorCode.AUTH_TPL_ERROR);
        }

        return new AuthTemplate(tplParams[1], tplParams[0], AuthTemplateType.JWT_AUTH, AuthContentPlaceType.LOCAl);
    }

}
