/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.sync.provider;

import com.alibaba.fastjson2.JSON;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.ultraman.datarule.core.property.DataRuleProperties;
import com.xforceplus.ultraman.datarule.domain.dto.v2.AppDataRuleV2DTO;
import com.xforceplus.ultraman.datarule.exception.DataRuleErrorCode;
import com.xforceplus.ultraman.datarule.exception.DataRuleException;
import com.xforceplus.ultraman.datarule.exception.ErrorCode;
import com.xplat.ultraman.api.management.pojo.auth.AuthContentPlaceType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDataRuleProvider {
    private static final Logger log = LoggerFactory.getLogger(AppDataRuleProvider.class);
    private static final String RESPONSE_SUCCESS_CODE = "0";
    private AgentExecutor restAgentExecutor;
    private DataRuleProperties dataRuleProperties;

    public AppDataRuleProvider(DataRuleProperties dataRuleProperties, AgentExecutor restAgentExecutor) {
        this.dataRuleProperties = dataRuleProperties;
        this.restAgentExecutor = restAgentExecutor;
    }

    public AppDataRuleV2DTO getAppDataRule(Long appId, Long envId) {
        AppDataRuleV2DTO appDataRuleDTO = null;
        try {
            AgentClient agentClient = new AgentClient.AgentClientBuilder(this.getAuthTemplate(), this.dataRuleProperties.getServerUrl()).method(Method.GET).pathVariables("appId", String.valueOf(appId)).parameters("envId", (Object)String.valueOf(envId)).parameterTypeReference((ParameterTypeReference)new ParameterTypeReference<ResponseEntity>(){}).builder();
            ResponseEntity resp = (ResponseEntity)this.restAgentExecutor.execute(agentClient);
            if (RESPONSE_SUCCESS_CODE.equals(resp.getCode())) {
                if (null != resp.getResult() && MapUtils.isNotEmpty((Map)(appDataRuleDTO = (AppDataRuleV2DTO)JSON.parseObject((String)((String)resp.getResult()), AppDataRuleV2DTO.class)).getEntityRules())) {
                    log.debug("get app datarule successfully: {}", (Object)resp.getMessage());
                    return appDataRuleDTO;
                }
            } else {
                log.warn("failed to get app datarule: {}", (Object)resp.getMessage());
            }
        }
        catch (Exception e) {
            throw new DataRuleException((ErrorCode)DataRuleErrorCode.REQUEST_RULE_API_FAILED, (Throwable)e);
        }
        return appDataRuleDTO;
    }

    private AuthTemplate getAuthTemplate() {
        String authTpl = this.dataRuleProperties.getServerAuthTpl();
        if (StringUtils.isEmpty((CharSequence)authTpl)) {
            throw new DataRuleException((ErrorCode)DataRuleErrorCode.NO_AUTH_TPL);
        }
        String[] tplParams = authTpl.split(":");
        if (tplParams.length != 2) {
            throw new DataRuleException((ErrorCode)DataRuleErrorCode.AUTH_TPL_ERROR);
        }
        return new AuthTemplate(tplParams[1], tplParams[0], AuthTemplateType.JWT_AUTH, AuthContentPlaceType.LOCAl);
    }
}

