/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.datarule.sync.store;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.RefreshPolicy;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.template.QuickConfig;
import com.xforceplus.ultraman.datarule.core.property.DataRuleProperties;
import com.xforceplus.ultraman.datarule.domain.dto.DataRuleApiAuthTemplateDTO;
import com.xforceplus.ultraman.datarule.domain.dto.v2.AppDataRuleV2DTO;
import com.xforceplus.ultraman.datarule.domain.dto.v2.EntityActionRuleDetailDTO;
import com.xforceplus.ultraman.datarule.domain.enums.EntityActionType;
import com.xforceplus.ultraman.datarule.domain.pojo.LoginInfo;
import com.xforceplus.ultraman.datarule.sync.provider.AppDataRuleProvider;
import com.xforceplus.ultraman.datarule.sync.store.DataRuleUtil;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;

public class DataRuleStore {
    public final Integer APP_DATA_RULE_CACHE_LOCAL_LIMIT = 5;
    public final Integer TASK_LOGIN_INFO_CACHE_LOCAL_LIMIT = 100;
    private final Integer STOP_REFRESH_AFTER_LAST_ACCESS = 60;
    public final String APP_DATA_RULE = "appDataRule-env%s";
    private final String APP_RULE_CACHE_KEY = "appDataRule-env%s-app%s";
    public final String ENTITY_ACTION_RULE = "entityActionRule-env%s";
    private final String ENTITY_ACTION_RULE_CACHE_KEY = "entityActionRule-env%s-user%s-tenant%s-entity%s-action%s";
    private final String ENTITY_ACTION_RULE_COLUMN_CACHE_KEY = "entityActionRule-env%s-user%s-tenant%s-entity%s-action%s-columns";
    public final String TASK_ENTITY_ACTION_RULE = "taskEntityActionRule-env%s";
    private final String TASK_ENTITY_ACTION_RULE_CACHE_KEY = "taskEntityActionRule-env%s-user%s-tenant%s-entity%s-action%s";
    private final String TASK_ENTITY_ACTION_RULE_COLUMN_CACHE_KEY = "taskEntityActionRule-env%s-user%s-tenant%s-entity%s-action%s-columns";
    public final String LOGIN_INFO_STORE_KEY = "loginInfoStore-env%s";
    public final String LOGIN_INFO_BY_API_KEY = "loginInfoStore-env%s-user%s-tenant%s";
    private String appId;
    private String envId;
    private DataRuleProperties dataRuleProperties;
    private String appDataRuleKey;
    private CacheManager cacheManager;
    private AppDataRuleProvider appDataRuleProvider;
    private Cache<String, AppDataRuleV2DTO> appDataRuleCache;
    private Cache<String, EntityActionRuleDetailDTO> entityActionRuleCache;
    private Cache<String, EntityActionRuleDetailDTO> taskEntityActionRuleCache;
    private Cache<String, LoginInfo> loginInfoCache;

    public DataRuleStore(String appId, String env, DataRuleProperties dataRuleProperties, CacheManager cacheManager, AppDataRuleProvider appDataRuleProvider) {
        this.appId = appId;
        this.envId = env;
        this.dataRuleProperties = dataRuleProperties;
        this.appDataRuleProvider = appDataRuleProvider;
        this.cacheManager = cacheManager;
        this.appDataRuleKey = String.format("appDataRule-env%s-app%s", this.envId, appId);
    }

    @PostConstruct
    public void init() {
        CacheType cacheType = DataRuleUtil.getCacheType(this.dataRuleProperties.getCacheType());
        QuickConfig appDataRuleQC = QuickConfig.newBuilder((String)String.format("appDataRule-env%s", this.envId)).cacheType(cacheType).localLimit(this.APP_DATA_RULE_CACHE_LOCAL_LIMIT).loader(key -> this.appDataRuleProvider.getAppDataRule(Long.valueOf(this.appId), Long.valueOf(this.envId))).refreshPolicy(RefreshPolicy.newPolicy((long)this.dataRuleProperties.getCacheRefreshTime(), (TimeUnit)TimeUnit.MINUTES).stopRefreshAfterLastAccess((long)this.STOP_REFRESH_AFTER_LAST_ACCESS.intValue(), TimeUnit.MINUTES)).penetrationProtect(Boolean.valueOf(true)).build();
        this.appDataRuleCache = this.cacheManager.getOrCreateCache(appDataRuleQC);
        QuickConfig entityQC = QuickConfig.newBuilder((String)String.format("entityActionRule-env%s", this.envId)).cacheType(cacheType).expire(Duration.ofMinutes(this.dataRuleProperties.getCacheExpireTime())).penetrationProtect(Boolean.valueOf(true)).build();
        this.entityActionRuleCache = this.cacheManager.getOrCreateCache(entityQC);
        QuickConfig taskEntityQC = QuickConfig.newBuilder((String)String.format("taskEntityActionRule-env%s", this.envId)).cacheType(cacheType).expire(Duration.ofMinutes(this.dataRuleProperties.getCacheExpireTime())).penetrationProtect(Boolean.valueOf(true)).build();
        this.taskEntityActionRuleCache = this.cacheManager.getOrCreateCache(taskEntityQC);
        QuickConfig loginInfoQC = QuickConfig.newBuilder((String)String.format("loginInfoStore-env%s", this.envId)).cacheType(cacheType).localLimit(this.TASK_LOGIN_INFO_CACHE_LOCAL_LIMIT).expire(Duration.ofMinutes(this.dataRuleProperties.getCacheExpireTime())).penetrationProtect(Boolean.valueOf(true)).build();
        this.loginInfoCache = this.cacheManager.getOrCreateCache(loginInfoQC);
    }

    public AppDataRuleV2DTO getAppDataRule() {
        return (AppDataRuleV2DTO)this.appDataRuleCache.get((Object)this.appDataRuleKey);
    }

    public void putEntityActionRule(String loginId, String tenantCode, Long entityId, EntityActionType entityActionType, EntityActionRuleDetailDTO ruleNodeDTOS) {
        String entityRuleKey = String.format("entityActionRule-env%s-user%s-tenant%s-entity%s-action%s", this.envId, loginId, tenantCode, entityId, entityActionType);
        this.entityActionRuleCache.put((Object)entityRuleKey, (Object)ruleNodeDTOS);
    }

    public void putEntityActionRuleColumns(String loginId, String tenantCode, Long entityId, EntityActionType entityActionType, EntityActionRuleDetailDTO ruleNodeDTOS) {
        String entityRuleKey = String.format("entityActionRule-env%s-user%s-tenant%s-entity%s-action%s-columns", this.envId, loginId, tenantCode, entityId, entityActionType);
        this.entityActionRuleCache.put((Object)entityRuleKey, (Object)ruleNodeDTOS);
    }

    public EntityActionRuleDetailDTO getEntityActionRule(String loginId, String tenantCode, Long entityId, EntityActionType entityActionType) {
        String entityRuleKey = String.format("entityActionRule-env%s-user%s-tenant%s-entity%s-action%s", this.envId, loginId, tenantCode, entityId, entityActionType);
        return (EntityActionRuleDetailDTO)this.entityActionRuleCache.get((Object)entityRuleKey);
    }

    public EntityActionRuleDetailDTO getEntityActionRuleColumns(String loginId, String tenantCode, Long entityId, EntityActionType entityActionType) {
        String entityRuleKey = String.format("entityActionRule-env%s-user%s-tenant%s-entity%s-action%s-columns", this.envId, loginId, tenantCode, entityId, entityActionType);
        return (EntityActionRuleDetailDTO)this.entityActionRuleCache.get((Object)entityRuleKey);
    }

    public void putTaskEntityActionRule(Long userId, String tenantCode, Long entityId, EntityActionType entityActionType, EntityActionRuleDetailDTO ruleNodeDTOS) {
        String entityRuleKey = String.format("taskEntityActionRule-env%s-user%s-tenant%s-entity%s-action%s", this.envId, userId, tenantCode, entityId, entityActionType);
        this.taskEntityActionRuleCache.put((Object)entityRuleKey, (Object)ruleNodeDTOS);
    }

    public void putTaskEntityActionRuleColumns(Long userId, String tenantCode, Long entityId, EntityActionType entityActionType, EntityActionRuleDetailDTO ruleNodeDTOS) {
        String entityRuleKey = String.format("taskEntityActionRule-env%s-user%s-tenant%s-entity%s-action%s-columns", this.envId, userId, tenantCode, entityId, entityActionType);
        this.taskEntityActionRuleCache.put((Object)entityRuleKey, (Object)ruleNodeDTOS);
    }

    public EntityActionRuleDetailDTO getTaskEntityActionRule(Long userId, String tenantCode, Long entityId, EntityActionType entityActionType) {
        String entityRuleKey = String.format("taskEntityActionRule-env%s-user%s-tenant%s-entity%s-action%s", this.envId, userId, tenantCode, entityId, entityActionType);
        return (EntityActionRuleDetailDTO)this.taskEntityActionRuleCache.get((Object)entityRuleKey);
    }

    public EntityActionRuleDetailDTO getTaskEntityActionRuleColumns(Long userId, String tenantCode, Long entityId, EntityActionType entityActionType) {
        String entityRuleKey = String.format("taskEntityActionRule-env%s-user%s-tenant%s-entity%s-action%s-columns", this.envId, userId, tenantCode, entityId, entityActionType);
        return (EntityActionRuleDetailDTO)this.taskEntityActionRuleCache.get((Object)entityRuleKey);
    }

    public void clearAppDataRuleCache() {
        this.appDataRuleCache.remove((Object)this.appDataRuleKey);
    }

    public void clearEntityActionRuleCache(String loginId, String tenantCode, Long entityId, EntityActionType entityActionType) {
        String entityRuleKey = String.format("entityActionRule-env%s-user%s-tenant%s-entity%s-action%s", this.envId, loginId, tenantCode, entityId, entityActionType);
        this.entityActionRuleCache.remove((Object)entityRuleKey);
    }

    public void clearEntityActionRuleColumnsCache(String loginId, String tenantCode, Long entityId, EntityActionType entityActionType) {
        String entityRuleKey = String.format("entityActionRule-env%s-user%s-tenant%s-entity%s-action%s-columns", this.envId, loginId, tenantCode, entityId, entityActionType);
        this.entityActionRuleCache.remove((Object)entityRuleKey);
    }

    public void clearTaskEntityRowRuleCache(String userKey, String tenantCode, Long entityId, EntityActionType entityActionType) {
        String entityRuleKey = String.format("entityActionRule-env%s-user%s-tenant%s-entity%s-action%s", this.envId, userKey, tenantCode, entityId, entityActionType);
        this.taskEntityActionRuleCache.remove((Object)entityRuleKey);
    }

    public void putLoginInfoByApi(Long tenantId, String userKey, LoginInfo loginInfo) {
        String loginInfoKey = String.format("loginInfoStore-env%s-user%s-tenant%s", this.envId, userKey, tenantId);
        this.loginInfoCache.put((Object)loginInfoKey, (Object)loginInfo);
    }

    public LoginInfo getLoginInfoByApi(Long tenantId, String userKey) {
        String loginInfoKey = String.format("loginInfoStore-env%s-user%s-tenant%s", this.envId, userKey, tenantId);
        return (LoginInfo)this.loginInfoCache.get((Object)loginInfoKey);
    }

    public void clearLoginInfoByApi(String userKey, Long tenantId) {
        String loginInfoKey = String.format("loginInfoStore-env%s-user%s-tenant%s", this.envId, userKey, tenantId);
        this.loginInfoCache.remove((Object)loginInfoKey);
    }

    public List<DataRuleApiAuthTemplateDTO> getApisAuthTemplates() {
        return this.getAppDataRule().getApiAuthTemplates();
    }
}

