/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.flows.pojo.common;

import com.xforceplus.ultraman.flows.pojo.common.ErrorCode;

public class HttpResponse<T> {
    public static final Integer OK = 1;
    public static final Integer FAIL = 0;
    private Integer code;
    private String message;
    private T result;

    public static HttpResponse ok(String message) {
        HttpResponse response = new HttpResponse();
        response.setCode(OK);
        response.setMessage(message);
        return response;
    }

    public static <T> HttpResponse ok(String message, T result) {
        HttpResponse<T> response = new HttpResponse<T>();
        response.setCode(OK);
        response.setMessage(message);
        response.result = result;
        return response;
    }

    public static HttpResponse failed(String message) {
        HttpResponse response = new HttpResponse();
        response.setCode(FAIL);
        response.setMessage(message);
        return response;
    }

    public static HttpResponse from(Integer code, String message) {
        HttpResponse response = new HttpResponse();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static HttpResponse from(ErrorCode code, Object ... params) {
        HttpResponse response = new HttpResponse();
        response.setCode(code.code());
        response.setMessage(String.format(code.msg(), params));
        return response;
    }

    public static HttpResponse from(ErrorCode errorCode) {
        HttpResponse response = new HttpResponse();
        response.setCode(errorCode.code());
        response.setMessage(errorCode.msg());
        return response;
    }

    public static <T> HttpResponse<T> from(Integer code, String message, T result) {
        HttpResponse<T> response = new HttpResponse<T>();
        response.setCode(code);
        response.setMessage(message);
        response.setResult(result);
        return response;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", result=" + this.result + '}';
    }
}

