/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.aliyunoss.business;

import com.alibaba.fastjson2.JSON;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.xforceplus.ultraman.metadata.aliyunoss.constant.AliyunOSSConstant;
import com.xforceplus.ultraman.metadata.aliyunoss.constant.AliyunOSSConstant2;
import com.xforceplus.ultraman.metadata.jsonschema.enums.SchemaMetadataType;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.version.SchemaAppVersion;
import com.xforceplus.ultraman.metadata.jsonschema.pojo.version.SchemaEnvAppVersion;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataAliyunOSSClient {
    private static final Logger log = LoggerFactory.getLogger(MetadataAliyunOSSClient.class);
    private final OSS oss;
    private final String profile;

    public MetadataAliyunOSSClient(OSS oss, String profile) {
        this.oss = oss;
        this.profile = profile;
    }

    public void saveAppVersion(Long appId, String version, SchemaAppVersion schemaAppVersion, boolean force) {
        Optional.ofNullable(schemaAppVersion).ifPresent(o -> {
            String filePath = AliyunOSSConstant2.getAppVersionFilePath(appId, version);
            if (!this.isObjectExist(filePath) || force) {
                this.oss.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(JSON.toJSONString((Object)o).getBytes(StandardCharsets.UTF_8)));
            } else {
                log.warn("OSS \u5e94\u7528{}\u7248\u672c{}\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7", (Object)appId, (Object)version);
            }
        });
    }

    public void saveEnvAppVersion(String envCode, String appCode, SchemaAppVersion schemaAppVersion) {
        Optional.ofNullable(schemaAppVersion).ifPresent(o -> this.saveEnvAppVersion(envCode, appCode, JSON.toJSONString((Object)o)));
    }

    public void saveEnvAppVersion(String envCode, String appCode, String schemaAppVersionStr) {
        if (this.doNonProdEnvUploadToNonDevEnv(envCode)) {
            return;
        }
        Optional.ofNullable(schemaAppVersionStr).ifPresent(o -> {
            String filePath = AliyunOSSConstant2.getEnvAppVersionFilePath(envCode, appCode);
            this.oss.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(o.getBytes(StandardCharsets.UTF_8)));
        });
    }

    public void saveEnvAppVersion(String envCode, String appCode, SchemaEnvAppVersion schemaEnvAppVersion) {
        Optional.ofNullable(schemaEnvAppVersion).ifPresent(o -> this.saveEnvAppVersion(envCode, appCode, JSON.toJSONString((Object)o)));
    }

    public void saveMetadata(Long appId, SchemaMetadataType metadataType, String version, String jsonStr, boolean force) {
        String filePath = AliyunOSSConstant2.getMetadataFilePath(metadataType, appId, version);
        if (!this.isObjectExist(filePath) || force) {
            this.oss.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
        } else {
            log.warn("OSS \u5e94\u7528{}\u914d\u7f6e{}\u7248\u672c{}\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7", new Object[]{appId, metadataType.code(), version});
        }
    }

    public void saveMetadataS(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String fileName, String jsonStr, boolean force) {
        String filePath = AliyunOSSConstant2.getMetadataSFilePath(metadataType, appId, metadataId, version, fileName);
        if (!this.isObjectExist(filePath) || force) {
            log.debug("OSS \u5e94\u7528 {} \u914d\u7f6e {} \u7248\u672c {} \u4e0a\u4f20 {}", new Object[]{appId, metadataType.code(), version, filePath});
            this.oss.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
        } else {
            log.warn("OSS \u5e94\u7528 {} \u914d\u7f6e {} \u7248\u672c {} \u5df2\u5b58\u5728\uff0c\u8df3\u8fc7", new Object[]{appId, metadataType.code(), version});
        }
    }

    public void saveMetadataSItem(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String dirName, Long metadataItemId, String jsonStr) {
        log.debug("OSS \u5e94\u7528 {} \u914d\u7f6e {} \u7248\u672c {} \u76ee\u5f55 {}, \u660e\u7ec6 {} \u4e0a\u4f20", new Object[]{appId, metadataType.code(), version, dirName, metadataItemId});
        String filePath = AliyunOSSConstant2.getMetadataSItemFilePath(metadataType, appId, metadataId, version, dirName, metadataItemId);
        log.debug("\u660e\u7ec6 \u4e0a\u4f20\u8def\u5f84 {}", (Object)filePath);
        this.oss.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
    }

    public void saveTenantMetadataS(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String fileName, String jsonStr) {
        String filePath = AliyunOSSConstant2.getTenantMetadataSFilePath(metadataType, appId, metadataId, version, tenantCode, fileName);
        this.oss.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
    }

    public void saveTenantMetadataSItem(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String dirName, Long metadataItemId, String jsonStr) {
        String filePath = AliyunOSSConstant2.getTenantMetadataSItemFilePath(metadataType, appId, metadataId, version, tenantCode, dirName, metadataItemId);
        this.oss.putObject("xforcecloud", filePath, (InputStream)new ByteArrayInputStream(jsonStr.getBytes(StandardCharsets.UTF_8)));
    }

    public String loadAppVersionStr(Long appId, String version) {
        String filePath = AliyunOSSConstant2.getAppVersionFilePath(appId, version);
        return this.getDataStrFromOSS(filePath);
    }

    public boolean isAppVersionExist(Long appId, String version) {
        String filePath = AliyunOSSConstant2.getAppVersionFilePath(appId, version);
        return this.isObjectExist(filePath);
    }

    public String loadEnvAppVersion(String envCode, String appCode) {
        String filePath = AliyunOSSConstant2.getEnvAppVersionFilePath(envCode, appCode);
        return this.getDataStrFromOSS(filePath);
    }

    public boolean isEnvAppVersionExist(String envCode, String appCode) {
        String filePath = AliyunOSSConstant2.getEnvAppVersionFilePath(envCode, appCode);
        return this.isObjectExist(filePath);
    }

    public String loadMetadataStr(Long appId, SchemaMetadataType metadataType, String version) {
        String filePath = AliyunOSSConstant2.getMetadataFilePath(metadataType, appId, version);
        return this.getDataStrFromOSS(filePath);
    }

    public boolean isMetadataExist(Long appId, SchemaMetadataType metadataType, String version) {
        String filePath = AliyunOSSConstant2.getMetadataFilePath(metadataType, appId, version);
        return this.isObjectExist(filePath);
    }

    public String loadMetadataSStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String fileName) {
        String filePath = AliyunOSSConstant2.getMetadataSFilePath(metadataType, appId, metadataId, version, fileName);
        return this.getDataStrFromOSS(filePath);
    }

    public boolean isMetadataSPathExist(Long appId, SchemaMetadataType metadataType, Long metadataId, String version) {
        String filePath = AliyunOSSConstant2.getMetadataSPath(metadataType, appId, metadataId, version);
        return this.isDirectoryExist(filePath);
    }

    public String loadMetadataSItemStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String dirName, Long metadataItemId) {
        String filePath = AliyunOSSConstant2.getMetadataSItemFilePath(metadataType, appId, metadataId, version, dirName, metadataItemId);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadTenantMetadataSStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String fileName) {
        String filePath = AliyunOSSConstant2.getTenantMetadataSFilePath(metadataType, appId, metadataId, version, tenantCode, fileName);
        return this.getDataStrFromOSS(filePath);
    }

    public String loadTenantMetadataSItemStr(Long appId, SchemaMetadataType metadataType, Long metadataId, String version, String tenantCode, String dirName, Long metadataItemId) {
        String filePath = AliyunOSSConstant2.getTenantMetadataSItemFilePath(metadataType, appId, metadataId, version, tenantCode, dirName, metadataItemId);
        return this.getDataStrFromOSS(filePath);
    }

    private boolean isObjectExist(String filePath) {
        try {
            return this.oss.doesObjectExist("xforcecloud", filePath);
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        catch (Exception e) {
            log.error("could not load tenant metadata", (Throwable)e);
        }
        return false;
    }

    private boolean isDirectoryExist(String filePath) {
        try {
            ObjectListing objectListing = this.oss.listObjects("xforcecloud", filePath);
            return null != objectListing && !objectListing.getObjectSummaries().isEmpty();
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        catch (Exception e) {
            log.error("could not load tenant metadata", (Throwable)e);
        }
        return false;
    }

    private String getDataStrFromOSS(String filePath) {
        try {
            if (!this.oss.doesObjectExist("xforcecloud", filePath)) {
                log.debug("filePath {} not found in oss", (Object)filePath);
                return null;
            }
            OSSObject ossObject = this.oss.getObject("xforcecloud", filePath);
            return IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8");
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        catch (Exception e) {
            log.error("could not load tenant metadata", (Throwable)e);
        }
        return null;
    }

    private Map<String, String> getDataMapFromOSS(String filePathDir) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        try {
            ObjectListing objectListing = this.oss.listObjects("xforcecloud", filePathDir);
            List sums = objectListing.getObjectSummaries();
            for (OSSObjectSummary s : sums) {
                OSSObject ossObject = this.oss.getObject("xforcecloud", s.getKey());
                contentMap.put(AliyunOSSConstant.getFileName(s.getKey()), IOUtils.readStreamAsString((InputStream)ossObject.getObjectContent(), (String)"UTF-8"));
            }
        }
        catch (OSSException oe) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
            log.error("Error Message:" + oe.getErrorMessage());
            log.error("Error Code:" + oe.getErrorCode());
            log.error("Request ID:" + oe.getRequestId());
            log.error("Host ID:" + oe.getHostId());
        }
        catch (ClientException ce) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
            log.error("Error Message:" + ce.getMessage());
        }
        catch (Exception e) {
            log.error("could not load metadata", (Throwable)e);
        }
        return contentMap;
    }

    private boolean doNonProdEnvUploadToNonDevEnv(String envCode) {
        if (!"prod".equals(this.profile) && !"dev".equals(envCode)) {
            log.warn("\u975e\u751f\u4ea7\u73af\u5883\uff0c\u53ea\u80fd\u4e0a\u4f20\u5e94\u7528\u73af\u5883\u7248\u672c\u4fe1\u606f\u5230dev profile {} envCode {}", (Object)this.profile, (Object)envCode);
            return true;
        }
        return false;
    }
}

