/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.base.codegen;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.BoConfig;
import com.xforceplus.ultraman.bocp.gen.config.DictConfig;
import com.xforceplus.ultraman.bocp.gen.config.DtoConfig;
import com.xforceplus.ultraman.bocp.gen.config.ModuleConfig;
import com.xforceplus.ultraman.bocp.gen.config.NameConvert;
import com.xforceplus.ultraman.bocp.gen.config.PfcpConfig;
import com.xforceplus.ultraman.bocp.gen.config.ProjectConfig;
import com.xforceplus.ultraman.bocp.gen.generator.BocpAutoGenerator;
import com.xforceplus.ultraman.bocp.gen.po.BoGenField;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.BoRelInfo;
import com.xforceplus.ultraman.bocp.gen.po.DictGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.DictGenOption;
import com.xforceplus.ultraman.bocp.gen.po.DtoGenField;
import com.xforceplus.ultraman.bocp.gen.po.DtoGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.FormGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.PageGenInfo;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.RelationType;
import com.xforceplus.ultraman.bocp.metadata.constant.BocpConstant;
import com.xforceplus.ultraman.bocp.metadata.service.IBoExService;
import com.xforceplus.ultraman.bocp.metadata.setting.BoFieldSetting;
import com.xforceplus.ultraman.bocp.metadata.system.SystemSettingsHolder;
import com.xforceplus.ultraman.bocp.metadata.util.FieldTypeUtil;
import com.xforceplus.ultraman.bocp.metadata.util.FormatUtil;
import com.xforceplus.ultraman.bocp.metadata.val.JavaData;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldValidate;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Module;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoFieldDomainAttributeMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoRelationshipMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.DictDetailMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.DictMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.ModuleMapper;
import com.xforceplus.ultraman.metadata.generate.util.CodeGenUtil;
import com.xforceplus.ultraman.metadata.global.common.util.AppUtil;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldAttributeRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldDomainAttributeRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldValidateRepository;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CodeGenBase {
    private static final Logger log = LoggerFactory.getLogger(CodeGenBase.class);
    private final Long APP_IMAGE_SAAS_ID = 1295238094955593729L;
    private final Long BO_TICKET_ID = 1295238137703940097L;
    private final Long BO_BACK_LOG_ID = 1295238743231414273L;
    @Autowired
    private BoFieldAttributeRepository boFieldAttributeRepository;
    @Autowired
    private BoFieldDomainAttributeRepository boFieldDomainAttributeRepository;
    @Autowired
    private BoFieldValidateRepository boFieldValidateRepository;
    @Autowired
    private BoMapper boMapper;
    @Autowired
    private ModuleMapper moduleMapper;
    @Autowired
    private BoRelationshipMapper boRelationshipMapper;
    @Autowired
    private BoFieldDomainAttributeMapper boFieldDomainAttributeMapper;
    @Autowired
    private DictMapper dictMapper;
    @Autowired
    private DictDetailMapper dictDetailMapper;
    @Autowired
    private SystemSettingsHolder systemSettingsHolder;
    @Autowired
    private IBoExService boExService;
    @Autowired
    private BoFieldRepository boFieldRepository;
    protected ExecutorService threadPool;

    @PostConstruct
    protected void init() {
        this.threadPool = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    protected void destroy() throws InterruptedException {
        if (!this.threadPool.isShutdown()) {
            this.threadPool.shutdown();
            this.threadPool.awaitTermination(30000L, TimeUnit.MILLISECONDS);
        }
    }

    protected List<BoGenField> buildSystemFields(List<BoField> boFields, String boType) {
        ArrayList boGenFields = Lists.newArrayList();
        if (BoType.ENTITY.code().equals(boType)) {
            List systemFields = this.systemSettingsHolder.getSystemFields();
            for (BoFieldVo vo : systemFields) {
                long count = boFields.stream().filter(boField -> vo.getCode().equals(boField.getCode())).count();
                if (count != 0L) continue;
                BoGenField systemField = new BoGenField();
                systemField.setName(vo.getCode());
                systemField.setAlias(vo.getCode());
                systemField.setFieldType(vo.getType());
                systemField.setRemark(vo.getName());
                systemField.setSystem(true);
                systemField.setLength(vo.getMaxLength() == null ? null : Integer.valueOf(vo.getMaxLength()));
                if ("id".equals(vo.getCode())) {
                    systemField.setFieldKey("1");
                    systemField.setNullKey("1");
                } else {
                    systemField.setFieldKey(null);
                    systemField.setNullKey(null);
                }
                systemField.setCode(FormatUtil.toLowerCamel((String)vo.getCode()));
                boGenFields.add(systemField);
            }
        }
        return boGenFields;
    }

    protected GlobalConfig getGlobalConfig() {
        GlobalConfig gc = new GlobalConfig();
        gc.setAuthor("ultraman");
        gc.setBaseResultMap(true);
        gc.setOpen(false);
        gc.setOutputDir(CodeGenUtil.getOutputDir());
        return gc;
    }

    protected DataSourceConfig getDataSourceConfig() {
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setDbType(DbType.MYSQL);
        return dsc;
    }

    protected ProjectConfig getProjectConfig() {
        ProjectConfig prjc = new ProjectConfig();
        prjc.setName("ultraman");
        prjc.setCode("ultraman");
        prjc.setRemark("ultraman");
        prjc.setGroupInfo("com.xforceplus");
        prjc.setVersion("0.0.1");
        return prjc;
    }

    protected ApplicationConfig getApplicationConfig(App app) {
        ApplicationConfig appc = new ApplicationConfig();
        appc.setCode(AppUtil.getLowerHyphenAppCode((String)app.getCode()));
        appc.setName(app.getCode());
        appc.setRemark(app.getRemark());
        appc.setVersion(app.getVersion());
        appc.setUrl(app.getUrl());
        return appc;
    }

    protected ModuleConfig getModuleConfig(App app, Long moduleId) {
        Module moduleInfo = (Module)this.moduleMapper.selectById((Serializable)moduleId);
        ModuleConfig mdc = new ModuleConfig();
        mdc.setName(AppUtil.getLowerHyphenAppCode((String)app.getCode()));
        mdc.setCode(mdc.getName());
        mdc.setVersion(moduleInfo.getVersion());
        return mdc;
    }

    protected StrategyConfig getStrategyConfig(String moduleName) {
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(new String[]{moduleName + "_"});
        strategy.setNameConvert((INameConvert)new NameConvert());
        return strategy;
    }

    protected DtoGenField convertClassType(DtoGenField dtoGenField, BoFieldVo boFieldVo, Set<String> importPackages, String dictPackagePath) {
        if (!FieldType.ENUM.code().equals(dtoGenField.getType())) {
            if ("double".equals(dtoGenField.getType())) {
                importPackages.add(BigDecimal.class.getCanonicalName());
            } else if ("timestamp".equals(dtoGenField.getType())) {
                importPackages.add(LocalDateTime.class.getCanonicalName());
            }
        }
        dtoGenField.setType(FieldTypeUtil.getFieldClassType((String)dtoGenField.getType()));
        return dtoGenField;
    }

    protected void buildBoRelationshipToBo(List<BoGenInfo> boGenInfos, List<Bo> bos, Map<Long, List<BoField>> boFieldsMap, boolean includeTenant, List<Bo> allBos, Long appId) {
        List<String> relTypes = Arrays.asList(RelationType.OTO.code(), RelationType.OTM.code(), RelationType.MTO.code());
        Map boMap = bos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        Map<Long, List<BoRelationship>> boRelsMap = this.boRelationshipMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoRelationship::getBoId, boMap.keySet())).in(BoRelationship::getRelationType, relTypes)).eq(BoRelationship::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoRelationship::getBoId));
        if (includeTenant) {
            boRelsMap.keySet().forEach(boId -> allBos.stream().filter(o -> boId.equals(o.getRefBoId()) && !BocpConstant.NOT_ENTITY_TYPE_LIST.contains((Object)o.getBoType())).forEach(o -> ((List)boRelsMap.get(boId)).addAll(this.boRelationshipMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoRelationship::getBoId, (Object)o.getId())).in(BoRelationship::getRelationType, (Collection)relTypes)).eq(BoRelationship::getDeleteFlag, (Object)"1")))));
        }
        boGenInfos.forEach(boGenInfo -> {
            Bo bo = bos.stream().filter(b -> b.getId().equals(boGenInfo.getId())).findFirst().orElse(null);
            if (bo != null && this.APP_IMAGE_SAAS_ID.equals(appId) && (this.BO_TICKET_ID.equals(bo.getPublishBoId()) || this.BO_BACK_LOG_ID.equals(bo.getPublishBoId()))) {
                if (boRelsMap.containsKey(boGenInfo.getId())) {
                    List boRelLists = this.getBoRelInfoForEntity(boGenInfo.getId(), boMap, boFieldsMap, (List)boRelsMap.get(boGenInfo.getId())).stream().filter(r -> !"area".equals(r.getRelCode())).collect(Collectors.toList());
                    boGenInfo.setBoRelLists(boRelLists);
                } else {
                    boGenInfo.setBoRelLists((List)Lists.newArrayList());
                }
            } else if (boRelsMap.containsKey(boGenInfo.getId())) {
                List<BoRelInfo> boRelLists = this.getBoRelInfoForEntity(boGenInfo.getId(), boMap, boFieldsMap, (List)boRelsMap.get(boGenInfo.getId()));
                boGenInfo.setBoRelLists(boRelLists);
                List relFieldCodes = boRelLists.stream().map(r -> r.getRelCode() + "Id").collect(Collectors.toList());
                boGenInfo.setBoGenFieldList(boGenInfo.getBoGenFieldList().stream().filter(f -> !StringUtils.isNotEmpty((CharSequence)f.getCode()) || !relFieldCodes.contains(f.getCode())).collect(Collectors.toList()));
            } else {
                boGenInfo.setBoRelLists((List)Lists.newArrayList());
            }
        });
    }

    protected List<BoRelInfo> getBoRelInfoForEntity(Long boId, Map<Long, Bo> boMap, Map<Long, List<BoField>> boFieldsMap, List<BoRelationship> boRels) {
        List<BoRelInfo> boRefsForNotNull = boRels.stream().filter(relation -> relation.getBoField() != null && relation.getJoinField() != null).map(relation -> {
            Bo joinBo = (Bo)boMap.get(relation.getJoinBoId());
            Optional<BoField> boFieldOpt = ((List)boFieldsMap.get(boId)).stream().filter(field -> field.getPublishFieldId().equals(relation.getBoField())).findAny();
            Optional joinFieldOpt = Optional.ofNullable(boFieldsMap.get(joinBo.getId())).flatMap(fields -> fields.stream().filter(field -> field.getPublishFieldId().equals(relation.getJoinField())).findAny());
            BoRelInfo boRelInfo = null;
            if (boFieldOpt.isPresent() && joinFieldOpt.isPresent()) {
                boRelInfo = new BoRelInfo();
                boRelInfo.setCode(joinBo == null ? "null" : FormatUtil.lowerUnderscoreToLowerCamel((String)joinBo.getCode()));
                boRelInfo.setHCode(StringUtils.capitalize((String)boRelInfo.getCode()));
                boRelInfo.setRelCode(FormatUtil.lowerUnderscoreToLowerCamel((String)relation.getRelationCode()));
                boRelInfo.setRelHCode(StringUtils.capitalize((String)boRelInfo.getRelCode()));
                boRelInfo.setRelType(RelationType.fromType((String)relation.getRelationType()).name());
                boRelInfo.setRelFieldTypes(new String[]{FieldTypeUtil.getFieldClassType((String)boFieldOpt.get().getFieldType()), FieldTypeUtil.getFieldClassType((String)((BoField)joinFieldOpt.get()).getFieldType())});
                boRelInfo.setRelFieldCodes(new String[]{FormatUtil.lowerUnderscoreToLowerCamel((String)boFieldOpt.get().getCode()), FormatUtil.lowerUnderscoreToLowerCamel((String)((BoField)joinFieldOpt.get()).getCode())});
                boRelInfo.setRelHFieldCodes(new String[]{StringUtils.capitalize((String)boRelInfo.getRelFieldCodes()[0]), StringUtils.capitalize((String)boRelInfo.getRelFieldCodes()[1])});
            }
            return boRelInfo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List boRefsForNull = boRels.stream().filter(relation -> relation.getBoField() == null || relation.getJoinField() == null).map(relation -> {
            Bo joinBo = (Bo)boMap.get(relation.getJoinBoId());
            BoRelInfo boRelInfo = new BoRelInfo();
            boRelInfo.setCode(joinBo == null ? "null" : FormatUtil.lowerUnderscoreToLowerCamel((String)joinBo.getCode()));
            boRelInfo.setHCode(StringUtils.capitalize((String)boRelInfo.getCode()));
            boRelInfo.setRelCode(FormatUtil.lowerUnderscoreToLowerCamel((String)relation.getRelationCode()));
            boRelInfo.setRelHCode(StringUtils.capitalize((String)boRelInfo.getRelCode()));
            boRelInfo.setRelType(RelationType.fromType((String)relation.getRelationType()).name());
            boRelInfo.setRelFieldTypes(new String[]{Long.class.getSimpleName(), Long.class.getSimpleName()});
            boRelInfo.setRelFieldCodes(new String[]{"id", "id"});
            boRelInfo.setRelHFieldCodes(new String[]{"Id", "Id"});
            return boRelInfo;
        }).collect(Collectors.toList());
        boRefsForNotNull.addAll(boRefsForNull);
        return boRefsForNotNull;
    }

    protected void buildDtoRelationship(List<DtoGenInfo> dtoGenInfos, String packagePath) {
        dtoGenInfos.forEach(dtoGenInfo -> this.boRelationshipMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoRelationship::getBoId, (Object)dtoGenInfo.getId())).eq(BoRelationship::getDeleteFlag, (Object)"1")).forEach(relation -> {
            Bo bo = (Bo)this.boMapper.selectById((Serializable)relation.getJoinBoId());
            if (bo != null && (RelationType.OTO.code().equals(relation.getRelationType()) || RelationType.OTM.code().equals(relation.getRelationType()))) {
                DtoGenField dtoGenField = new DtoGenField();
                dtoGenField.setName(relation.getRelationName());
                dtoGenField.setCode(relation.getRelationCode());
                dtoGenField.setCapitalCode(StringUtils.capitalize((String)relation.getRelationCode()));
                dtoGenField.setType(StringUtils.capitalize((String)bo.getCode()));
                dtoGenField.setRequired(false);
                if (RelationType.OTO.code().equals(relation.getRelationType())) {
                    dtoGenField.setArray(false);
                } else if (RelationType.OTM.code().equals(relation.getRelationType())) {
                    dtoGenField.setArray(true);
                    dtoGenInfo.getImportPackages().add(List.class.getCanonicalName());
                }
                dtoGenInfo.getDtoGenFields().add(dtoGenField);
                String entityPackagePath = packagePath + bo.getBoType() + ".";
                dtoGenInfo.getImportPackages().add(entityPackagePath + StringUtils.capitalize((String)bo.getCode()));
            }
        }));
    }

    protected static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    protected BocpAutoGenerator appConfigInit(App app, String version, String packagePrefix) {
        BocpAutoGenerator mpg = new BocpAutoGenerator();
        log.debug("initAppConfig appId {}", (Object)app.getId());
        String packageResult = String.format("%s.%s", packagePrefix, AppUtil.getLowerCamelAppCode((String)app.getCode())).toLowerCase();
        mpg.setGlobalConfig(this.getGlobalConfig());
        mpg.setDataSource(this.getDataSourceConfig());
        PackageConfig pc = new PackageConfig();
        pc.setParent(packageResult);
        mpg.setPackageInfo(pc);
        ProjectConfig projectConfig = this.getProjectConfig();
        projectConfig.setGroupInfo(packagePrefix);
        mpg.setProjectConfig(projectConfig);
        mpg.setApplicationConfig(this.getApplicationConfig(app));
        mpg.getApplicationConfig().setVersion(version);
        mpg.setStrategy(this.getStrategyConfig(pc.getModuleName()));
        return mpg;
    }

    protected BocpAutoGenerator moduleGen(App app, Long moduleId, BocpAutoGenerator mpg) {
        ModuleConfig moduleConfig = this.getModuleConfig(app, moduleId);
        moduleConfig.setVersion(mpg.getApplicationConfig().getVersion());
        mpg.setModuleConfig(moduleConfig);
        mpg.setEngineType("mo");
        mpg.execute();
        return mpg;
    }

    protected boolean dtoGen(List<Bo> bos, String packagePath, BocpAutoGenerator mpg) {
        List<DtoGenInfo> dtoGenInfos = bos.stream().filter(bo -> BoType.DTO.code().equals(bo.getBoType()) && null == bo.getRefBoId()).map(bo -> {
            DtoGenInfo dtoGenInfo = new DtoGenInfo();
            dtoGenInfo.setId(bo.getId());
            dtoGenInfo.setName(FormatUtil.textEscape((String)bo.getName()));
            dtoGenInfo.setCode(bo.getCode());
            dtoGenInfo.setDtoGenFields(this.boExService.getFieldVos(bo.getId()).stream().map(boFieldVo -> {
                String fieldCode = FormatUtil.lowerUnderscoreToLowerCamel((String)boFieldVo.getCode());
                DtoGenField dtoGenField = new DtoGenField();
                dtoGenField.setName(FormatUtil.textEscape((String)boFieldVo.getName()));
                dtoGenField.setCode(fieldCode);
                dtoGenField.setCapitalCode(StringUtils.capitalize((String)fieldCode));
                dtoGenField.setType(boFieldVo.getType());
                dtoGenField.setRequired(boFieldVo.getRequired().booleanValue());
                dtoGenField.setArray(Boolean.TRUE.equals(boFieldVo.getIsArray()));
                if (dtoGenField.isArray()) {
                    dtoGenInfo.getImportPackages().add(List.class.getCanonicalName());
                }
                return this.convertClassType(dtoGenField, (BoFieldVo)boFieldVo, dtoGenInfo.getImportPackages(), packagePath + "dict.");
            }).collect(Collectors.toList()));
            return dtoGenInfo;
        }).collect(Collectors.toList());
        this.buildDtoRelationship(dtoGenInfos, packagePath);
        DtoConfig dtoConfig = new DtoConfig();
        dtoConfig.setDtoGenInfos(dtoGenInfos);
        mpg.setDtoConfig(dtoConfig);
        mpg.setEngineType("dto");
        mpg.execute();
        return true;
    }

    protected boolean dictGen(List<Dict> dicts, BocpAutoGenerator mpg) {
        dicts = dicts.stream().filter(o -> StringUtils.isEmpty((CharSequence)o.getTenantCode())).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList());
        ArrayList dictGenInfos = Lists.newArrayList();
        for (Dict dict : dicts) {
            DictGenInfo dictGenInfo = new DictGenInfo();
            dictGenInfo.setName(FormatUtil.textEscape((String)dict.getName()));
            dictGenInfo.setCode(FormatUtil.toUpperCamel((String)dict.getCode()));
            List dictDetails = this.dictDetailMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DictDetail::getDictId, (Object)dict.getId())).eq(DictDetail::getDeleteFlag, (Object)"1")).stream().filter(detail -> !StringUtils.isEmpty((CharSequence)detail.getCode())).map(detail -> {
                DictGenOption option = new DictGenOption();
                option.setValue(detail.getCode());
                option.setName(FormatUtil.textEscape((String)detail.getName()));
                option.setCode(FormatUtil.convertToUpperUnderscore((String)detail.getCode()));
                return option;
            }).collect(Collectors.toList());
            if (dictDetails.size() <= 0) continue;
            dictGenInfo.setOptions(dictDetails);
            dictGenInfos.add(dictGenInfo);
        }
        DictConfig dictConfig = new DictConfig();
        dictConfig.setDictGenInfos((List)dictGenInfos);
        mpg.setDictConfig(dictConfig);
        mpg.setEngineType("dict");
        mpg.execute();
        return true;
    }

    protected void pfcpGen(List<UltPage> pages, List<UltForm> forms, BocpAutoGenerator mpg) {
        pages = pages.stream().filter(o -> null == o.getRefPageId() || o.getRefPageId() == 0L).collect(Collectors.toList());
        forms = forms.stream().filter(o -> null == o.getRefFormId() || o.getRefFormId() == 0L).collect(Collectors.toList());
        List pageGenInfos = pages.stream().map(o -> {
            PageGenInfo pageGenInfo = new PageGenInfo();
            pageGenInfo.setCode(FormatUtil.toLowerCamel((String)o.getCode()));
            pageGenInfo.setName(FormatUtil.toLowerCamel((String)o.getName()));
            pageGenInfo.setHCode(StringUtils.capitalize((String)pageGenInfo.getCode()));
            return pageGenInfo;
        }).collect(Collectors.toList());
        List formGenInfos = forms.stream().map(o -> {
            FormGenInfo formGenInfo = new FormGenInfo();
            formGenInfo.setCode(FormatUtil.toLowerCamel((String)o.getCode()));
            formGenInfo.setName(FormatUtil.toLowerCamel((String)o.getName()));
            formGenInfo.setHCode(StringUtils.capitalize((String)formGenInfo.getCode()));
            return formGenInfo;
        }).collect(Collectors.toList());
        PfcpConfig pfcpConfig = new PfcpConfig();
        pfcpConfig.setPageGenInfos(pageGenInfos);
        pfcpConfig.setFormGenInfos(formGenInfos);
        mpg.setPfcpConfig(pfcpConfig);
        mpg.setEngineType("pfcp");
        mpg.execute();
    }

    protected boolean boGen(Long appId, List<Bo> bos, BocpAutoGenerator mpg) {
        if ((bos = bos.stream().filter(o -> !BocpConstant.NOT_ENTITY_TYPE_LIST.contains((Object)o.getBoType()) && null == o.getRefBoId()).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList())).isEmpty()) {
            return true;
        }
        Map boMap = bos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        List boIds = bos.stream().map(Bo::getId).collect(Collectors.toList());
        Map<Long, List<BoField>> boFieldsMap = this.boFieldRepository.getBoFieldsByBoIds(boIds).stream().collect(Collectors.groupingBy(BoField::getBoId));
        BoConfig boConfig = new BoConfig();
        ArrayList boGenInfos = Lists.newArrayList();
        for (Bo bo : bos) {
            BoGenInfo boGenInfo2 = new BoGenInfo();
            boGenInfo2.setName(FormatUtil.textEscape((String)bo.getName()));
            boGenInfo2.setCode(bo.getCode());
            boGenInfo2.setRemark(bo.getRemark());
            boGenInfo2.setBoType(bo.getBoType());
            boGenInfo2.setId(bo.getId());
            if (bo.getParentBoId() != null) {
                Optional.ofNullable(boMap.get(bo.getParentBoId())).ifPresent(parentBo -> boGenInfo2.setParentEntity(StringUtils.capitalize((String)parentBo.getCode())));
            }
            List<BoField> boFields = Optional.ofNullable(boFieldsMap.get(bo.getId())).orElse(Lists.newArrayList());
            List<BoGenField> boGenFields = boFields.stream().map(field -> {
                BoGenField boGenField = new BoGenField();
                boGenField.setName(field.getCode());
                boGenField.setRemark(field.getName());
                boGenField.setFieldKey(field.getFieldKey());
                boGenField.setFieldType(field.getFieldType());
                boGenField.setNullKey(field.getNiKey());
                boGenField.setCode(FormatUtil.toLowerCamel((String)field.getCode()));
                return boGenField;
            }).collect(Collectors.toList());
            boGenFields.addAll(this.buildSystemFields(boFields, bo.getBoType()));
            boGenFields.forEach(boGenField -> boGenField.setFieldType(FieldTypeUtil.convertToColumnType((String)boGenField.getFieldType())));
            boGenFields = boGenFields.stream().filter(CodeGenBase.distinctByKey(f -> FormatUtil.lowerCamelToLowerUnderscore((String)f.getName()))).collect(Collectors.toList());
            boGenFields = boGenFields.stream().filter(CodeGenBase.distinctByKey(f -> StringUtils.lowerCase((String)FormatUtil.lowerUnderscoreToLowerCamel((String)f.getName())))).collect(Collectors.toList());
            boGenFields = boGenFields.stream().filter(f -> !JavaData.Keywords.contains(f.getName())).collect(Collectors.toList());
            boGenInfo2.setBoGenFieldList(boGenFields);
            if (BoType.BASE.code().equals(bo.getBoType())) {
                StrategyConfig strategyConfig = mpg.getStrategy();
                PackageConfig packageConfig = mpg.getPackageInfo();
                strategyConfig.setSuperEntityClass(packageConfig.getParent() + "." + packageConfig.getEntity() + "." + StringUtils.capitalize((String)bo.getCode()));
                strategyConfig.setSuperEntityColumns(boFields.stream().map(BoField::getCode).collect(Collectors.toList()).toArray(new String[0]));
                mpg.setStrategy(strategyConfig);
                boConfig.setBaseEntity(boGenInfo2);
                continue;
            }
            boGenInfos.add(boGenInfo2);
        }
        this.buildBoRelationshipToBo(boGenInfos, bos, boFieldsMap, false, null, appId);
        Map<Long, Long> idMaps = bos.stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        boGenInfos.forEach(boGenInfo -> boGenInfo.setId((Long)idMaps.get(boGenInfo.getId())));
        boConfig.setBoGenInfoList((List)boGenInfos);
        boConfig.setFromDB(Boolean.valueOf(false));
        mpg.setBoConfig(boConfig);
        mpg.setEngineType("bo");
        mpg.execute();
        return true;
    }

    protected void boGen2(List<Bo> allBos, BocpAutoGenerator mpg) {
        List<Bo> bos = (allBos = allBos.stream().filter(o -> !BocpConstant.NOT_ENTITY_TYPE_LIST.contains((Object)o.getBoType())).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList())).stream().filter(bo -> bo.getRefBoId() == null).collect(Collectors.toList());
        if (bos.isEmpty()) {
            return;
        }
        List allBoIds = allBos.stream().map(Bo::getId).collect(Collectors.toList());
        Map boMap = bos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        Map<Long, List<BoField>> boFieldsMap = this.boFieldRepository.getBoFieldsByBoIds(allBoIds).stream().collect(Collectors.groupingBy(BoField::getBoId));
        Map<Long, String> advancedFieldValueTypeMap = this.getAdvancedFieldValueTypeMap(boFieldsMap);
        BoConfig boConfig = new BoConfig();
        ArrayList boGenInfos = Lists.newArrayList();
        for (Bo bo2 : bos) {
            BoGenInfo boGenInfo2 = new BoGenInfo();
            boGenInfo2.setName(FormatUtil.textEscape((String)bo2.getName()));
            boGenInfo2.setCode(bo2.getCode());
            boGenInfo2.setRemark(bo2.getRemark());
            boGenInfo2.setBoType(bo2.getBoType());
            boGenInfo2.setId(bo2.getId());
            if (bo2.getParentBoId() != null) {
                Optional.ofNullable(boMap.get(bo2.getParentBoId())).ifPresent(parentBo -> boGenInfo2.setParentEntity(StringUtils.capitalize((String)parentBo.getCode())));
            }
            List<BoField> boFields = Optional.ofNullable(boFieldsMap.get(bo2.getId())).orElse(Lists.newArrayList());
            List<Object> boGenFields = Lists.newArrayList();
            boGenFields.addAll(boFields.stream().map(field -> {
                BoGenField boGenField = new BoGenField();
                boGenField.setName(field.getCode());
                boGenField.setRemark(field.getName());
                boGenField.setFieldKey(field.getFieldKey());
                boGenField.setNullKey(field.getNiKey());
                boGenField.setFieldType(field.getFieldType());
                if (advancedFieldValueTypeMap.containsKey(field.getId())) {
                    boGenField.setFieldType((String)advancedFieldValueTypeMap.get(field.getId()));
                }
                boGenField.setCode(FormatUtil.toLowerCamel((String)field.getCode()));
                return boGenField;
            }).collect(Collectors.toList()));
            boGenFields.addAll(allBos.stream().filter(tBo -> bo2.getId().equals(tBo.getRefBoId())).map(tBo -> {
                List tBoFields = Optional.ofNullable(boFieldsMap.get(tBo.getId())).orElse(Lists.newArrayList());
                return tBoFields.stream().map(tBoField -> {
                    BoGenField boGenField = new BoGenField();
                    boGenField.setName(tBoField.getCode());
                    boGenField.setRemark(tBoField.getName());
                    boGenField.setFieldKey(tBoField.getFieldKey());
                    boGenField.setFieldType(tBoField.getFieldType());
                    boGenField.setNullKey(tBoField.getNiKey());
                    boGenField.setCode(FormatUtil.toLowerCamel((String)tBoField.getCode()));
                    return boGenField;
                }).collect(Collectors.toList());
            }).flatMap(Collection::stream).collect(Collectors.toList()));
            boGenFields.addAll(this.buildSystemFields(boFields, bo2.getBoType()));
            boGenFields.forEach(boGenField -> boGenField.setFieldType(FieldTypeUtil.convertToColumnType((String)boGenField.getFieldType())));
            boGenFields = boGenFields.stream().filter(CodeGenBase.distinctByKey(f -> FormatUtil.lowerCamelToLowerUnderscore((String)f.getName()))).collect(Collectors.toList());
            boGenFields = boGenFields.stream().filter(CodeGenBase.distinctByKey(f -> StringUtils.lowerCase((String)FormatUtil.lowerUnderscoreToLowerCamel((String)f.getName())))).collect(Collectors.toList());
            boGenFields = boGenFields.stream().filter(f -> !JavaData.Keywords.contains(f.getName())).collect(Collectors.toList());
            boGenInfo2.setBoGenFieldList((List)boGenFields);
            if (BoType.BASE.code().equals(bo2.getBoType())) {
                boConfig.setBaseEntity(boGenInfo2);
                continue;
            }
            boGenInfos.add(boGenInfo2);
        }
        this.buildBoRelationshipToBo(boGenInfos, bos, boFieldsMap, true, allBos, null);
        Map<Long, Long> idMaps = bos.stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        boGenInfos.forEach(boGenInfo -> boGenInfo.setId((Long)idMaps.get(boGenInfo.getId())));
        boConfig.setBoGenInfoList((List)boGenInfos);
        boConfig.setFromDB(Boolean.valueOf(false));
        mpg.setBoConfig(boConfig);
        mpg.setEngineType("bo");
        mpg.execute();
    }

    protected BoConfig boConfigGen3(List<Bo> bos) {
        if ((bos = bos.stream().filter(o -> !BocpConstant.NOT_ENTITY_TYPE_LIST.contains((Object)o.getBoType())).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList())).isEmpty()) {
            return null;
        }
        List boIds = bos.stream().map(Bo::getId).collect(Collectors.toList());
        Map boMap = bos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        Map<Long, List<BoField>> boFieldsMap = this.boFieldRepository.getBoFieldsByBoIds(boIds).stream().collect(Collectors.groupingBy(BoField::getBoId));
        Map<Long, String> advancedFieldValueTypeMap = this.getAdvancedFieldValueTypeMap(boFieldsMap);
        BoConfig boConfig = new BoConfig();
        ArrayList boGenInfos = Lists.newArrayList();
        for (Bo bo : bos) {
            BoGenInfo boGenInfo2 = new BoGenInfo();
            boGenInfo2.setName(FormatUtil.textEscape((String)bo.getName()));
            boGenInfo2.setCode(bo.getCode());
            boGenInfo2.setRemark(bo.getRemark());
            boGenInfo2.setBoType(bo.getBoType());
            boGenInfo2.setId(bo.getId());
            boGenInfo2.setTenantBo(bo.getRefBoId() != null);
            if (bo.getParentBoId() != null) {
                Optional.ofNullable(boMap.get(bo.getParentBoId())).ifPresent(parentBo -> boGenInfo2.setParentEntity(StringUtils.capitalize((String)parentBo.getCode())));
            }
            List<BoField> boFields = Optional.ofNullable(boFieldsMap.get(bo.getId())).orElse(Lists.newArrayList());
            List boFieldIds = boFields.stream().map(BoField::getId).collect(Collectors.toList());
            Map boFieldAttributeMap = this.boFieldAttributeRepository.getBoFieldAttributesByFieldIds(boFieldIds).stream().collect(Collectors.toMap(BoFieldAttribute::getFieldId, Function.identity()));
            Map boFieldDomainAttributeMap = this.boFieldDomainAttributeRepository.getBoFieldDomainAttributesByFieldIds(boFieldIds).stream().collect(Collectors.toMap(BoFieldDomainAttribute::getFieldId, Function.identity()));
            Map boFieldValidateMap = this.boFieldValidateRepository.getBoFieldValidatesByFieldIds(boFieldIds).stream().collect(Collectors.toMap(BoFieldValidate::getFieldId, Function.identity()));
            List<Object> boGenFields = Lists.newArrayList();
            boGenFields.addAll(boFields.stream().map(field -> {
                Dict dict;
                BoFieldValidate validate;
                BoGenField boGenField = new BoGenField();
                boGenField.setName(field.getCode());
                boGenField.setRemark(field.getName());
                boGenField.setFieldKey(field.getFieldKey());
                boGenField.setNullKey(field.getNiKey());
                boGenField.setFieldType(field.getFieldType());
                if (advancedFieldValueTypeMap.containsKey(field.getId())) {
                    boGenField.setFieldType((String)advancedFieldValueTypeMap.get(field.getId()));
                }
                boGenField.setCode(FormatUtil.toLowerCamel((String)field.getCode()));
                boGenField.setMetaFieldType(field.getFieldType());
                if (boFieldAttributeMap.containsKey(field.getId())) {
                    BoFieldAttribute attr = (BoFieldAttribute)boFieldAttributeMap.get(field.getId());
                    boGenField.setRequired(!"id".equals(field.getCode()) ? "0".equals(attr.getCanNil()) : false);
                    boGenField.setLength(null == attr.getLength() ? attr.getMaxSize() : attr.getLength());
                    boGenField.setDecimalPoint(attr.getDecimalPoint());
                }
                if (boFieldDomainAttributeMap.containsKey(field.getId())) {
                    HashMap domainConfig;
                    BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)boFieldDomainAttributeMap.get(field.getId());
                    boGenField.setMetaValueType(domainAttribute.getValueType());
                    Map map = domainConfig = StringUtils.isEmpty((CharSequence)domainAttribute.getDomainConfig()) ? Maps.newHashMap() : (Map)JSON.parseObject((String)domainAttribute.getDomainConfig(), Map.class);
                    if (FieldType.EMAIL.code().equals(field.getFieldType())) {
                        boGenField.setDomainConfigType(String.valueOf(domainConfig.get("emailType")));
                        boGenField.setEmailSuffixes(null == domainConfig.get("emailSuffix") ? null : ((JSONArray)domainConfig.get("emailSuffix")).toJavaList(String.class, new JSONReader.Feature[0]).stream().collect(Collectors.joining(",")));
                    } else if (FieldType.PHONE.code().equals(field.getFieldType())) {
                        boGenField.setDomainConfigType(String.valueOf(domainConfig.get("phoneType")));
                    } else if (Arrays.asList(FieldType.AMOUNT.code(), FieldType.PERCENTAGE.code()).contains(field.getFieldType())) {
                        boGenField.setMaxSize(null == domainConfig.get("max") ? null : Integer.valueOf(String.valueOf(domainConfig.get("max"))));
                        boGenField.setMinSize(null == domainConfig.get("min") ? null : Integer.valueOf(Integer.parseInt(String.valueOf(domainConfig.get("min")))));
                    }
                }
                if (boFieldValidateMap.containsKey(field.getId()) && StringUtils.isNotEmpty((CharSequence)(validate = (BoFieldValidate)boFieldValidateMap.get(field.getId())).getValidateRule())) {
                    boGenField.setRegex(validate.getValidateRule());
                }
                if (Arrays.asList(FieldType.ENUM.code(), FieldType.ENUMS.code()).contains(field.getFieldType()) && null != field.getDictId() && null != (dict = (Dict)this.dictMapper.selectById((Serializable)field.getDictId()))) {
                    boGenField.setEnum(true);
                    boGenField.setEnumClass(FormatUtil.toUpperCamel((String)dict.getCode()));
                }
                return boGenField;
            }).collect(Collectors.toList()));
            if (boGenInfo2.isTenantBo()) {
                boGenInfo2.setName(bo.getCode() + "-tenant-" + bo.getTenantCode() + "-" + bo.getTenantName());
                boGenInfo2.setRemark(bo.getCode() + "-tenant-" + bo.getTenantCode() + "-" + bo.getTenantName());
            } else {
                boGenFields.addAll(this.buildSystemFields(boFields, bo.getBoType()).stream().map(field -> {
                    field.setCode(FormatUtil.toLowerCamel((String)field.getName()));
                    field.setMetaFieldType(field.getFieldType());
                    return field;
                }).collect(Collectors.toList()));
            }
            boGenFields.forEach(boGenField -> boGenField.setFieldType(FieldTypeUtil.convertToColumnType((String)boGenField.getFieldType())));
            boGenFields = boGenFields.stream().filter(CodeGenBase.distinctByKey(f -> FormatUtil.lowerCamelToLowerUnderscore((String)f.getName()))).collect(Collectors.toList());
            boGenFields = boGenFields.stream().filter(CodeGenBase.distinctByKey(f -> StringUtils.lowerCase((String)FormatUtil.lowerUnderscoreToLowerCamel((String)f.getName())))).collect(Collectors.toList());
            boGenFields = boGenFields.stream().filter(f -> !JavaData.Keywords.contains(f.getName())).collect(Collectors.toList());
            boGenInfo2.setBoGenFieldList((List)boGenFields);
            if (BoType.BASE.code().equals(bo.getBoType())) {
                boConfig.setBaseEntity(boGenInfo2);
                continue;
            }
            boGenInfos.add(boGenInfo2);
        }
        this.buildBoRelationshipToBo(boGenInfos, bos, boFieldsMap, false, null, null);
        Map<Long, Long> idMaps = bos.stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        boGenInfos.forEach(boGenInfo -> boGenInfo.setId((Long)idMaps.get(boGenInfo.getId())));
        boConfig.setBoGenInfoList((List)boGenInfos);
        boConfig.setFromDB(Boolean.valueOf(false));
        return boConfig;
    }

    protected Map<Long, String> getAdvancedFieldValueTypeMap(Map<Long, List<BoField>> boFieldsMap) {
        List advancedFieldIds = boFieldsMap.values().stream().flatMap(Collection::stream).filter(field -> BoFieldSetting.computeFieldTypeCodes.contains(field.getFieldType())).map(BoField::getId).collect(Collectors.toList());
        return advancedFieldIds.isEmpty() ? Maps.newHashMap() : this.boFieldDomainAttributeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoFieldDomainAttribute::getFieldId, advancedFieldIds)).eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1")).stream().collect(Collectors.toMap(BoFieldDomainAttribute::getFieldId, BoFieldDomainAttribute::getValueType));
    }
}

