/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.base.codegen;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.config.BoConfig;
import com.xforceplus.ultraman.bocp.gen.generator.BocpAutoGenerator;
import com.xforceplus.ultraman.bocp.gen.generator.ForSdkGenerator;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.version.query.FormVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.PageVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.ModuleBo;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.DictMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.ModuleBoMapper;
import com.xforceplus.ultraman.metadata.generate.base.codegen.CodeGenBase;
import com.xforceplus.ultraman.metadata.generate.maven.MavenInvokerManager;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CodeGenBaseExecutor
extends CodeGenBase {
    private static final Logger log = LoggerFactory.getLogger(CodeGenBaseExecutor.class);
    @Autowired
    private BoMapper boMapper;
    @Autowired
    private ModuleBoMapper moduleBoMapper;
    @Autowired
    private DictMapper dictMapper;
    @Autowired
    private MavenInvokerManager mavenInvokerManager;
    @Autowired
    private PageVersionQuery pageVersionQuery;
    @Autowired
    private FormVersionQuery formVersionQuery;

    public void doGen1(App app, Long moduleId, String appVersion, String dictVersion) {
        try {
            log.debug("module {} exec codegen and maven deploy", (Object)moduleId);
            BocpAutoGenerator mpg = this.appConfigInit(app, appVersion, "com.xforceplus");
            this.moduleGen(app, moduleId, mpg);
            mpg.setBocpConfig(null);
            this.boGen(app.getId(), moduleId, mpg);
            mpg.setBocpConfig(null);
            this.dtoGen(moduleId, mpg.getPackageInfo().getParent(), mpg);
            mpg.setBocpConfig(null);
            this.dictGen(app.getId(), dictVersion, mpg);
            mpg.setBocpConfig(null);
            this.pfcpGen(app.getId(), appVersion, mpg);
            log.debug("module {} finish to exec codegen and start maven deploy", (Object)moduleId);
            this.mavenInvokerManager.executeDeploy(app.getId(), appVersion);
        }
        catch (Exception e) {
            log.error(String.format("module %d codegen and maven deploy error", moduleId), (Throwable)e);
        }
    }

    public void doGen2(App app, Long moduleId, String appVersion, String dictVersion) {
        try {
            log.info("module {} exec codegen and maven deploy", (Object)moduleId);
            BocpAutoGenerator mpg = this.appConfigInit(app, appVersion, "com.xforceplus.ultraman.app");
            this.moduleGen(app, moduleId, mpg);
            mpg.setBocpConfig(null);
            this.boGen2(moduleId, mpg);
            mpg.setBocpConfig(null);
            this.dtoGen(moduleId, mpg.getPackageInfo().getParent(), mpg);
            mpg.setBocpConfig(null);
            this.dictGen(app.getId(), dictVersion, mpg);
            mpg.setBocpConfig(null);
            this.pfcpGen(app.getId(), appVersion, mpg);
            log.info("module {} finish to exec codegen and start maven deploy", (Object)moduleId);
            this.mavenInvokerManager.executeDeploy(app.getId(), appVersion);
        }
        catch (Exception e) {
            log.error(String.format("module %d codegen and maven deploy error", moduleId), (Throwable)e);
        }
    }

    public void doGen3(App app, Long moduleId, String appVersion, String dictVersion) {
        try {
            log.info("module {} exec codegen and maven deploy", (Object)moduleId);
            BocpAutoGenerator mpg = this.appConfigInit(app, appVersion, "com.xforceplus.ultraman.app");
            this.moduleGen(app, moduleId, mpg);
            ForSdkGenerator forSdkGenerator = new ForSdkGenerator();
            forSdkGenerator.setGlobalConfig(mpg.getGlobalConfig());
            forSdkGenerator.setProjectConfig(mpg.getProjectConfig());
            forSdkGenerator.setStrategy(mpg.getStrategy());
            forSdkGenerator.setPackageInfo(mpg.getPackageInfo());
            forSdkGenerator.setApplicationConfig(mpg.getApplicationConfig());
            forSdkGenerator.setModuleConfig(mpg.getModuleConfig());
            mpg.setBocpConfig(null);
            this.dictGen(app.getId(), dictVersion, mpg);
            forSdkGenerator.setDictConfig(mpg.getDictConfig());
            mpg.setBocpConfig(null);
            this.boGen2(moduleId, mpg);
            forSdkGenerator.setBoConfig(mpg.getBoConfig());
            mpg.setBocpConfig(null);
            this.dtoGen(moduleId, mpg.getPackageInfo().getParent(), mpg);
            forSdkGenerator.setDtoConfig(mpg.getDtoConfig());
            mpg.setBocpConfig(null);
            this.pfcpGen(app.getId(), appVersion, mpg);
            forSdkGenerator.setPfcpConfig(mpg.getPfcpConfig());
            forSdkGenerator.execute("bo");
            forSdkGenerator.setBocpConfig(null);
            forSdkGenerator.setBoConfig(this.boConfigGen3(moduleId));
            forSdkGenerator.execute("meta");
            log.info("module {} finish to exec codegen and start maven deploy", (Object)moduleId);
            this.mavenInvokerManager.executeDeployForSdk(app.getId(), appVersion);
        }
        catch (Exception e) {
            log.error(String.format("module %d codegen and maven deploy error", moduleId), (Throwable)e);
        }
    }

    private void dtoGen(Long moduleId, String packagePath, BocpAutoGenerator mpg) {
        List idList = this.moduleBoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ModuleBo::getModuleId, (Object)moduleId)).eq(ModuleBo::getDeleteFlag, (Object)"1")).stream().map(ModuleBo::getBoId).collect(Collectors.toList());
        if (idList.isEmpty()) {
            return;
        }
        List bos = this.boMapper.selectBatchIds(idList);
        this.dtoGen(bos, packagePath, mpg);
    }

    private void dictGen(Long appId, String dictVersion, BocpAutoGenerator mpg) {
        List dicts = this.dictMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.PUBLISHED.code())).eq(Dict::getAppId, (Object)appId)).eq(Dict::getVersion, (Object)dictVersion));
        this.dictGen(dicts, mpg);
    }

    private void pfcpGen(Long appId, String appVersion, BocpAutoGenerator mpg) {
        List pages = this.pageVersionQuery.getPages(appId, appVersion);
        List forms = this.formVersionQuery.getForms(appId, appVersion);
        this.pfcpGen(pages, forms, mpg);
    }

    private void boGen(Long appId, Long moduleId, BocpAutoGenerator mpg) {
        ModuleBo moduleBo = new ModuleBo();
        moduleBo.setModuleId(moduleId);
        moduleBo.setDeleteFlag("1");
        List idList = this.moduleBoMapper.selectList((Wrapper)Wrappers.query((Object)moduleBo)).stream().map(ModuleBo::getBoId).collect(Collectors.toList());
        if (idList.isEmpty()) {
            return;
        }
        List bos = this.boMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).in(Bo::getId, idList));
        this.boGen(appId, bos, mpg);
    }

    private void boGen2(Long moduleId, BocpAutoGenerator mpg) {
        ModuleBo moduleBo = new ModuleBo();
        moduleBo.setModuleId(moduleId);
        moduleBo.setDeleteFlag("1");
        List idList = this.moduleBoMapper.selectList((Wrapper)Wrappers.query((Object)moduleBo)).stream().map(ModuleBo::getBoId).collect(Collectors.toList());
        if (idList.isEmpty()) {
            return;
        }
        List allBos = this.boMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).in(Bo::getId, idList));
        this.boGen2(allBos, mpg);
    }

    private BoConfig boConfigGen3(Long moduleId) {
        ModuleBo moduleBo = new ModuleBo();
        moduleBo.setModuleId(moduleId);
        moduleBo.setDeleteFlag("1");
        List idList = this.moduleBoMapper.selectList((Wrapper)Wrappers.query((Object)moduleBo)).stream().map(ModuleBo::getBoId).collect(Collectors.toList());
        if (idList.isEmpty()) {
            return null;
        }
        List bos = this.boMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).in(Bo::getId, idList));
        return this.boConfigGen3(bos);
    }
}

