/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.base.codegen;

import com.xforceplus.ultraman.bocp.gen.config.BoConfig;
import com.xforceplus.ultraman.bocp.gen.generator.BocpAutoGenerator;
import com.xforceplus.ultraman.bocp.gen.generator.ForSdkGenerator;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.constant.BocpConstant;
import com.xforceplus.ultraman.bocp.metadata.util.FormatUtil;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionMergeForMultiTenantService;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.metadata.generate.base.codegen.CodeGenBase;
import com.xforceplus.ultraman.metadata.generate.maven.MavenInvokerManager;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CodeGenForMultiTenantExecutor
extends CodeGenBase {
    private static final Logger log = LoggerFactory.getLogger(CodeGenForMultiTenantExecutor.class);
    @Autowired
    private MavenInvokerManager mavenInvokerManager;
    @Autowired
    private IAppVersionMergeForMultiTenantService appVersionMergeForMultiTenantService;

    public void doGen1(App app, Long moduleId, String appVersion) {
        try {
            log.debug("app {} exec codegen and maven deploy", (Object)app.getId());
            BocpAutoGenerator mpg = this.appConfigInit(app, appVersion, "com.xforceplus");
            this.moduleGen(app, moduleId, mpg);
            mpg.setBocpConfig(null);
            this.boGen(app.getId(), appVersion, mpg);
            mpg.setBocpConfig(null);
            this.dtoGen(app.getId(), appVersion, mpg.getPackageInfo().getParent(), mpg);
            mpg.setBocpConfig(null);
            this.dictGen(app.getId(), appVersion, mpg);
            mpg.setBocpConfig(null);
            this.pfcpGen(app.getId(), appVersion, mpg);
            log.debug("app {} finish to exec codegen and start maven deploy", (Object)app.getId());
            this.mavenInvokerManager.executeDeploy(app.getId(), appVersion);
        }
        catch (Exception e) {
            log.error(String.format("app %d codegen and maven deploy error", app.getId()), (Throwable)e);
        }
    }

    @SkipDataAuth
    public void doGen2(App app, Long moduleId, String appVersion, Map<Long, String> tenantAppVersionMap) {
        try {
            log.info("module {} exec codegen and maven deploy", (Object)moduleId);
            BocpAutoGenerator mpg = this.appConfigInit(app, appVersion, "com.xforceplus.ultraman.app");
            this.moduleGen(app, moduleId, mpg);
            mpg.setBocpConfig(null);
            this.boGen2(app.getId(), appVersion, tenantAppVersionMap, mpg);
            mpg.setBocpConfig(null);
            this.dtoGen(app.getId(), appVersion, mpg.getPackageInfo().getParent(), mpg);
            mpg.setBocpConfig(null);
            this.dictGen(app.getId(), appVersion, mpg);
            mpg.setBocpConfig(null);
            this.pfcpGen(app.getId(), appVersion, mpg);
            log.info("module {} finish to exec codegen and start maven deploy", (Object)moduleId);
            this.mavenInvokerManager.executeDeploy(app.getId(), appVersion);
        }
        catch (Exception e) {
            log.error(String.format("module %d codegen and maven deploy error", moduleId), (Throwable)e);
        }
    }

    @SkipDataAuth
    public void doGen3(App app, Long moduleId, String appVersion, Map<Long, String> tenantAppVersionMap) {
        try {
            log.info("module {} exec codegen and maven deploy", (Object)moduleId);
            BocpAutoGenerator mpg = this.appConfigInit(app, appVersion, "com.xforceplus.ultraman.app");
            this.moduleGen(app, moduleId, mpg);
            ForSdkGenerator forSdkGenerator = new ForSdkGenerator();
            forSdkGenerator.setGlobalConfig(mpg.getGlobalConfig());
            forSdkGenerator.setProjectConfig(mpg.getProjectConfig());
            forSdkGenerator.setStrategy(mpg.getStrategy());
            forSdkGenerator.setPackageInfo(mpg.getPackageInfo());
            forSdkGenerator.setApplicationConfig(mpg.getApplicationConfig());
            forSdkGenerator.setModuleConfig(mpg.getModuleConfig());
            mpg.setBocpConfig(null);
            this.dictGen(app.getId(), appVersion, mpg);
            forSdkGenerator.setDictConfig(mpg.getDictConfig());
            mpg.setBocpConfig(null);
            this.boGen2(app.getId(), appVersion, tenantAppVersionMap, mpg);
            forSdkGenerator.setBoConfig(mpg.getBoConfig());
            mpg.setBocpConfig(null);
            this.dtoGen(app.getId(), appVersion, mpg.getPackageInfo().getParent(), mpg);
            forSdkGenerator.setDtoConfig(mpg.getDtoConfig());
            mpg.setBocpConfig(null);
            this.pfcpGen(app.getId(), appVersion, mpg);
            forSdkGenerator.setPfcpConfig(mpg.getPfcpConfig());
            forSdkGenerator.execute("bo");
            forSdkGenerator.setBocpConfig(null);
            forSdkGenerator.setBoConfig(this.boConfigGen3(app.getId(), appVersion, tenantAppVersionMap));
            forSdkGenerator.execute("meta");
            log.info("module {} finish to exec codegen and start maven deploy", (Object)moduleId);
            this.mavenInvokerManager.executeDeployForSdk(app.getId(), appVersion);
        }
        catch (Exception e) {
            log.error(String.format("module %d codegen and maven deploy error", moduleId), (Throwable)e);
        }
    }

    private void dtoGen(Long appId, String appVersion, String packagePath, BocpAutoGenerator mpg) {
        List<Bo> bos = this.appVersionMergeForMultiTenantService.getBos(appId, appVersion).stream().filter(o -> BoType.DTO.code().equals(o.getBoType())).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList());
        if (bos.isEmpty()) {
            return;
        }
        this.dtoGen(bos, packagePath, mpg);
    }

    private void dictGen(Long appId, String appVersion, BocpAutoGenerator mpg) {
        List<Dict> dicts = this.appVersionMergeForMultiTenantService.getDicts(appId, appVersion).stream().filter(o -> StringUtils.isEmpty((CharSequence)o.getTenantCode())).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList());
        this.dictGen(dicts, mpg);
    }

    private void pfcpGen(Long appId, String appVersion, BocpAutoGenerator mpg) {
        List<UltPage> pages = this.appVersionMergeForMultiTenantService.getPages(appId, appVersion).stream().filter(o -> o.getRefPageId() == 0L).collect(Collectors.toList());
        List<UltForm> forms = this.appVersionMergeForMultiTenantService.getForms(appId, appVersion).stream().filter(o -> o.getRefFormId() == 0L).collect(Collectors.toList());
        this.pfcpGen(pages, forms, mpg);
    }

    private void boGen(Long appId, String appVersion, BocpAutoGenerator mpg) {
        List<Bo> bos = this.appVersionMergeForMultiTenantService.getBos(appId, appVersion).stream().filter(o -> !BocpConstant.NOT_ENTITY_TYPE_LIST.contains((Object)o.getBoType()) && null == o.getRefBoId()).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList());
        if (bos.isEmpty()) {
            return;
        }
        this.boGen(appId, bos, mpg);
    }

    private void boGen2(Long appId, String appVersion, Map<Long, String> tenantAppVersionMap, BocpAutoGenerator mpg) {
        List<Bo> allBos = this.appVersionMergeForMultiTenantService.getBos(appId, appVersion, tenantAppVersionMap).stream().filter(o -> !BocpConstant.NOT_ENTITY_TYPE_LIST.contains((Object)o.getBoType())).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList());
        this.boGen2(allBos, mpg);
    }

    private BoConfig boConfigGen3(Long appId, String appVersion, Map<Long, String> tenantAppVersionMap) {
        List<Bo> bos = this.appVersionMergeForMultiTenantService.getBos(appId, appVersion, tenantAppVersionMap).stream().filter(o -> !BocpConstant.NOT_ENTITY_TYPE_LIST.contains((Object)o.getBoType())).map(o -> o.setName(FormatUtil.lowerCamelToLowerUnderscore((String)o.getCode()))).collect(Collectors.toList());
        if (bos.isEmpty()) {
            return null;
        }
        return this.boConfigGen3(bos);
    }
}

