/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.base.ddlgen;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.DdlOpEnum;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.FieldMeta;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.IndexMeta;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.MysqlSqlGenerator;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.SqlGenerator;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.TableMeta;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.RelationType;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldStructMapper;
import com.xforceplus.ultraman.bocp.metadata.system.SystemSettingsHolder;
import com.xforceplus.ultraman.bocp.metadata.util.BoIndexUtil;
import com.xforceplus.ultraman.bocp.metadata.version.diff.VersionDiffAggregator;
import com.xforceplus.ultraman.bocp.metadata.version.dto.ChangedItem;
import com.xforceplus.ultraman.bocp.metadata.version.enums.DiffType;
import com.xforceplus.ultraman.bocp.metadata.version.mapstruct.VersionBoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBo;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoField;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoIndex;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoIndex;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldAttributeService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoRelationshipService;
import com.xforceplus.ultraman.metadata.generate.base.ddlgen.DdlGenUtil;
import com.xforceplus.ultraman.metadata.global.common.util.AppDBUtil;
import com.xforceplus.ultraman.metadata.repository.common.CommonService;
import io.vavr.Tuple2;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DdlGenBase {
    private final List<String> FIELD_ATTRS = Arrays.asList("name", "maxLength", "decimalPoint", "required", "defaultValue", "dynamicType");
    private final List<String> INDEX_ATTRS = Collections.singletonList("fieldCodes");
    @Autowired
    private VersionDiffAggregator versionDiffAggregator;
    @Autowired
    private IBoRelationshipService boRelationshipService;
    @Autowired
    private IBoFieldAttributeService boFieldAttributeService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private SystemSettingsHolder systemSettingsHolder;

    protected Tuple2<List<StringBuffer>, List<StringBuffer>> genDdlListByAppVersion(List<Bo> bos, String appCodeForDB) {
        Map<Long, Bo> boMap = bos.stream().collect(Collectors.toMap(Bo::getId, Functions.identity()));
        this.setParentBoIdByRefBoId(boMap);
        Map<String, String> boUidParentUidMapping = this.getBoUidParentUidMapping(boMap.values());
        Map<String, VersionBo> currentVersionBos = this.getVersionBos(boMap.values());
        Map<String, TableMeta> tableMetaMap = this.getTableMetaMap(appCodeForDB, currentVersionBos.values());
        MysqlSqlGenerator sqlGenerator = new MysqlSqlGenerator();
        ArrayList boSqls = Lists.newArrayList();
        ArrayList boRSqls = Lists.newArrayList();
        tableMetaMap.values().forEach(arg_0 -> DdlGenBase.lambda$genDdlListByAppVersion$0((SqlGenerator)sqlGenerator, boSqls, boRSqls, arg_0));
        Tuple2<List<StringBuffer>, List<StringBuffer>> viewDdl = this.genViewDdlByAppVersion(tableMetaMap, boUidParentUidMapping);
        boSqls.addAll((Collection)viewDdl._1);
        boRSqls.addAll((Collection)viewDdl._2);
        return new Tuple2((Object)boSqls, (Object)boRSqls);
    }

    protected Tuple2<List<StringBuffer>, List<StringBuffer>> genDdlListNewest(List<Bo> bos, String appCodeForDB) {
        Map<Long, Bo> boMap = bos.stream().collect(Collectors.toMap(Bo::getId, Functions.identity()));
        this.setParentBoIdByRefBoId(boMap);
        Map<String, String> parentIdMap = boMap.values().stream().filter(b -> null != b.getParentBoId() && boMap.containsKey(b.getParentBoId())).collect(Collectors.toMap(b -> String.valueOf(b.getId()), b -> String.valueOf(((Bo)boMap.get(b.getParentBoId())).getId())));
        Map<String, VersionBo> currentVersionBos = this.getVersionBos(boMap.values());
        Map<String, TableMeta> tableMetaMap = this.getTableMetaMap(appCodeForDB, currentVersionBos.values());
        MysqlSqlGenerator sqlGenerator = new MysqlSqlGenerator();
        ArrayList boSqls = Lists.newArrayList();
        ArrayList boRSqls = Lists.newArrayList();
        tableMetaMap.values().forEach(arg_0 -> DdlGenBase.lambda$genDdlListNewest$4((SqlGenerator)sqlGenerator, boSqls, boRSqls, arg_0));
        Tuple2<List<StringBuffer>, List<StringBuffer>> viewDdl = this.genViewDdlByAppVersion(tableMetaMap, parentIdMap);
        boSqls.addAll((Collection)viewDdl._1);
        boRSqls.addAll((Collection)viewDdl._2);
        return new Tuple2((Object)boSqls, (Object)boRSqls);
    }

    protected Tuple2<List<StringBuffer>, List<StringBuffer>> genDdlListByDiff(List<Bo> currentBos, List<Bo> deployBos, String appCodeForDB) {
        Map<Long, Bo> currentBoMap = currentBos.stream().collect(Collectors.toMap(Bo::getId, Functions.identity()));
        Map<Long, Bo> deployBoMap = deployBos.stream().collect(Collectors.toMap(Bo::getId, Functions.identity()));
        Map<String, List<String>> deployBoParentUidChildUidsMapping = this.getBoParentUidChildUidsMapping(deployBoMap.values());
        Map<String, Set<String>> deployBoUidTenantUidMapping = this.getBoUidTenantUidMapping(deployBoMap.values());
        this.setParentBoIdByRefBoId(currentBoMap);
        this.setParentBoIdByRefBoId(deployBoMap);
        Map<String, String> currentBoUidParentUidMapping = this.getBoUidParentUidMapping(currentBoMap.values());
        Map<String, String> deployBoUidParentUidMapping = this.getBoUidParentUidMapping(deployBoMap.values());
        Map<String, VersionBo> currentVersionBos = this.getVersionBos(currentBoMap.values());
        Map<String, VersionBo> deployVersionBos = this.getVersionBos(deployBoMap.values());
        Map<String, TableMeta> currentTableMetaMap = this.getTableMetaMap(appCodeForDB, currentVersionBos.values());
        Map<String, TableMeta> deployTableMetaMap = this.getTableMetaMap(appCodeForDB, deployVersionBos.values());
        List changeItems = this.versionDiffAggregator.diffBos(currentVersionBos, deployVersionBos);
        Map changeItemMap = changeItems.stream().collect(Collectors.toMap(ChangedItem::getPath, Functions.identity()));
        List<String> boRootPaths = changeItemMap.keySet().stream().map(path -> {
            String[] paths = path.split("/");
            return "/" + paths[1];
        }).distinct().sorted().collect(Collectors.toList());
        MysqlSqlGenerator sqlGenerator = new MysqlSqlGenerator();
        ArrayList boSqls = Lists.newArrayList();
        ArrayList boRSqls = Lists.newArrayList();
        ArrayList viewSqls = Lists.newArrayList();
        ArrayList viewRSqls = Lists.newArrayList();
        HashSet boIdStrsForViewUpdateWhenFieldCreateOrRemove = Sets.newHashSet();
        HashSet tenantBoIdStrsForViewUpdateWhenFieldCreateOrRemove = Sets.newHashSet();
        boRootPaths.forEach(arg_0 -> this.lambda$genDdlListByDiff$22(currentVersionBos, deployVersionBos, changeItems, appCodeForDB, (SqlGenerator)sqlGenerator, deployTableMetaMap, deployBoUidParentUidMapping, viewSqls, viewRSqls, currentTableMetaMap, currentBoUidParentUidMapping, boIdStrsForViewUpdateWhenFieldCreateOrRemove, deployBoParentUidChildUidsMapping, deployBoUidTenantUidMapping, tenantBoIdStrsForViewUpdateWhenFieldCreateOrRemove, boSqls, boRSqls, arg_0));
        SetUtils.SetView boIdStrsForViewUpdate = SetUtils.union((Set)boIdStrsForViewUpdateWhenFieldCreateOrRemove, (Set)tenantBoIdStrsForViewUpdateWhenFieldCreateOrRemove);
        for (String boIdStr : boIdStrsForViewUpdate) {
            TableMeta parentTableMeta = this.getParentTableMeta(boIdStr, deployTableMetaMap, deployBoUidParentUidMapping, deployBoParentUidChildUidsMapping);
            if (null == parentTableMeta) continue;
            TableMeta tableMeta = deployTableMetaMap.get(boIdStr);
            tableMeta.setParentTableMeta(parentTableMeta);
            viewSqls.add(new StringBuffer(sqlGenerator.view(tableMeta, DdlOpEnum.MODIFY).getSql() + "\n"));
            TableMeta originTableMeta = currentTableMetaMap.get(boIdStr);
            originTableMeta.setParentTableMeta(currentTableMetaMap.get(currentBoUidParentUidMapping.get(boIdStr)));
            viewRSqls.add(new StringBuffer(sqlGenerator.view(originTableMeta, DdlOpEnum.MODIFY).getRSql() + "\n"));
        }
        boSqls.addAll(viewSqls);
        boRSqls.addAll(viewRSqls);
        return new Tuple2((Object)boSqls, (Object)boRSqls);
    }

    protected Map<String, VersionBo> getVersionBos(Collection<Bo> bos) {
        List allBos = bos.stream().filter(bo -> BoType.ENTITY.code().equals(bo.getBoType())).collect(Collectors.toList());
        if (allBos.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, Bo> allBoMap = allBos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        Map boMap = allBos.stream().filter(bo -> bo.getRefBoId() == null).collect(Collectors.toMap(Bo::getId, Function.identity()));
        if (boMap.isEmpty()) {
            return Maps.newHashMap();
        }
        Map<Long, List<Bo>> tenantBoMap = allBos.stream().filter(bo -> bo.getRefBoId() != null).collect(Collectors.groupingBy(Bo::getRefBoId));
        Map boFieldsMap = this.commonService.getBoFieldMap(new ArrayList<Long>(allBoMap.keySet()));
        Map<Long, List<BoRelationship>> boRelsMap = this.boRelationshipService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(BoRelationship::getBoId, allBoMap.keySet())).in(BoRelationship::getRelationType, Arrays.asList(RelationType.OTO.code(), RelationType.MTO.code(), RelationType.MV.code()))).eq(BoRelationship::getDeleteFlag, (Object)"1")).stream().collect(Collectors.groupingBy(BoRelationship::getBoId));
        Map boIndexesMap = this.commonService.getBoIndexMap(new ArrayList<Long>(allBoMap.keySet()));
        Map<Long, Long> boIdMap = allBoMap.values().stream().collect(Collectors.toMap(Bo::getId, bo -> bo.getPublishBoId() == null ? bo.getId() : bo.getPublishBoId()));
        ArrayList result = Lists.newArrayList();
        for (Bo bo2 : boMap.values()) {
            ArrayList tempResult = Lists.newArrayList();
            VersionBo versionBo = this.buildVersionBo(bo2, boFieldsMap, boRelsMap, boIndexesMap, boIdMap, this.getBoParentIds(bo2, allBoMap));
            tempResult.add(versionBo);
            Optional.ofNullable(tenantBoMap.get(bo2.getId())).ifPresent(tenantBos -> tenantBos.forEach(tenantBo -> {
                VersionBo versionTenantBo = this.buildVersionBo((Bo)tenantBo, boFieldsMap, boRelsMap, boIndexesMap, boIdMap, this.getBoParentIds((Bo)tenantBo, allBoMap));
                versionTenantBo.setCode(AppDBUtil.getTenantBoCode((String)versionTenantBo.getCode(), (String)versionTenantBo.getTenantCode()));
                tempResult.add(versionTenantBo);
            }));
            result.addAll(tempResult.stream().sorted(Comparator.comparing(VersionBo::getId)).collect(Collectors.toList()));
        }
        return result.stream().collect(Collectors.toMap(b -> b.getId().toString(), Functions.identity()));
    }

    protected VersionBo buildVersionBo(Bo bo, Map<Long, List<BoField>> boFieldsMap, Map<Long, List<BoRelationship>> boRelsMap, Map<Long, List<BoIndex>> boIndexesMap, Map<Long, Long> boIdMap, List<Long> parentBoIds) {
        Map<Long, Long> boFieldIdMap = boFieldsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(BoField::getId, boField -> boField.getPublishFieldId() == null ? boField.getId() : boField.getPublishFieldId()));
        VersionBo versionBo = VersionBoStructMapper.MAPPER.toVersionBo(bo);
        List<BoIndex> indexesList = this.getIndexesByBoIds(bo, boIndexesMap);
        Map indexesMap = indexesList.stream().map(arg_0 -> ((VersionBoStructMapper)VersionBoStructMapper.MAPPER).toVersionBoIndex(arg_0)).collect(Collectors.toMap(i -> String.valueOf(i.getId()), Function.identity()));
        versionBo.setBoIndexes(indexesMap);
        List<BoField> boFields = this.getFieldMergeList(bo.getId(), parentBoIds, indexesList, boFieldsMap);
        List fieldIds = boFields.stream().map(BoField::getId).collect(Collectors.toList());
        Map attrMap = this.commonService.getBoFieldAttributeMap(fieldIds);
        Map domainAttrMap = this.commonService.getBoFieldDomainAttributeMap(fieldIds);
        boFields.forEach(boField -> boField.setBoId((Long)boIdMap.get(boField.getBoId())).setSyncFieldId((Long)boFieldIdMap.get(boField.getSyncFieldId())));
        List<VersionBoField> versionBoFields = boFields.stream().map(boField -> {
            if ("lookup".equals(boField.getFieldType()) && domainAttrMap.containsKey(boField.getId())) {
                BoFieldDomainAttribute domainAttribute = (BoFieldDomainAttribute)((List)domainAttrMap.get(boField.getId())).get(0);
                Optional.ofNullable(boFieldsMap.get(domainAttribute.getLookupBoId())).ifPresent(fields -> fields.stream().filter(field -> field.getId().equals(domainAttribute.getLookupFieldId())).findAny().ifPresent(lookupField -> {
                    BoFieldAttribute boFieldAttribute = Optional.ofNullable(attrMap.get(boField.getId())).map(boFieldAttributes -> (BoFieldAttribute)boFieldAttributes.get(0)).orElse(null);
                    BoFieldAttribute lookupFieldAttribute = this.boFieldAttributeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldAttribute::getFieldId, (Object)lookupField.getId())).eq(BoFieldAttribute::getDeleteFlag, (Object)"1")).stream().findAny().orElse(null);
                    if (boFieldAttribute != null && lookupFieldAttribute != null) {
                        boField.setFieldType(lookupField.getFieldType());
                        boField.setDefaultValue(StringUtils.isEmpty((CharSequence)boField.getDefaultValue()) ? lookupField.getDefaultValue() : boField.getDefaultValue());
                        boField.setDictId(lookupField.getDictId());
                        boFieldAttribute.setDecimalPoint(lookupFieldAttribute.getDecimalPoint());
                        boFieldAttribute.setMaxSize(lookupFieldAttribute.getMaxSize());
                    }
                }));
            }
            return VersionBoStructMapper.MAPPER.toVersionBoField(boField, (BoFieldAttribute)Optional.ofNullable(attrMap.get(boField.getId())).map(boFieldAttributes -> (BoFieldAttribute)boFieldAttributes.get(0)).orElse(null), null, (BoFieldDomainAttribute)Optional.ofNullable(domainAttrMap.get(boField.getId())).map(boFieldDomainAttributes -> (BoFieldDomainAttribute)boFieldDomainAttributes.get(0)).orElse(null));
        }).collect(Collectors.toList());
        List<BoRelationship> boRels = Optional.ofNullable(boRelsMap.get(bo.getId())).orElse(Lists.newArrayList());
        versionBoFields.addAll(boRels.stream().map(boRel -> {
            BoField boField = new BoField();
            boField.setId(boRel.getUniqueId());
            boField.setName(boRel.getRelationName());
            boField.setCode(boRel.getRelationCode() + "_id");
            boField.setUpdateTime(LocalDateTime.now());
            BoFieldAttribute boFieldAttribute = new BoFieldAttribute();
            if (RelationType.MV.code().equals(boRel.getRelationType())) {
                boField.setFieldType(RelationType.MV.code());
                boFieldAttribute.setLength(null);
            } else {
                boField.setFieldType(FieldType.SERIALNO.code());
                boFieldAttribute.setLength(Integer.valueOf(20));
                boFieldAttribute.setCanNil("1");
            }
            return VersionBoStructMapper.MAPPER.toVersionBoField(boField, boFieldAttribute, null, null);
        }).collect(Collectors.toList()));
        versionBoFields.forEach(DdlGenUtil::buildFieldTypeAndLength);
        versionBo.setBoFields(versionBoFields.stream().collect(Collectors.toMap(vBoField -> String.valueOf(vBoField.getId()), Functions.identity())));
        this.addSystemFields(versionBo);
        return versionBo;
    }

    protected List<Long> getBoParentIds(Bo bo, Map<Long, Bo> allBoMap) {
        if (null == bo) {
            return Lists.newArrayList();
        }
        if (null == bo.getRefBoId()) {
            if (bo.getLevel() == null || bo.getLevel() == 0 || bo.getParentBoId() == null) {
                return Lists.newArrayList();
            }
            ArrayList parentBoIds = Lists.newArrayList();
            Bo parentBo = bo;
            while (parentBo != null && parentBo.getParentBoId() != null) {
                if ((parentBo = allBoMap.get(parentBo.getParentBoId())) == null) continue;
                parentBoIds.add(parentBo.getId());
            }
            return parentBoIds;
        }
        Bo stdBo = allBoMap.get(bo.getRefBoId());
        ArrayList parentBoIds = Lists.newArrayList((Object[])new Long[]{stdBo.getId()});
        if (stdBo.getLevel() == null || stdBo.getLevel() == 0 || stdBo.getParentBoId() == null) {
            return parentBoIds;
        }
        Bo parentBo = stdBo;
        while (parentBo != null && parentBo.getParentBoId() != null) {
            Long parentBoId = parentBo.getParentBoId();
            Optional<Bo> parentTenantBoOptional = allBoMap.values().stream().filter(b -> parentBoId.equals(b.getParentBoId()) && bo.getTenantCode().equals(b.getTenantCode())).findAny();
            parentTenantBoOptional.ifPresent(value -> parentBoIds.add(value.getId()));
            if ((parentBo = allBoMap.get(parentBo.getParentBoId())) == null) continue;
            parentBoIds.add(parentBo.getId());
        }
        return parentBoIds;
    }

    protected List<BoField> getFieldMergeList(Long boId, List<Long> parentBoIds, List<BoIndex> indexesList, Map<Long, List<BoField>> boFieldsMap) {
        Map parentBoFieldMap = parentBoIds.stream().map(boFieldsMap::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toMap(BoField::getCode, Function.identity()));
        List fieldCodesInIndexes = indexesList.stream().map(i -> BoIndexUtil.getFieldCodeList((String)i.getFieldCodes())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List parentBoFieldsInIndexes = fieldCodesInIndexes.stream().filter(parentBoFieldMap::containsKey).map(code -> {
            BoField cloneField = BoFieldStructMapper.MAPPER.clone((BoField)parentBoFieldMap.get(code));
            cloneField.setDynamicType("0");
            return cloneField;
        }).collect(Collectors.toList());
        List<BoField> theBoFields = Optional.ofNullable(boFieldsMap.get(boId)).orElse(Lists.newArrayList());
        return ListUtils.union(parentBoFieldsInIndexes, theBoFields);
    }

    protected List<BoIndex> getIndexesByBoIds(Bo bo, Map<Long, List<BoIndex>> boIndexesMap) {
        return Optional.ofNullable(boIndexesMap.get(bo.getId())).map(boIndexes -> boIndexes.stream().map(bI -> bI.setBoId(bo.getPublishBoId())).collect(Collectors.toList())).orElse(Lists.newArrayList());
    }

    protected Map<String, Set<String>> getBoUidTenantUidMapping(Collection<Bo> bos) {
        Map<Long, Long> boUniIdMap = bos.stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        return bos.stream().filter(b -> null != b.getRefBoId() && boUniIdMap.containsKey(b.getRefBoId())).collect(Collectors.groupingBy(b -> String.valueOf(boUniIdMap.get(b.getRefBoId())), Collectors.mapping(b -> String.valueOf(b.getPublishBoId()), Collectors.toSet())));
    }

    protected Map<String, String> getBoUidParentUidMapping(Collection<Bo> bos) {
        Map<Long, Long> boUniIdMap = bos.stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        return bos.stream().filter(b -> null != b.getParentBoId() && boUniIdMap.containsKey(b.getParentBoId())).collect(Collectors.toMap(b -> String.valueOf(b.getPublishBoId()), b -> String.valueOf(boUniIdMap.get(b.getParentBoId()))));
    }

    protected Map<String, List<String>> getBoParentUidChildUidsMapping(Collection<Bo> bos) {
        Map<Long, Long> boUniIdMap = bos.stream().collect(Collectors.toMap(Bo::getId, Bo::getPublishBoId));
        List stdBos = bos.stream().filter(o -> null == o.getRefBoId()).collect(Collectors.toList());
        List tenantBos = bos.stream().filter(o -> null != o.getRefBoId()).collect(Collectors.toList());
        HashMap childBoIdsMap = Maps.newHashMap();
        Map<Long, List<Bo>> stdChildBosMap = stdBos.stream().filter(b -> null != b.getParentBoId() && boUniIdMap.containsKey(b.getParentBoId())).collect(Collectors.groupingBy(Bo::getParentBoId));
        stdChildBosMap.forEach((k, v) -> childBoIdsMap.put(String.valueOf(boUniIdMap.get(k)), v.stream().map(o -> String.valueOf(o.getPublishBoId())).collect(Collectors.toList())));
        tenantBos.stream().filter(o -> null != o.getParentBoId()).forEach(o -> {
            Optional<Bo> tenantParentBo = tenantBos.stream().filter(o1 -> o.getParentBoId().equals(o1.getRefBoId()) && o.getTenantCode().equals(o1.getTenantCode())).findAny();
            if (tenantParentBo.isPresent()) {
                String tenantParentBoIdStr = String.valueOf(tenantParentBo.get().getPublishBoId());
                if (childBoIdsMap.containsKey(tenantParentBoIdStr)) {
                    ((List)childBoIdsMap.get(tenantParentBoIdStr)).add(String.valueOf(o.getPublishBoId()));
                } else {
                    childBoIdsMap.put(tenantParentBoIdStr, Collections.singletonList(String.valueOf(o.getPublishBoId())));
                }
            } else {
                String stdParentBoIdStr = String.valueOf(boUniIdMap.get(o.getParentBoId()));
                if (childBoIdsMap.containsKey(stdParentBoIdStr)) {
                    ((List)childBoIdsMap.get(stdParentBoIdStr)).add(String.valueOf(o.getPublishBoId()));
                } else {
                    childBoIdsMap.put(stdParentBoIdStr, Collections.singletonList(String.valueOf(o.getPublishBoId())));
                }
            }
        });
        return childBoIdsMap;
    }

    protected Tuple2<List<StringBuffer>, List<StringBuffer>> genViewDdlByAppVersion(Map<String, TableMeta> tableMetaMap, Map<String, String> parentIdMap) {
        MysqlSqlGenerator sqlGenerator = new MysqlSqlGenerator();
        ArrayList viewSqls = Lists.newArrayList();
        ArrayList viewRSqls = Lists.newArrayList();
        ArrayList tableMetasForView = Lists.newArrayList();
        parentIdMap.keySet().forEach(k -> {
            if (tableMetaMap.containsKey(k)) {
                TableMeta tableMeta = (TableMeta)tableMetaMap.get(k);
                if (tableMetaMap.containsKey(parentIdMap.get(k))) {
                    tableMeta.setParentTableMeta((TableMeta)tableMetaMap.get(parentIdMap.get(k)));
                    tableMetasForView.add(tableMeta);
                }
            }
        });
        tableMetasForView.forEach(arg_0 -> DdlGenBase.lambda$genViewDdlByAppVersion$63((SqlGenerator)sqlGenerator, viewSqls, viewRSqls, arg_0));
        return new Tuple2((Object)viewSqls, (Object)viewRSqls);
    }

    protected void addSystemFields(VersionBo versionBo) {
        ArrayList versionBoFields = Lists.newArrayList();
        List fieldCodes = versionBo.getBoFields().values().stream().map(VersionBoField::getCode).collect(Collectors.toList());
        this.systemSettingsHolder.getSystemFields().stream().filter(sf -> !fieldCodes.contains(sf.getCode())).forEach(sf -> {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            versionBoFields.add(VersionBoStructMapper.MAPPER.toVersionBoField(sf).setId(Long.valueOf(System.currentTimeMillis())));
        });
        this.systemSettingsHolder.getSystemFieldsForDB().stream().filter(sf -> !fieldCodes.contains(sf.getCode())).forEach(sf -> {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            versionBoFields.add(VersionBoStructMapper.MAPPER.toVersionBoField(sf).setId(Long.valueOf(System.currentTimeMillis())));
        });
        versionBoFields.forEach(DdlGenUtil::buildFieldTypeAndLength);
        versionBo.getBoFields().putAll(versionBoFields.stream().collect(Collectors.toMap(vBoField -> String.valueOf(vBoField.getId()), Functions.identity())));
    }

    protected Map<String, TableMeta> getTableMetaMap(String appCodeForDB, Collection<VersionBo> bos) {
        return bos.stream().collect(Collectors.toMap(o -> String.valueOf(o.getId()), o -> {
            TableMeta tableMeta = new TableMeta();
            tableMeta.setCode(AppDBUtil.getTableName((String)appCodeForDB, (String)o.getCode()));
            tableMeta.setName(o.getName());
            tableMeta.setFieldMetas(this.getFieldMetas((VersionBo)o));
            tableMeta.setIndexMetas(this.getIndexMetas((VersionBo)o, tableMeta.getCode()));
            tableMeta.setTenantBo(StringUtils.isNotBlank((CharSequence)o.getTenantCode()));
            return tableMeta;
        }));
    }

    protected List<FieldMeta> getFieldMetas(VersionBo bo) {
        List systemFieldCodesNoId = this.systemSettingsHolder.getCodes().stream().filter(code -> !"id".equals(code)).collect(Collectors.toList());
        List allSystemFieldCodes = ListUtils.union((List)this.systemSettingsHolder.getSystemFieldCodes(), (List)this.systemSettingsHolder.getSystemFieldCodesForDB());
        ArrayList boFieldsReOrder = Lists.newArrayList();
        boFieldsReOrder.addAll(bo.getBoFields().values().stream().filter(field -> "id".equals(field.getCode())).collect(Collectors.toList()));
        boFieldsReOrder.addAll(bo.getBoFields().values().stream().filter(field -> !allSystemFieldCodes.contains(field.getCode())).collect(Collectors.toList()));
        boFieldsReOrder.addAll(bo.getBoFields().values().stream().filter(field -> systemFieldCodesNoId.contains(field.getCode()) || this.systemSettingsHolder.getSystemFieldCodesForDB().contains(field.getCode())).peek(field -> {
            if ("delete_flag".equals(field.getCode())) {
                field.setDefaultValue("0");
            }
        }).collect(Collectors.toList()));
        return boFieldsReOrder.stream().map(field -> {
            FieldMeta fieldMeta = new FieldMeta();
            fieldMeta.setTableCode(bo.getCode());
            fieldMeta.setCode(field.getCode());
            fieldMeta.setType(field.getType());
            fieldMeta.setAttr(DdlGenUtil.buildFieldAttrMeta(field));
            return fieldMeta;
        }).collect(Collectors.toList());
    }

    protected List<IndexMeta> getIndexMetas(VersionBo bo, String tableMetaCode) {
        ArrayList indexMetas = Lists.newArrayList();
        Optional.ofNullable(bo.getBoIndexes()).ifPresent(boIndexes -> indexMetas.addAll(boIndexes.values().stream().map(index -> {
            IndexMeta indexMeta = new IndexMeta();
            indexMeta.setCode(index.getCode());
            indexMeta.setType(index.getType());
            indexMeta.setFieldCodes(index.getFieldCodes());
            indexMeta.setTableCode(tableMetaCode);
            return indexMeta;
        }).collect(Collectors.toList())));
        return indexMetas;
    }

    protected void setParentBoIdByRefBoId(Map<Long, Bo> boMap) {
        boMap.values().stream().filter(bo -> null != bo.getRefBoId()).forEach(bo -> {
            bo.setParentBoId(bo.getRefBoId());
            Optional.ofNullable(boMap.get(bo.getRefBoId())).ifPresent(mainBo -> bo.setLevel(Integer.valueOf(mainBo.getLevel() + 1)));
        });
    }

    protected TableMeta getParentTableMeta(String boIdStr, Map<String, TableMeta> deployTableMetaMap, Map<String, String> deployBoUidParentUidMapping, Map<String, List<String>> deployParentIdChildIdsMap) {
        HashMap deployChildIdParentIdMap = Maps.newHashMap();
        deployParentIdChildIdsMap.forEach((k, v) -> v.forEach(o -> deployChildIdParentIdMap.putIfAbsent(o, k)));
        TableMeta parentTableMeta = null;
        if (deployTableMetaMap.containsKey(deployChildIdParentIdMap.get(boIdStr))) {
            parentTableMeta = deployTableMetaMap.get(deployChildIdParentIdMap.get(boIdStr));
        } else if (deployTableMetaMap.containsKey(deployBoUidParentUidMapping.get(boIdStr))) {
            parentTableMeta = deployTableMetaMap.get(deployBoUidParentUidMapping.get(boIdStr));
        }
        return parentTableMeta;
    }

    private static /* synthetic */ void lambda$genViewDdlByAppVersion$63(SqlGenerator sqlGenerator, List viewSqls, List viewRSqls, TableMeta tableMeta) {
        StringBuffer sql = new StringBuffer(sqlGenerator.view(tableMeta, DdlOpEnum.CREATE).getSql() + "\n");
        StringBuffer rSql = new StringBuffer(sqlGenerator.view(tableMeta, DdlOpEnum.CREATE).getRSql() + "\n");
        viewSqls.add(sql);
        viewRSqls.add(rSql);
    }

    private /* synthetic */ void lambda$genDdlListByDiff$22(Map currentVersionBos, Map deployVersionBos, List changeItems, String appCodeForDB, SqlGenerator sqlGenerator, Map deployTableMetaMap, Map deployBoUidParentUidMapping, List viewSqls, List viewRSqls, Map currentTableMetaMap, Map currentBoUidParentUidMapping, Set boIdStrsForViewUpdateWhenFieldCreateOrRemove, Map deployBoParentUidChildUidsMapping, Map deployBoUidTenantUidMapping, Set tenantBoIdStrsForViewUpdateWhenFieldCreateOrRemove, List boSqls, List boRSqls, String boRootPath) {
        VersionBo tempBo;
        String[] boRootPathParts = boRootPath.split("/");
        StringBuffer sql = new StringBuffer();
        StringBuffer rSql = new StringBuffer();
        VersionBo versionBo = tempBo = currentVersionBos.containsKey(boRootPathParts[1]) ? (VersionBo)currentVersionBos.get(boRootPathParts[1]) : (VersionBo)deployVersionBos.get(boRootPathParts[1]);
        if (tempBo == null) {
            throw new RuntimeException("\u67e5\u8be2\u4e0d\u5230\u5bf9\u8c61");
        }
        List<ChangedItem> changedItemsOfBo = changeItems.stream().filter(item -> item.getPath().contains(boRootPath) && item.getPath().split("/").length <= 3).collect(Collectors.toList());
        changedItemsOfBo.forEach(item -> {
            String[] paths = item.getPath().split("/");
            if (paths.length == 2) {
                if (DiffType.ADD.code().equals(item.getOp())) {
                    VersionBo bo = (VersionBo)deployVersionBos.get(paths[1]);
                    TableMeta tableMeta = new TableMeta();
                    tableMeta.setCode(AppDBUtil.getTableName((String)appCodeForDB, (String)bo.getCode()));
                    tableMeta.setName(bo.getName());
                    tableMeta.setFieldMetas(this.getFieldMetas(bo));
                    tableMeta.setIndexMetas(this.getIndexMetas(bo, tableMeta.getCode()));
                    sql.append(sqlGenerator.table(tableMeta, DdlOpEnum.CREATE).getSql()).append("\n");
                    rSql.append(sqlGenerator.table(tableMeta, DdlOpEnum.CREATE).getRSql()).append("\n");
                    if (deployTableMetaMap.containsKey(deployBoUidParentUidMapping.get(paths[1]))) {
                        tableMeta.setParentTableMeta((TableMeta)deployTableMetaMap.get(deployBoUidParentUidMapping.get(paths[1])));
                        viewSqls.add(new StringBuffer(sqlGenerator.view(tableMeta, DdlOpEnum.CREATE).getSql() + "\n"));
                        viewRSqls.add(new StringBuffer(sqlGenerator.view(tableMeta, DdlOpEnum.CREATE).getRSql() + "\n"));
                    }
                } else if (DiffType.REMOVE.code().equals(item.getOp())) {
                    VersionBo bo = (VersionBo)currentVersionBos.get(paths[1]);
                    TableMeta tableMeta = new TableMeta();
                    tableMeta.setCode(AppDBUtil.getTableName((String)appCodeForDB, (String)bo.getCode()));
                    tableMeta.setName(bo.getName());
                    sql.append(sqlGenerator.table(tableMeta, DdlOpEnum.REMOVE).getSql()).append("\n");
                    rSql.append(sqlGenerator.table(tableMeta, DdlOpEnum.REMOVE).getRSql()).append("\n");
                    if (currentTableMetaMap.containsKey(deployBoUidParentUidMapping.get(paths[1]))) {
                        tableMeta.setParentTableMeta((TableMeta)currentTableMetaMap.get(deployBoUidParentUidMapping.get(paths[1])));
                        viewSqls.add(new StringBuffer(sqlGenerator.view(tableMeta, DdlOpEnum.REMOVE).getSql() + "\n"));
                        viewRSqls.add(new StringBuffer(sqlGenerator.view(tableMeta, DdlOpEnum.REMOVE).getRSql() + "\n"));
                    }
                }
            } else if (paths.length == 3) {
                VersionBo originBo = (VersionBo)currentVersionBos.get(paths[1]);
                VersionBo newBo = (VersionBo)deployVersionBos.get(paths[1]);
                TableMeta tableMeta = new TableMeta();
                tableMeta.setCode(AppDBUtil.getTableName((String)appCodeForDB, (String)originBo.getCode()));
                tableMeta.setName(originBo.getName());
                tableMeta.setNewName(newBo.getName());
                sql.append(sqlGenerator.table(tableMeta, DdlOpEnum.MODIFY).getSql()).append("\n");
                rSql.append(sqlGenerator.table(tableMeta, DdlOpEnum.MODIFY).getRSql()).append("\n");
            }
        });
        List changedItemsOfFields = changeItems.stream().filter(item -> item.getPath().contains(boRootPath) && item.getPath().split("/").length == 4 && "boFields".equals(item.getPath().split("/")[2])).collect(Collectors.toList());
        changedItemsOfFields.stream().sorted((o1, o2) -> {
            String[] paths1 = o1.getPath().split("/");
            String[] paths2 = o2.getPath().split("/");
            return paths1[3].compareTo(paths2[3]);
        }).forEach(item -> {
            String[] paths = item.getPath().split("/");
            if (DiffType.ADD.code().equals(item.getOp())) {
                VersionBo bo = (VersionBo)deployVersionBos.get(paths[1]);
                VersionBoField field = (VersionBoField)bo.getBoFields().get(paths[3]);
                if (this.systemSettingsHolder.getSystemFieldCodes().contains(field.getCode()) || this.systemSettingsHolder.getSystemFieldCodesForDB().contains(field.getCode())) {
                    return;
                }
                FieldMeta fieldMeta = DdlGenUtil.buildFieldMeta(appCodeForDB, bo.getCode(), field);
                sql.append(sqlGenerator.field(fieldMeta, DdlOpEnum.CREATE).getSql()).append("\n");
                rSql.append(sqlGenerator.field(fieldMeta, DdlOpEnum.CREATE).getRSql()).append("\n");
            } else if (DiffType.REMOVE.code().equals(item.getOp())) {
                VersionBo bo = (VersionBo)currentVersionBos.get(paths[1]);
                VersionBoField field = (VersionBoField)bo.getBoFields().get(paths[3]);
                if (this.systemSettingsHolder.getSystemFieldCodes().contains(field.getCode()) || this.systemSettingsHolder.getSystemFieldCodesForDB().contains(field.getCode())) {
                    return;
                }
                FieldMeta fieldMeta = DdlGenUtil.buildFieldMeta(appCodeForDB, bo.getCode(), field);
                sql.append(sqlGenerator.field(fieldMeta, DdlOpEnum.REMOVE).getSql()).append("\n");
                rSql.append(sqlGenerator.field(fieldMeta, DdlOpEnum.REMOVE).getRSql()).append("\n");
            }
            if (Arrays.asList(DiffType.ADD.code(), DiffType.REMOVE.code()).contains(item.getOp())) {
                if (currentBoUidParentUidMapping.containsKey(paths[1]) || deployBoUidParentUidMapping.containsKey(paths[1])) {
                    boIdStrsForViewUpdateWhenFieldCreateOrRemove.add(paths[1]);
                }
                if (deployBoParentUidChildUidsMapping.containsKey(paths[1])) {
                    boIdStrsForViewUpdateWhenFieldCreateOrRemove.addAll((Collection)deployBoParentUidChildUidsMapping.get(paths[1]));
                }
                if (deployBoUidTenantUidMapping.containsKey(paths[1])) {
                    tenantBoIdStrsForViewUpdateWhenFieldCreateOrRemove.addAll((Collection)deployBoUidTenantUidMapping.get(paths[1]));
                }
            }
        });
        List changedItemsOfFieldsMdy = changeItems.stream().filter(item -> {
            if (!item.getPath().contains(boRootPath)) {
                return false;
            }
            String[] paths = item.getPath().split("/");
            return paths.length > 4 && "boFields".equals(paths[2]) && this.FIELD_ATTRS.contains(paths[4]);
        }).collect(Collectors.toList());
        if (!changedItemsOfFieldsMdy.isEmpty()) {
            Map fieldChangeItemMap = changedItemsOfFieldsMdy.stream().collect(Collectors.toMap(ChangedItem::getPath, Functions.identity()));
            List<String> fieldRootPaths = fieldChangeItemMap.keySet().stream().map(fieldPath -> {
                String[] paths = fieldPath.split("/");
                return "/" + paths[1] + "/" + paths[2] + "/" + paths[3];
            }).distinct().sorted((o1, o2) -> {
                String[] paths1 = o1.split("/");
                String[] paths2 = o2.split("/");
                return paths1[3].compareTo(paths2[3]);
            }).collect(Collectors.toList());
            fieldRootPaths.forEach(fieldRootPath -> {
                String[] paths = fieldRootPath.split("/");
                VersionBo currentBo = (VersionBo)currentVersionBos.get(paths[1]);
                VersionBoField currentField = (VersionBoField)currentBo.getBoFields().get(paths[3]);
                VersionBo deployBo = (VersionBo)deployVersionBos.get(paths[1]);
                VersionBoField deployField = (VersionBoField)deployBo.getBoFields().get(paths[3]);
                if (this.systemSettingsHolder.getSystemFieldCodes().contains(currentField.getCode()) || this.systemSettingsHolder.getSystemFieldCodesForDB().contains(currentField.getCode())) {
                    return;
                }
                FieldMeta fieldMeta = DdlGenUtil.buildFieldMeta(appCodeForDB, currentBo.getCode(), deployField);
                fieldMeta.setOriginAttr(DdlGenUtil.buildFieldAttrMeta(currentField));
                sql.append(sqlGenerator.field(fieldMeta, DdlOpEnum.MODIFY).getSql()).append("\n");
                rSql.append(sqlGenerator.field(fieldMeta, DdlOpEnum.MODIFY).getRSql()).append("\n");
            });
        }
        List changedItemsOfIndexes = changeItems.stream().filter(item -> item.getPath().contains(boRootPath) && item.getPath().split("/").length == 4 && "boIndexes".equals(item.getPath().split("/")[2])).collect(Collectors.toList());
        changedItemsOfIndexes.stream().sorted((o1, o2) -> {
            String[] paths1 = o1.getPath().split("/");
            String[] paths2 = o2.getPath().split("/");
            return paths1[3].compareTo(paths2[3]);
        }).forEach(item -> {
            String[] paths = item.getPath().split("/");
            if (DiffType.ADD.code().equals(item.getOp())) {
                VersionBo bo = (VersionBo)deployVersionBos.get(paths[1]);
                IndexMeta indexMeta = DdlGenUtil.buildIndexMeta(appCodeForDB, bo.getCode(), (VersionBoIndex)bo.getBoIndexes().get(paths[3]));
                sql.append(sqlGenerator.index(indexMeta, DdlOpEnum.CREATE).getSql()).append("\n");
                rSql.append(sqlGenerator.index(indexMeta, DdlOpEnum.CREATE).getRSql()).append("\n");
            } else if (DiffType.REMOVE.code().equals(item.getOp())) {
                VersionBo bo = (VersionBo)currentVersionBos.get(paths[1]);
                IndexMeta indexMeta = DdlGenUtil.buildIndexMeta(appCodeForDB, bo.getCode(), (VersionBoIndex)bo.getBoIndexes().get(paths[3]));
                sql.append(sqlGenerator.index(indexMeta, DdlOpEnum.REMOVE).getSql()).append("\n");
                rSql.append(sqlGenerator.index(indexMeta, DdlOpEnum.REMOVE).getRSql()).append("\n");
            }
        });
        List changedItemsOfIndexesMdy = changeItems.stream().filter(item -> {
            if (!item.getPath().contains(boRootPath)) {
                return false;
            }
            String[] paths = item.getPath().split("/");
            return paths.length > 4 && "boIndexes".equals(paths[2]) && this.INDEX_ATTRS.contains(paths[4]);
        }).collect(Collectors.toList());
        if (!changedItemsOfIndexesMdy.isEmpty()) {
            Map indexChangeItemMap = changedItemsOfIndexesMdy.stream().collect(Collectors.toMap(ChangedItem::getPath, Functions.identity()));
            List<String> fieldRootPaths = indexChangeItemMap.keySet().stream().map(fieldPath -> {
                String[] paths = fieldPath.split("/");
                return "/" + paths[1] + "/" + paths[2] + "/" + paths[3];
            }).distinct().sorted((o1, o2) -> {
                String[] paths1 = o1.split("/");
                String[] paths2 = o2.split("/");
                return paths1[3].compareTo(paths2[3]);
            }).collect(Collectors.toList());
            fieldRootPaths.forEach(fieldRootPath -> {
                String[] paths = fieldRootPath.split("/");
                VersionBo currentBo = (VersionBo)currentVersionBos.get(paths[1]);
                VersionBoIndex currentIndex = (VersionBoIndex)currentBo.getBoIndexes().get(paths[3]);
                VersionBo deployBo = (VersionBo)deployVersionBos.get(paths[1]);
                VersionBoIndex deployIndex = (VersionBoIndex)deployBo.getBoIndexes().get(paths[3]);
                IndexMeta indexMeta = DdlGenUtil.buildIndexMeta(appCodeForDB, currentBo.getCode(), currentIndex);
                indexMeta.setNewType(deployIndex.getType());
                indexMeta.setNewFieldCodes(deployIndex.getFieldCodes());
                sql.append(sqlGenerator.index(indexMeta, DdlOpEnum.MODIFY).getSql()).append("\n");
                rSql.append(sqlGenerator.index(indexMeta, DdlOpEnum.MODIFY).getRSql()).append("\n");
            });
        }
        boSqls.add(sql);
        boRSqls.add(rSql);
    }

    private static /* synthetic */ void lambda$genDdlListNewest$4(SqlGenerator sqlGenerator, List boSqls, List boRSqls, TableMeta tableMeta) {
        StringBuffer sql = new StringBuffer(sqlGenerator.table(tableMeta, DdlOpEnum.CREATE).getSql() + "\n");
        StringBuffer rSql = new StringBuffer(sqlGenerator.table(tableMeta, DdlOpEnum.CREATE).getRSql() + "\n");
        boSqls.add(sql);
        boRSqls.add(rSql);
    }

    private static /* synthetic */ void lambda$genDdlListByAppVersion$0(SqlGenerator sqlGenerator, List boSqls, List boRSqls, TableMeta tableMeta) {
        StringBuffer sql = new StringBuffer(sqlGenerator.table(tableMeta, DdlOpEnum.CREATE).getSql() + "\n");
        StringBuffer rSql = new StringBuffer(sqlGenerator.table(tableMeta, DdlOpEnum.CREATE).getRSql() + "\n");
        boSqls.add(sql);
        boRSqls.add(rSql);
    }
}

