/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.base.ddlgen;

import com.xforceplus.ultraman.bocp.gen.autodb.solution.FieldAttrMeta;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.FieldMeta;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.IndexMeta;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.RelationType;
import com.xforceplus.ultraman.bocp.metadata.util.FieldTypeUtil;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoField;
import com.xforceplus.ultraman.bocp.metadata.version.vo.VersionBoIndex;
import com.xforceplus.ultraman.metadata.global.common.util.AppDBUtil;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DdlGenUtil {
    public static void buildFieldTypeAndLength(VersionBoField boField) {
        switch (boField.getType()) {
            case "formula": 
            case "domainNo": 
            case "enum": 
            case "enums": 
            case "string": 
            case "strings": {
                boField.setMaxLength(Optional.ofNullable(boField.getMaxLength()).orElse("255"));
                break;
            }
            case "text": 
            case "shortText": 
            case "longText": 
            case "richText": {
                boField.setMaxLength(Optional.ofNullable(boField.getMaxLength()).orElse("1000"));
                break;
            }
            case "serialNo": 
            case "bigint": 
            case "decimal": 
            case "double": 
            case "float": 
            case "integer": 
            case "long": 
            case "number": {
                boField.setMaxLength(Optional.ofNullable(boField.getMaxLength()).orElse("20"));
                break;
            }
            default: {
                boField.setMaxLength(Optional.ofNullable(boField.getMaxLength()).orElse("255"));
            }
        }
        if ("formula".equals(boField.getType()) || "domainNo".equals(boField.getType())) {
            if (!StringUtils.isEmpty((CharSequence)boField.getValueType())) {
                boField.setType(FieldType.getValue((String)boField.getValueType()).code());
            } else {
                boField.setType(FieldType.STRING.code());
            }
        } else if ("lookup".equals(boField.getType())) {
            if (!StringUtils.isEmpty((CharSequence)boField.getValueType())) {
                boField.setType(FieldType.getValue((String)boField.getValueType()).code());
            } else {
                boField.setType(FieldType.STRING.code());
            }
        } else if ("aggregation".equals(boField.getType())) {
            if (!StringUtils.isEmpty((CharSequence)boField.getValueType())) {
                boField.setType(FieldType.getValue((String)boField.getValueType()).code());
            } else {
                boField.setType(FieldType.LONG.code());
            }
        }
        if (RelationType.MV.code().equals(boField.getType())) {
            boField.setType("json");
            boField.setMaxLength(null);
        } else {
            boField.setType(FieldType.getValue((String)boField.getType()).code());
        }
        if (FieldType.STRING.code().equals(boField.getType()) && Long.parseLong(boField.getMaxLength()) > 255L) {
            boField.setType(FieldType.SHORTTEXT.code());
        }
        if (FieldType.LONG.code().equals(boField.getType()) && Long.parseLong(boField.getMaxLength()) <= 4L) {
            boField.setType("tinyint");
        }
        if (FieldType.BOOLEAN.code().equals(boField.getType())) {
            boField.setType("tinyint");
            boField.setMaxLength("1");
            if (StringUtils.isNotBlank((CharSequence)boField.getDefaultValue())) {
                boField.setDefaultValue(Boolean.parseBoolean(boField.getDefaultValue()) ? "1" : "0");
            }
        }
        if (FieldType.DATETIME.code().equals(boField.getType())) {
            boField.setType("int");
            boField.setMaxLength("20");
        }
        boField.setType(FieldTypeUtil.convertColumnTypeForDDL((String)boField.getType()));
    }

    public static FieldMeta buildFieldMeta(String appCodeForDB, String boCode, VersionBoField field) {
        FieldMeta fieldMeta = new FieldMeta();
        fieldMeta.setTableCode(AppDBUtil.getTableName((String)appCodeForDB, (String)boCode));
        fieldMeta.setCode(field.getCode());
        fieldMeta.setType(field.getType());
        fieldMeta.setAttr(DdlGenUtil.buildFieldAttrMeta(field));
        return fieldMeta;
    }

    public static FieldAttrMeta buildFieldAttrMeta(VersionBoField field) {
        FieldAttrMeta attrMeta = new FieldAttrMeta();
        attrMeta.setName(field.getName());
        attrMeta.setDefaultValue(field.getDefaultValue());
        attrMeta.setMaxLength((Integer)Optional.ofNullable(field.getMaxLength()).map(Integer::valueOf).orElse(null));
        attrMeta.setDecimalPoint(Optional.ofNullable(field.getDecimalPoint()).map(Integer::parseInt).orElse(0));
        attrMeta.setNotNull("0".equals(String.valueOf(field.getRequired())));
        attrMeta.setDynamic("1".equals(field.getDynamicType()));
        return attrMeta;
    }

    public static IndexMeta buildIndexMeta(String appCodeForDB, String boCode, VersionBoIndex index) {
        IndexMeta indexMeta = new IndexMeta();
        indexMeta.setCode(index.getCode());
        indexMeta.setType(index.getType());
        indexMeta.setFieldCodes(index.getFieldCodes());
        indexMeta.setTableCode(AppDBUtil.getTableName((String)appCodeForDB, (String)boCode));
        return indexMeta;
    }
}

