/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.base.ddlgen;

import com.xforceplus.ultraman.bocp.metadata.enums.CustomType;
import com.xforceplus.ultraman.bocp.metadata.enums.SysType;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.metadata.generate.base.ddlgen.DdlGenBase;
import com.xforceplus.ultraman.metadata.global.common.util.AppDBUtil;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantAppVersionMetadataMergeService;
import io.vavr.Tuple2;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@SkipDataAuth
@Service
public class TenantDdlGenExecutor
extends DdlGenBase {
    @Autowired
    private ITenantAppVersionMetadataMergeService tenantAppVersionMetadataMergeService;

    public Tuple2<List<StringBuffer>, List<StringBuffer>> genDdlListNewest(Long appId, String appCodeForDB) {
        List mergeBos = this.tenantAppVersionMetadataMergeService.getBos(appId);
        List<Bo> tenantBos = mergeBos.stream().filter(o -> CustomType.CUSTOM.code().equals(o.getCustomType())).collect(Collectors.toList());
        return this.filter(appCodeForDB, tenantBos, this.genDdlListNewest(mergeBos, appCodeForDB));
    }

    public Tuple2<List<StringBuffer>, List<StringBuffer>> genDdlListByDiff(Long currentVersionId, Long deployVersionId, String appCodeForDB) {
        List currentBos = this.tenantAppVersionMetadataMergeService.getVersionBos(currentVersionId);
        List deployBos = this.tenantAppVersionMetadataMergeService.getVersionBos(deployVersionId);
        List tenantBos = ListUtils.union(currentBos.stream().filter(o -> CustomType.CUSTOM.code().equals(o.getCustomType())).collect(Collectors.toList()), deployBos.stream().filter(o -> CustomType.CUSTOM.code().equals(o.getCustomType())).collect(Collectors.toList()));
        return this.filter(appCodeForDB, tenantBos, this.genDdlListByDiff(currentBos, deployBos, appCodeForDB));
    }

    public Tuple2<List<StringBuffer>, List<StringBuffer>> genDdlListByAppVersion(Long appVersionId, String appCodeForDB) {
        List<Bo> mergeBos = this.tenantAppVersionMetadataMergeService.getVersionBos(appVersionId).stream().filter(o -> !SysType.SYSTEM.code().equals(o.getSysType())).collect(Collectors.toList());
        List<Bo> tenantBos = mergeBos.stream().filter(o -> CustomType.CUSTOM.code().equals(o.getCustomType())).collect(Collectors.toList());
        return this.filter(appCodeForDB, tenantBos, this.genDdlListByAppVersion(mergeBos, appCodeForDB));
    }

    private Tuple2<List<StringBuffer>, List<StringBuffer>> filter(String appCodeForDB, List<Bo> tenantBos, Tuple2<List<StringBuffer>, List<StringBuffer>> result) {
        List tenantTableList = tenantBos.stream().map(o -> String.format("oqs_%s_%s", appCodeForDB, AppDBUtil.getTenantBoCode((String)o.getCode(), (String)o.getTenantCode()))).distinct().collect(Collectors.toList());
        List tenantTableViewList = tenantTableList.stream().map(o -> String.format("%s_view", o)).collect(Collectors.toList());
        return result.map((o1, o2) -> new Tuple2(o1.stream().filter(o -> tenantTableList.stream().anyMatch(c -> o.toString().contains((CharSequence)c)) || tenantTableViewList.stream().anyMatch(c -> o.toString().contains((CharSequence)c))).collect(Collectors.toList()), o2.stream().filter(o -> tenantTableList.stream().anyMatch(c -> o.toString().contains((CharSequence)c)) || tenantTableViewList.stream().anyMatch(c -> o.toString().contains((CharSequence)c))).collect(Collectors.toList())));
    }
}

