/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.generate.maven;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.enums.PackageFlag;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.AppMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.AppVersionMapper;
import com.xforceplus.ultraman.metadata.generate.util.CodeGenUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MavenInvokerManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Invoker invoker;
    @Autowired
    AppMapper appMapper;
    @Autowired
    AppVersionMapper appVersionMapper;

    @PostConstruct
    void init() {
        this.invoker = new DefaultInvoker();
        try {
            this.invoker.setMavenHome(new File(System.getenv("M3_HOME")));
        }
        catch (Exception e) {
            this.logger.error("set maven home path failed");
        }
    }

    public void executeDeploy(Long appId, String version) {
        this.logger.debug("app {} version {} maven deploy start", (Object)appId, (Object)version);
        App app = (App)this.appMapper.selectById((Serializable)appId);
        String pomFilePath = CodeGenUtil.getAppDir(app);
        this.logger.debug("app {} version {} maven deploy pom path:{}", new Object[]{appId, version, pomFilePath});
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(pomFilePath));
        request.setGoals(Collections.singletonList("clean deploy -DskipTests"));
        request.setShowErrors(true);
        request.setBatchMode(true);
        request.setQuiet(true);
        ArrayList errorLog = Lists.newArrayList();
        request.setOutputHandler(s -> {
            if (s.contains("[ERROR]")) {
                errorLog.add(s);
                this.logger.error(s);
            } else {
                this.logger.debug(s);
            }
        });
        InvocationResult result = null;
        String exceptionMsg = null;
        try {
            this.logger.debug("app {} version {} maven invoker start execute", (Object)appId, (Object)version);
            result = this.invoker.execute((InvocationRequest)request);
            this.logger.debug("app {} version {} maven invoker finish execute", (Object)appId, (Object)version);
        }
        catch (MavenInvocationException e) {
            exceptionMsg = e.getMessage();
            this.logger.error(String.format("module %d maven invoker error", appId, version), (Throwable)e);
        }
        this.savePackageErrorLog(result, appId, version, errorLog, exceptionMsg);
        this.logger.info("app {} version {} maven deploy finish", (Object)appId, (Object)version);
    }

    public void executeDeployForSdk(Long appId, String version) {
        this.logger.debug("app {} version {} maven deploy metadata start", (Object)appId, (Object)version);
        App app = (App)this.appMapper.selectById((Serializable)appId);
        String pomFilePath = CodeGenUtil.getAppDirForSdk(app);
        this.logger.debug("app {} version {} maven deploy pom path:{}", new Object[]{appId, version, pomFilePath});
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(new File(pomFilePath));
        request.setGoals(Collections.singletonList("clean deploy -DskipTests"));
        request.setShowErrors(true);
        request.setBatchMode(true);
        request.setQuiet(true);
        ArrayList errorLog = Lists.newArrayList();
        request.setOutputHandler(s -> {
            if (s.contains("[ERROR]")) {
                errorLog.add(s);
                this.logger.error(s);
            } else {
                this.logger.debug(s);
            }
        });
        InvocationResult result = null;
        String exceptionMsg = null;
        try {
            this.logger.debug("app {} version {} maven invoker start execute metadata", (Object)appId, (Object)version);
            result = this.invoker.execute((InvocationRequest)request);
            this.logger.debug("app {} version {} maven invoker finish execute metadata", (Object)appId, (Object)version);
        }
        catch (MavenInvocationException e) {
            exceptionMsg = e.getMessage();
            this.logger.error(String.format("module %d maven invoker error", appId, version), (Throwable)e);
        }
        this.logger.debug("app {} version {} maven deploy metadata finish", (Object)appId, (Object)version);
    }

    private void savePackageErrorLog(InvocationResult result, Long appId, String version, List<String> errorLog, String exceptionMsg) {
        AppVersion appVersion = (AppVersion)this.appVersionMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppVersion::getAppId, (Object)appId)).eq(AppVersion::getVersion, (Object)version)).eq(AppVersion::getDeleteFlag, (Object)"1"));
        this.logger.debug("app {} version {} start to save package status ", (Object)appId, (Object)version);
        if (appVersion != null) {
            if (!errorLog.isEmpty()) {
                String error = errorLog.stream().collect(Collectors.joining("\n"));
                error = error.length() < 6600 ? error : error.substring(0, 6600);
                appVersion.setPackageResult(error);
                appVersion.setPackageFlag(PackageFlag.PACKAGE_FAIL.code());
            } else if (result == null) {
                appVersion.setPackageFlag(PackageFlag.PACKAGE_FAIL.code());
                appVersion.setPackageResult(String.format("app %d version %s execute error result is null and err msg: %s", appId, version, exceptionMsg));
            } else if (result.getExitCode() != 0) {
                appVersion.setPackageFlag(PackageFlag.PACKAGE_FAIL.code());
                appVersion.setPackageResult(String.format("app %d version %s execute error result exitcode: %d and err msg: %s", appId, version, result.getExitCode(), result.getExecutionException() == null ? null : result.getExecutionException().toString()));
            } else {
                appVersion.setPackageFlag(PackageFlag.PACKAGE_SUCCESS.code());
                appVersion.setPackageResult(null);
            }
            this.appVersionMapper.alwaysUpdateSomeColumnById((Object)appVersion);
            this.logger.debug("app {} version {} finish to save package status flag:{}", new Object[]{appId, version, appVersion.getPackageFlag()});
        }
    }
}

